/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.zip.Checksum;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.FSInputChecker;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.protocol.DataTransferProtocol;
import org.apache.hadoop.hdfs.security.BlockAccessToken;
import org.apache.hadoop.hdfs.security.InvalidAccessTokenException;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.DataChecksum;

@InterfaceAudience.Private
public class BlockReader
extends FSInputChecker {
    Socket dnSock;
    private DataInputStream in;
    private DataChecksum checksum;
    private long lastChunkOffset = -1L;
    private long lastChunkLen = -1L;
    private long lastSeqNo = -1L;
    private long startOffset;
    private final long firstChunkOffset;
    private int bytesPerChecksum;
    private int checksumSize;
    private final long bytesNeededToFinish;
    private boolean gotEOS = false;
    byte[] skipBuf = null;
    ByteBuffer checksumBytes = null;
    int dataLeft = 0;

    public synchronized int read(byte[] buf, int off, int len) throws IOException {
        boolean eosBefore = this.gotEOS;
        if (this.lastChunkLen < 0L && this.startOffset > this.firstChunkOffset && len > 0) {
            int toSkip = (int)(this.startOffset - this.firstChunkOffset);
            if (this.skipBuf == null) {
                this.skipBuf = new byte[this.bytesPerChecksum];
            }
            if (super.read(this.skipBuf, 0, toSkip) != toSkip) {
                throw new IOException("Could not skip required number of bytes");
            }
        }
        int nRead = super.read(buf, off, len);
        if (this.gotEOS && !eosBefore && nRead >= 0 && this.needChecksum()) {
            this.checksumOk(this.dnSock);
        }
        return nRead;
    }

    public synchronized long skip(long n) throws IOException {
        long nSkipped;
        int ret;
        if (this.skipBuf == null) {
            this.skipBuf = new byte[this.bytesPerChecksum];
        }
        for (nSkipped = 0L; nSkipped < n; nSkipped += (long)ret) {
            int toSkip = (int)Math.min(n - nSkipped, (long)this.skipBuf.length);
            ret = this.read(this.skipBuf, 0, toSkip);
            if (ret > 0) continue;
            return nSkipped;
        }
        return nSkipped;
    }

    public int read() throws IOException {
        throw new IOException("read() is not expected to be invoked. Use read(buf, off, len) instead.");
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    public void seek(long pos) throws IOException {
        throw new IOException("Seek() is not supported in BlockInputChecker");
    }

    protected long getChunkPosition(long pos) {
        throw new RuntimeException("getChunkPosition() is not supported, since seek is not required");
    }

    private void adjustChecksumBytes(int dataLen) {
        int requiredSize = (dataLen + this.bytesPerChecksum - 1) / this.bytesPerChecksum * this.checksumSize;
        if (this.checksumBytes == null || requiredSize > this.checksumBytes.capacity()) {
            this.checksumBytes = ByteBuffer.wrap(new byte[requiredSize]);
        } else {
            this.checksumBytes.clear();
        }
        this.checksumBytes.limit(requiredSize);
    }

    protected synchronized int readChunk(long pos, byte[] buf, int offset, int len, byte[] checksumBuf) throws IOException {
        int bytesToRead;
        int checksumsToRead;
        if (this.gotEOS) {
            return -1;
        }
        long chunkOffset = this.lastChunkOffset;
        if (this.lastChunkLen > 0L) {
            chunkOffset += this.lastChunkLen;
        }
        if (pos + this.firstChunkOffset != chunkOffset) {
            throw new IOException("Mismatch in pos : " + pos + " + " + this.firstChunkOffset + " != " + chunkOffset);
        }
        if (this.dataLeft <= 0) {
            int dataLen;
            int packetLen = this.in.readInt();
            long offsetInBlock = this.in.readLong();
            long seqno = this.in.readLong();
            boolean lastPacketInBlock = this.in.readBoolean();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("DFSClient readChunk got seqno " + seqno + " offsetInBlock " + offsetInBlock + " lastPacketInBlock " + lastPacketInBlock + " packetLen " + packetLen));
            }
            if ((dataLen = this.in.readInt()) <= 0 && !lastPacketInBlock || dataLen != 0 && lastPacketInBlock || seqno != this.lastSeqNo + 1L) {
                throw new IOException("BlockReader: error in packet header(chunkOffset : " + chunkOffset + ", dataLen : " + dataLen + ", seqno : " + seqno + " (last: " + this.lastSeqNo + "))");
            }
            this.lastSeqNo = seqno;
            this.dataLeft = dataLen;
            this.adjustChecksumBytes(dataLen);
            if (dataLen > 0) {
                IOUtils.readFully((InputStream)this.in, (byte[])this.checksumBytes.array(), (int)0, (int)this.checksumBytes.limit());
            }
        }
        assert (len >= this.bytesPerChecksum);
        assert (this.checksum != null);
        assert (this.checksumSize == 0 || checksumBuf.length % this.checksumSize == 0);
        if (this.checksumSize > 0) {
            int chunksLeft = (this.dataLeft - 1) / this.bytesPerChecksum + 1;
            int chunksCanFit = Math.min(len / this.bytesPerChecksum, checksumBuf.length / this.checksumSize);
            checksumsToRead = Math.min(chunksLeft, chunksCanFit);
            bytesToRead = Math.min(checksumsToRead * this.bytesPerChecksum, this.dataLeft);
        } else {
            bytesToRead = Math.min(this.dataLeft, len);
            checksumsToRead = 0;
        }
        if (bytesToRead > 0) {
            assert (bytesToRead <= len);
            assert (this.checksumBytes.remaining() >= this.checksumSize * checksumsToRead);
            assert (checksumBuf.length >= this.checksumSize * checksumsToRead);
            IOUtils.readFully((InputStream)this.in, (byte[])buf, (int)offset, (int)bytesToRead);
            this.checksumBytes.get(checksumBuf, 0, this.checksumSize * checksumsToRead);
        }
        this.dataLeft -= bytesToRead;
        assert (this.dataLeft >= 0);
        this.lastChunkOffset = chunkOffset;
        this.lastChunkLen = bytesToRead;
        if (this.dataLeft == 0 && pos + (long)bytesToRead >= this.bytesNeededToFinish) {
            int packetLen = this.in.readInt();
            long offsetInBlock = this.in.readLong();
            long seqno = this.in.readLong();
            boolean lastPacketInBlock = this.in.readBoolean();
            int dataLen = this.in.readInt();
            if (!lastPacketInBlock || dataLen != 0) {
                throw new IOException("Expected empty end-of-read packet! Header: (packetLen : " + packetLen + ", offsetInBlock : " + offsetInBlock + ", seqno : " + seqno + ", lastInBlock : " + lastPacketInBlock + ", dataLen : " + dataLen);
            }
            this.gotEOS = true;
        }
        if (bytesToRead == 0) {
            return -1;
        }
        return bytesToRead;
    }

    private BlockReader(String file, long blockId, DataInputStream in, DataChecksum checksum, boolean verifyChecksum, long startOffset, long firstChunkOffset, long bytesToRead, Socket dnSock) {
        super(new Path("/blk_" + blockId + ":of:" + file), 1, verifyChecksum, (Checksum)(checksum.getChecksumSize() > 0 ? checksum : null), checksum.getBytesPerChecksum(), checksum.getChecksumSize());
        this.dnSock = dnSock;
        this.in = in;
        this.checksum = checksum;
        this.startOffset = Math.max(startOffset, 0L);
        this.bytesNeededToFinish = bytesToRead + (startOffset - firstChunkOffset);
        this.firstChunkOffset = firstChunkOffset;
        this.lastChunkOffset = firstChunkOffset;
        this.lastChunkLen = -1L;
        this.bytesPerChecksum = this.checksum.getBytesPerChecksum();
        this.checksumSize = this.checksum.getChecksumSize();
    }

    public static BlockReader newBlockReader(Socket sock, String file, long blockId, BlockAccessToken accessToken, long genStamp, long startOffset, long len, int bufferSize) throws IOException {
        return BlockReader.newBlockReader(sock, file, blockId, accessToken, genStamp, startOffset, len, bufferSize, true);
    }

    public static BlockReader newBlockReader(Socket sock, String file, long blockId, BlockAccessToken accessToken, long genStamp, long startOffset, long len, int bufferSize, boolean verifyChecksum) throws IOException {
        return BlockReader.newBlockReader(sock, file, blockId, accessToken, genStamp, startOffset, len, bufferSize, verifyChecksum, "");
    }

    public static BlockReader newBlockReader(Socket sock, String file, long blockId, BlockAccessToken accessToken, long genStamp, long startOffset, long len, int bufferSize, boolean verifyChecksum, String clientName) throws IOException {
        DataTransferProtocol.Sender.opReadBlock(new DataOutputStream(new BufferedOutputStream(NetUtils.getOutputStream((Socket)sock, (long)480000L))), blockId, genStamp, startOffset, len, clientName, accessToken);
        DataInputStream in = new DataInputStream(new BufferedInputStream(NetUtils.getInputStream((Socket)sock), bufferSize));
        DataTransferProtocol.Status status = DataTransferProtocol.Status.read(in);
        if (status != DataTransferProtocol.Status.SUCCESS) {
            if (status == DataTransferProtocol.Status.ERROR_ACCESS_TOKEN) {
                throw new InvalidAccessTokenException("Got access token error for OP_READ_BLOCK, self=" + sock.getLocalSocketAddress() + ", remote=" + sock.getRemoteSocketAddress() + ", for file " + file + ", for block " + blockId + "_" + genStamp);
            }
            throw new IOException("Got error for OP_READ_BLOCK, self=" + sock.getLocalSocketAddress() + ", remote=" + sock.getRemoteSocketAddress() + ", for file " + file + ", for block " + blockId + "_" + genStamp);
        }
        DataChecksum checksum = DataChecksum.newDataChecksum((DataInputStream)in);
        long firstChunkOffset = in.readLong();
        if (firstChunkOffset < 0L || firstChunkOffset > startOffset || firstChunkOffset >= startOffset + (long)checksum.getBytesPerChecksum()) {
            throw new IOException("BlockReader: error in first chunk offset (" + firstChunkOffset + ") startOffset is " + startOffset + " for file " + file);
        }
        return new BlockReader(file, blockId, in, checksum, verifyChecksum, startOffset, firstChunkOffset, len, sock);
    }

    public synchronized void close() throws IOException {
        this.startOffset = -1L;
        this.checksum = null;
    }

    public int readAll(byte[] buf, int offset, int len) throws IOException {
        return BlockReader.readFully((InputStream)((Object)this), (byte[])buf, (int)offset, (int)len);
    }

    void checksumOk(Socket sock) {
        try {
            OutputStream out = NetUtils.getOutputStream((Socket)sock, (long)480000L);
            DataTransferProtocol.Status.CHECKSUM_OK.writeOutputStream(out);
            out.flush();
        }
        catch (IOException e) {
            LOG.debug((Object)("Could not write to datanode " + sock.getInetAddress() + ": " + e.getMessage()));
        }
    }
}

