/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class LongWritable
implements WritableComparable {
    private long value;

    public LongWritable() {
    }

    public LongWritable(long value) {
        this.set(value);
    }

    public void set(long value) {
        this.value = value;
    }

    public long get() {
        return this.value;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.value = in.readLong();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.value);
    }

    public boolean equals(Object o) {
        if (!(o instanceof LongWritable)) {
            return false;
        }
        LongWritable other = (LongWritable)o;
        return this.value == other.value;
    }

    public int hashCode() {
        return (int)this.value;
    }

    @Override
    public int compareTo(Object o) {
        long thisValue = this.value;
        long thatValue = ((LongWritable)o).value;
        return thisValue < thatValue ? -1 : (thisValue == thatValue ? 0 : 1);
    }

    public String toString() {
        return Long.toString(this.value);
    }

    static {
        WritableComparator.define(LongWritable.class, new Comparator());
    }

    public static class DecreasingComparator
    extends Comparator {
        @Override
        public int compare(WritableComparable a, WritableComparable b) {
            return -super.compare(a, b);
        }

        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            return -super.compare(b1, s1, l1, b2, s2, l2);
        }
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(LongWritable.class);
        }

        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            long thatValue;
            long thisValue = Comparator.readLong(b1, s1);
            return thisValue < (thatValue = Comparator.readLong(b2, s2)) ? -1 : (thisValue == thatValue ? 0 : 1);
        }
    }
}

