/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import java.util.ArrayList;
import org.apache.bcel.generic.Type;
import org.jibx.binding.classes.BoundClass;
import org.jibx.binding.classes.BranchTarget;
import org.jibx.binding.classes.BranchWrapper;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.classes.ContextMethodBuilder;
import org.jibx.binding.classes.ExceptionMethodBuilder;
import org.jibx.binding.classes.MethodBuilder;
import org.jibx.binding.classes.MungedClass;
import org.jibx.binding.def.BaseMappingWrapper;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.binding.def.DefinitionContext;
import org.jibx.binding.def.DirectObject;
import org.jibx.binding.def.DirectProperty;
import org.jibx.binding.def.ElementWrapper;
import org.jibx.binding.def.IComponent;
import org.jibx.binding.def.IContainer;
import org.jibx.binding.def.IMapping;
import org.jibx.binding.def.MappingBase;
import org.jibx.binding.def.NameDefinition;
import org.jibx.binding.def.NamespaceDefinition;
import org.jibx.binding.def.ObjectBinding;
import org.jibx.binding.def.PropertyDefinition;
import org.jibx.runtime.JiBXException;

public class MappingDefinition
extends MappingBase {
    private static final String ADAPTERCLASS_SUFFIX = "_access";
    private static final String MARSHAL_METHODNAME = "marshal";
    private static final String BASEMARSHAL_METHODNAME = "baseMarshal";
    private static final String UNMARSHAL_METHODNAME = "unmarshal";
    private static final String ISPRESENT_METHODNAME = "isPresent";
    private static final String UNMARSHALCONTEXT_CLASS = "org.jibx.runtime.impl.UnmarshallingContext";
    private static final String MARSHALCONTEXT_CLASS = "org.jibx.runtime.impl.MarshallingContext";
    private static final String UNMARSHAL_ISATMETHOD = "org.jibx.runtime.IUnmarshallingContext.isAt";
    private static final String UNMARSHAL_ISATSIGNATURE = "(Ljava/lang/String;Ljava/lang/String;)Z";
    private static final String CHECKEXTENDS_METHOD = "org.jibx.runtime.IMarshaller.isExtension";
    private static final String GETINDEX_METHOD = "org.jibx.runtime.IMarshallable.JiBX_getIndex";
    private static final String UNMARSHALLERPRESENT_METHOD = "org.jibx.runtime.IUnmarshaller.isPresent";
    private static final String UNMARSHALLERPRESENT_SIGNATURE = "(Lorg/jibx/runtime/IUnmarshallingContext;)Z";
    private static final String UNMARSHALCONTEXT_INTERFACE = "org.jibx.runtime.IUnmarshallingContext";
    private static final String MARSHALCONTEXT_INTERFACE = "org.jibx.runtime.IMarshallingContext";
    private static final String CURRENTELEMENT_METHOD = "org.jibx.runtime.impl.UnmarshallingContext.currentNameString";
    private static final String CURRENTELEMENT_SIGNATURE = "()Ljava/lang/String;";
    private static final String ADDUNMARSHALLER_METHOD = "org.jibx.runtime.impl.UnmarshallingContext.addUnmarshalling";
    private static final String ADDUNMARSHALLER_SIGNATURE = "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V";
    private static final String REMOVEUNMARSHALLER_METHOD = "org.jibx.runtime.impl.UnmarshallingContext.removeUnmarshalling";
    private static final String REMOVEUNMARSHALLER_SIGNATURE = "(I)V";
    private static final String ADDMARSHALLER_METHOD = "org.jibx.runtime.impl.MarshallingContext.addMarshalling";
    private static final String ADDMARSHALLER_SIGNATURE = "(ILjava/lang/String;)V";
    private static final String REMOVEMARSHALLER_METHOD = "org.jibx.runtime.impl.MarshallingContext.removeMarshalling";
    private static final String REMOVEMARSHALLER_SIGNATURE = "(I)V";
    private static final Type[] ISPRESENT_METHOD_ARGS = new Type[]{ClassItem.typeFromName("org.jibx.runtime.IUnmarshallingContext")};
    private static final Type[] UNMARSHAL_METHOD_ARGS = new Type[]{Type.OBJECT, ClassItem.typeFromName("org.jibx.runtime.IUnmarshallingContext")};
    private static final Type[] MARSHAL_METHOD_ARGS = new Type[]{Type.OBJECT, ClassItem.typeFromName("org.jibx.runtime.IMarshallingContext")};
    static final String[] UNMARSHALLER_INTERFACES = new String[]{"org.jibx.runtime.IUnmarshaller"};
    static final String[] MARSHALLER_INTERFACES = new String[]{"org.jibx.runtime.IMarshaller"};
    static final String[] BOTH_INTERFACES = new String[]{"org.jibx.runtime.IUnmarshaller", "org.jibx.runtime.IMarshaller"};
    private final IContainer m_container;
    private final DefinitionContext m_defContext;
    private final BoundClass m_class;
    private final NameDefinition m_name;
    private final boolean m_isAbstract;
    private final String m_baseType;
    private IMapping m_baseMapping;
    private ClassFile m_marshaller;
    private ClassFile m_unmarshaller;
    private ArrayList m_extensions;

    public MappingDefinition(IContainer contain, DefinitionContext defc, String type, NameDefinition name, boolean abs, String base, IComponent bind) throws JiBXException {
        super(contain, type);
        if (name == null) {
            this.setWrappedComponent(bind);
        } else {
            this.setWrappedComponent(new ElementWrapper(defc, name, bind));
        }
        this.m_container = contain;
        this.m_defContext = defc;
        this.m_class = BoundClass.getInstance(type, null);
        this.m_name = name;
        this.m_isAbstract = abs;
        if (abs) {
            this.m_extensions = new ArrayList();
        }
        this.m_baseType = base;
    }

    boolean hasNamespace() {
        return this.m_defContext.hasNamespace();
    }

    void genLoadNamespaces(MethodBuilder mb) throws JiBXException {
        this.m_defContext.genLoadNamespaces(mb);
    }

    public BoundClass getBoundClass() {
        return this.m_class;
    }

    public String getBoundType() {
        return this.m_class.getClassName();
    }

    public IComponent getImplComponent() {
        return this.m_component;
    }

    public ClassFile getMarshaller() {
        return this.m_marshaller;
    }

    public ClassFile getUnmarshaller() {
        return this.m_unmarshaller;
    }

    public NameDefinition getName() {
        return this.m_name;
    }

    public void addNamespace(NamespaceDefinition ns) throws JiBXException {
        this.m_defContext.addNamespace(ns);
    }

    public boolean isAbstract() {
        return this.m_isAbstract;
    }

    public void addExtension(MappingDefinition mdef) {
        if (!this.m_extensions.contains(mdef)) {
            this.m_extensions.add(mdef);
        }
    }

    public IComponent buildRef(IContainer parent, String type, PropertyDefinition prop) throws JiBXException {
        if (this.m_isAbstract && prop.isThis()) {
            if (this.m_component instanceof ObjectBinding) {
                ((ObjectBinding)this.m_component).setAbstract(true);
            }
            return new BaseMappingWrapper(this.m_component);
        }
        boolean abs = this.m_isAbstract && !prop.isThis();
        DirectObject dobj = new DirectObject(this.m_container, null, this.m_class.getClassFile(), abs, this.m_marshaller, this.m_unmarshaller, this.getIndex(), null);
        return new DirectProperty(prop, dobj);
    }

    public void generateCode() throws JiBXException {
        ContextMethodBuilder mb;
        this.m_defContext.generateCode();
        ClassFile target = this.m_class.getMungedFile();
        BindingDefinition def = this.m_container.getBindingRoot();
        String name = target.deriveClassName(def.getPrefix(), ADAPTERCLASS_SUFFIX);
        ClassFile base = ClassCache.getClassFile("java.lang.Object");
        String[] intfs = def.isInput() ? (def.isOutput() ? BOTH_INTERFACES : UNMARSHALLER_INTERFACES) : MARSHALLER_INTERFACES;
        ClassFile cf = new ClassFile(name, target.getRoot(), base, 1, intfs);
        cf.addDefaultConstructor();
        boolean hasattr = !this.m_isAbstract && this.m_component.hasAttribute();
        boolean hascont = this.m_component.hasContent();
        if (def.isInput()) {
            int i;
            mb = new ContextMethodBuilder(ISPRESENT_METHODNAME, Type.BOOLEAN, ISPRESENT_METHOD_ARGS, cf, 17, -1, null, 1, UNMARSHALCONTEXT_INTERFACE);
            if (this.m_isAbstract) {
                mb.addException("org.jibx.runtime.JiBXException");
                BranchWrapper[] iffounds = new BranchWrapper[this.m_extensions.size()];
                if (iffounds.length > 0) {
                    for (int i2 = 0; i2 < iffounds.length; ++i2) {
                        IMapping map = (IMapping)this.m_extensions.get(i2);
                        mb.loadContext();
                        mb.appendLoadConstant(map.getIndex());
                        mb.appendCallInterface("org.jibx.runtime.IUnmarshallingContext.getUnmarshaller", "(I)Lorg/jibx/runtime/IUnmarshaller;");
                        mb.loadContext();
                        mb.appendCallInterface(UNMARSHALLERPRESENT_METHOD, UNMARSHALLERPRESENT_SIGNATURE);
                        iffounds[i2] = mb.appendIFNE(this);
                    }
                    mb.appendICONST_0();
                    mb.appendReturn("int");
                    mb.initStackState(iffounds[0]);
                    BranchTarget found = mb.appendTargetLoadConstant(1);
                    for (int i3 = 0; i3 < iffounds.length; ++i3) {
                        iffounds[i3].setTarget(found, mb);
                    }
                } else {
                    mb.appendLoadConstant(1);
                }
            } else if (this.m_name == null) {
                mb.appendICONST_1();
            } else {
                mb.addException("org.jibx.runtime.JiBXException");
                mb.loadContext();
                this.m_name.genPushUriPair(mb);
                mb.appendCallInterface(UNMARSHAL_ISATMETHOD, UNMARSHAL_ISATSIGNATURE);
            }
            mb.appendReturn("int");
            mb.codeComplete(false);
            mb.addMethod();
            String type = this.m_class.getClassName();
            mb = new ContextMethodBuilder(UNMARSHAL_METHODNAME, Type.OBJECT, UNMARSHAL_METHOD_ARGS, cf, 17, 1, type, 2, UNMARSHALCONTEXT_INTERFACE);
            mb.addException("org.jibx.runtime.JiBXException");
            mb.loadObject();
            BranchWrapper ifnnull = mb.appendIFNONNULL(this);
            if (this.m_isAbstract) {
                BranchWrapper[] iffounds = new BranchWrapper[this.m_extensions.size()];
                for (i = 0; i < iffounds.length; ++i) {
                    IMapping map = (IMapping)this.m_extensions.get(i);
                    mb.loadContext();
                    mb.appendLoadConstant(map.getIndex());
                    mb.appendCallInterface("org.jibx.runtime.IUnmarshallingContext.getUnmarshaller", "(I)Lorg/jibx/runtime/IUnmarshaller;");
                    mb.appendDUP();
                    mb.loadContext();
                    mb.appendCallInterface(UNMARSHALLERPRESENT_METHOD, UNMARSHALLERPRESENT_SIGNATURE);
                    iffounds[i] = mb.appendIFNE(this);
                    mb.appendPOP();
                }
                mb.appendCreateNew("java.lang.StringBuffer");
                mb.appendDUP();
                mb.appendLoadConstant("Element ");
                mb.appendCallInit("java.lang.StringBuffer", "(Ljava/lang/String;)V");
                mb.appendDUP();
                mb.loadContext(UNMARSHALCONTEXT_CLASS);
                mb.appendCallVirtual(CURRENTELEMENT_METHOD, CURRENTELEMENT_SIGNATURE);
                mb.appendCallVirtual("java.lang.StringBuffer.append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;");
                mb.appendDUP();
                mb.appendLoadConstant(" has no mapping that extends " + this.m_class.getClassName());
                mb.appendCallVirtual("java.lang.StringBuffer.append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;");
                mb.appendCallVirtual("java.lang.StringBuffer.toString", CURRENTELEMENT_SIGNATURE);
                mb.appendCreateNew("org.jibx.runtime.JiBXException");
                mb.appendDUP_X1();
                mb.appendSWAP();
                mb.appendCallInit("org.jibx.runtime.JiBXException", "(Ljava/lang/String;)V");
                mb.appendThrow();
                if (iffounds.length > 0) {
                    mb.initStackState(iffounds[0]);
                    BranchTarget found = mb.appendTargetACONST_NULL();
                    for (int i4 = 0; i4 < iffounds.length; ++i4) {
                        iffounds[i4].setTarget(found, mb);
                    }
                    mb.loadContext();
                    mb.appendCallInterface("org.jibx.runtime.IUnmarshaller.unmarshal", "(Ljava/lang/Object;Lorg/jibx/runtime/IUnmarshallingContext;)Ljava/lang/Object;");
                    mb.appendReturn("java.lang.Object");
                }
            } else {
                this.genNewInstance(mb);
                mb.storeObject();
            }
            ArrayList maps = this.m_defContext.getMappings();
            if (maps != null && maps.size() > 0) {
                for (i = 0; i < maps.size(); ++i) {
                    mb.loadContext(UNMARSHALCONTEXT_CLASS);
                    IMapping map = (IMapping)maps.get(i);
                    mb.appendLoadConstant(map.getIndex());
                    map.getName().genPushUriPair(mb);
                    mb.appendLoadConstant(map.getUnmarshaller().getName());
                    mb.appendCallVirtual(ADDUNMARSHALLER_METHOD, ADDUNMARSHALLER_SIGNATURE);
                }
            }
            mb.targetNext(ifnnull);
            mb.loadObject();
            mb.appendCreateCast(type);
            if (hasattr) {
                mb.appendDUP();
                this.m_component.genAttributeUnmarshal(mb);
            }
            if (hascont) {
                mb.appendDUP();
                this.m_component.genContentUnmarshal(mb);
            }
            if (maps != null && maps.size() > 0) {
                for (i = 0; i < maps.size(); ++i) {
                    mb.loadContext(UNMARSHALCONTEXT_CLASS);
                    IMapping map = (IMapping)maps.get(i);
                    mb.appendLoadConstant(map.getIndex());
                    mb.appendCallVirtual(REMOVEUNMARSHALLER_METHOD, "(I)V");
                }
            }
            mb.appendReturn("java.lang.Object");
            mb.codeComplete(false);
            mb.addMethod();
            if (this.m_name != null && !this.m_isAbstract && this.m_class.getClassFile() == this.m_class.getMungedFile()) {
                this.addIUnmarshallableMethod();
            }
        }
        if (def.isOutput()) {
            IMapping map;
            mb = new ContextMethodBuilder(MARSHAL_METHODNAME, Type.VOID, MARSHAL_METHOD_ARGS, cf, 17, 1, "java.lang.Object", 2, MARSHALCONTEXT_INTERFACE);
            mb.addException("org.jibx.runtime.JiBXException");
            ArrayList maps = this.m_defContext.getMappings();
            if (maps != null && maps.size() > 0) {
                for (int i = 0; i < maps.size(); ++i) {
                    mb.loadContext(MARSHALCONTEXT_CLASS);
                    map = (IMapping)maps.get(i);
                    mb.appendLoadConstant(map.getIndex());
                    mb.appendLoadConstant(map.getMarshaller().getName());
                    mb.appendCallVirtual(ADDMARSHALLER_METHOD, ADDMARSHALLER_SIGNATURE);
                }
            }
            if (hasattr || hascont) {
                mb.loadObject(this.m_class.getClassName());
                if (hasattr) {
                    if (hascont) {
                        mb.appendDUP();
                    }
                    this.m_component.genAttributeMarshal(mb);
                }
                if (hascont) {
                    this.m_component.genContentMarshal(mb);
                }
            }
            if (maps != null && maps.size() > 0) {
                for (int i = 0; i < maps.size(); ++i) {
                    mb.loadContext(MARSHALCONTEXT_CLASS);
                    map = (IMapping)maps.get(i);
                    mb.appendLoadConstant(map.getIndex());
                    mb.appendCallVirtual(REMOVEMARSHALLER_METHOD, "(I)V");
                }
            }
            mb.appendReturn();
            mb.codeComplete(false);
            mb.addMethod();
            ExceptionMethodBuilder xb = new ExceptionMethodBuilder("isExtension", "(I)Z", cf, 17);
            if (this.m_baseMapping == null) {
                xb.appendICONST_0();
            } else {
                xb.appendLoadLocal(1);
                xb.appendLoadConstant(this.m_baseMapping.getIndex());
                xb.appendISUB();
                BranchWrapper iftrue = xb.appendIFEQ(this);
                xb.appendICONST_0();
                xb.appendReturn("int");
                xb.targetNext(iftrue);
                xb.appendICONST_1();
            }
            xb.appendReturn("int");
            xb.codeComplete(false);
            xb.addMethod();
            if (this.m_name != null && !this.m_isAbstract && this.m_class.getClassFile() == this.m_class.getMungedFile()) {
                this.addIMarshallableMethod();
            }
            if (this.m_isAbstract) {
                mb = new ContextMethodBuilder(BASEMARSHAL_METHODNAME, Type.VOID, MARSHAL_METHOD_ARGS, cf, 17, 1, "java.lang.Object", 2, MARSHALCONTEXT_INTERFACE);
                mb.addException("org.jibx.runtime.JiBXException");
                mb.loadContext();
                mb.loadObject("org.jibx.runtime.IMarshallable");
                mb.appendCallInterface(GETINDEX_METHOD, "()I");
                mb.loadObject();
                mb.appendCallVirtual("java.lang.Object.getClass", "()Ljava/lang/Class;");
                mb.appendCallVirtual("java.lang.Class.getName", CURRENTELEMENT_SIGNATURE);
                mb.appendCallInterface("org.jibx.runtime.IMarshallingContext.getMarshaller", "(ILjava/lang/String;)Lorg/jibx/runtime/IMarshaller;");
                mb.appendDUP();
                mb.appendLoadConstant(this.getIndex());
                mb.appendCallInterface(CHECKEXTENDS_METHOD, "(I)Z");
                BranchWrapper ifvalid = mb.appendIFNE(this);
                mb.appendCreateNew("java.lang.StringBuffer");
                mb.appendDUP();
                mb.appendLoadConstant("Mapping for type ");
                mb.appendCallInit("java.lang.StringBuffer", "(Ljava/lang/String;)V");
                mb.appendDUP();
                mb.loadObject();
                mb.appendCallVirtual("java.lang.Object.getClass", "()Ljava/lang/Class;");
                mb.appendCallVirtual("java.lang.Class.getName", CURRENTELEMENT_SIGNATURE);
                mb.appendCallVirtual("java.lang.StringBuffer.append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;");
                mb.appendDUP();
                mb.appendLoadConstant(" must extend abstract mapping for type " + this.m_class.getClassName());
                mb.appendCallVirtual("java.lang.StringBuffer.append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;");
                mb.appendCallVirtual("java.lang.StringBuffer.toString", CURRENTELEMENT_SIGNATURE);
                mb.appendCreateNew("org.jibx.runtime.JiBXException");
                mb.appendDUP_X1();
                mb.appendSWAP();
                mb.appendCallInit("org.jibx.runtime.JiBXException", "(Ljava/lang/String;)V");
                mb.appendThrow();
                mb.targetNext(ifvalid);
                mb.loadObject();
                mb.loadContext();
                mb.appendCallInterface("org.jibx.runtime.IMarshaller.marshal", "(Ljava/lang/Object;Lorg/jibx/runtime/IMarshallingContext;)V");
                mb.appendReturn();
                mb.codeComplete(false);
                mb.addMethod();
                cf.addInterface("org.jibx.runtime.IAbstractMarshaller");
            }
        }
        this.m_marshaller = this.m_unmarshaller = MungedClass.getUniqueSupportClass(cf);
    }

    public void setLinkages() throws JiBXException {
        if (this.m_isAbstract && this.m_component instanceof ObjectBinding) {
            ((ObjectBinding)this.m_component).setAbstract(true);
        }
        this.m_component.setLinkages();
        if (!this.m_isAbstract) {
            this.m_component.checkContentSequence(true);
        }
        this.m_defContext.setLinkages();
        if (this.m_baseType != null) {
            this.m_baseMapping = this.m_defContext.getClassMapping(this.m_baseType);
            if (this.m_baseMapping == null) {
                throw new JiBXException("Mapping for base class " + this.m_baseType + " not defined");
            }
            this.m_baseMapping.addExtension(this);
        }
    }

    public void print(int depth) {
        BindingDefinition.indent(depth);
        System.out.print("mapping class " + this.m_class.getClassFile().getName());
        if (this.m_name != null) {
            System.out.print(" to element " + this.m_name.toString());
        }
        System.out.println();
        this.m_component.print(depth + 1);
    }
}

