/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import java.io.File;
import java.util.ArrayList;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.Type;
import org.jibx.binding.classes.BoundClass;
import org.jibx.binding.classes.BranchWrapper;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.classes.ExceptionMethodBuilder;
import org.jibx.binding.classes.MungedClass;
import org.jibx.binding.def.ArrayMap;
import org.jibx.binding.def.BindingBuilder;
import org.jibx.binding.def.DefinitionContext;
import org.jibx.binding.def.IComponent;
import org.jibx.binding.def.IContainer;
import org.jibx.binding.def.IMapping;
import org.jibx.binding.def.MappingBase;
import org.jibx.binding.def.NameDefinition;
import org.jibx.binding.def.NamespaceDefinition;
import org.jibx.binding.def.ObjectStringConversion;
import org.jibx.binding.def.PrimitiveStringConversion;
import org.jibx.binding.def.StringConversion;
import org.jibx.runtime.JiBXException;

public class BindingDefinition
extends BindingBuilder.ContainerBase
implements IContainer {
    public static final String CURRENT_VERSION_NAME = "jibx-beta3c";
    public static final String GENERATE_PREFIX = "JiBX_";
    static final String DEFAULT_AUTOPREFIX = "id_";
    private static ArrayList s_bindings;
    private static ArrayMap s_mappedClasses;
    private static StringConversion s_byteConversion;
    private static StringConversion s_charConversion;
    private static StringConversion s_doubleConversion;
    private static StringConversion s_floatConversion;
    private static StringConversion s_intConversion;
    private static StringConversion s_longConversion;
    private static StringConversion s_shortConversion;
    private static StringConversion s_booleanConversion;
    private static StringConversion s_dateConversion;
    private static StringConversion s_sqlDateConversion;
    public static StringConversion s_base64Conversion;
    public static StringConversion s_stringConversion;
    public static StringConversion s_objectConversion;
    private static final String FACTORY_SUFFIX = "Factory";
    private static final String FACTORY_INTERFACE = "org.jibx.runtime.IBindingFactory";
    private static final String[] FACTORY_INTERFACES;
    private static final String FACTORY_INSTNAME = "m_inst";
    private static final int FACTORY_INSTACCESS = 10;
    private static final String MARSHALLER_ARRAYNAME = "m_marshallers";
    private static final String UNMARSHALLER_ARRAYNAME = "m_unmarshallers";
    private static final String STRING_ARRAYTYPE = "java.lang.String[]";
    private static final String CLASSES_ARRAYNAME = "m_classes";
    private static final String URIS_ARRAYNAME = "m_uris";
    private static final String GNAMES_ARRAYNAME = "m_globalNames";
    private static final String GURIS_ARRAYNAME = "m_globalUris";
    private static final String IDNAMES_ARRAYNAME = "m_idNames";
    private static final String CREATEMARSHAL_METHODNAME = "createMarshallingContext";
    private static final String MARSHALCONTEXT_INTERFACE = "org.jibx.runtime.IMarshallingContext";
    private static final String MARSHALCONTEXT_IMPLEMENTATION = "org.jibx.runtime.impl.MarshallingContext";
    private static final String MARSHALCONTEXTINIT_SIGNATURE = "([Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;)V";
    private static final String CREATEUNMARSHAL_METHODNAME = "createUnmarshallingContext";
    private static final String UNMARSHALCONTEXT_INTERFACE = "org.jibx.runtime.IUnmarshallingContext";
    private static final String UNMARSHALCONTEXT_IMPLEMENTATION = "org.jibx.runtime.impl.UnmarshallingContext";
    private static final String UNMARSHALCONTEXTINIT_SIGNATURE = "(I[Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;)V";
    private static final String GETINST_METHODNAME = "getInstance";
    private static final String UNSUPPORTED_EXCEPTION_CLASS = "java.lang.UnsupportedOperationException";
    private static final String GETVERSION_METHODNAME = "getCompilerVersion";
    private static final String GETDISTRIB_METHODNAME = "getCompilerDistribution";
    private static final String GETDEFINEDNSS_METHODNAME = "getNamespaces";
    private static final String GETCLASSES_METHODNAME = "getMappedClasses";
    private static final String GETELEMENTNSS_METHODNAME = "getElementNamespaces";
    private static final String GETELEMENTNAMES_METHODNAME = "getElementNames";
    private final String m_name;
    private final int m_index;
    private final boolean m_isInput;
    private final boolean m_isOutput;
    private final boolean m_isIdGlobal;
    private final boolean m_isForwards;
    private final boolean m_isTrackSource;
    private final String m_autoPrefix;
    private String m_targetPackage;
    private File m_targetRoot;
    private ArrayMap m_uniqueIds;
    private ArrayMap m_namespaceUris;
    private DefinitionContext m_outerContext;
    private DefinitionContext m_activeContext;
    private boolean m_isMappedDone;
    private int m_mumIndex;
    private ArrayList m_extraClasses;
    private ArrayList m_extraMarshallers;
    private ArrayList m_extraUnmarshallers;
    private static byte[] s_blanks;

    public BindingDefinition(String name, boolean ibind, boolean obind, String auto, boolean glob, boolean forward, boolean source) throws JiBXException {
        super(null);
        this.m_name = name;
        this.m_isInput = ibind;
        this.m_isOutput = obind;
        this.m_isIdGlobal = glob;
        this.m_isForwards = forward;
        this.m_isTrackSource = source;
        this.m_autoPrefix = auto;
        this.m_styleDefault = 1;
        this.m_autoLink = 1;
        this.m_accessLevel = 0;
        this.m_nameStyle = 0;
        this.m_outerContext = this.m_activeContext = new DefinitionContext(this);
        this.m_activeContext = new DefinitionContext(this);
        this.m_namespaceUris = new ArrayMap();
        this.m_namespaceUris.findOrAdd("");
        this.m_outerContext.addNamespace(NamespaceDefinition.buildNamespace("http://www.w3.org/XML/1998/namespace", "xml"));
        this.m_outerContext.setDefaultConversion("byte:default", s_byteConversion);
        this.m_outerContext.setDefaultConversion("char:default", s_charConversion);
        StringConversion schar = s_charConversion.derive("char", "org.jibx.runtime.Utility.serializeCharString", "org.jibx.runtime.Utility.parseCharString", null);
        this.m_outerContext.setNamedConversion("char:string", schar);
        this.m_outerContext.setDefaultConversion("double:default", s_doubleConversion);
        this.m_outerContext.setDefaultConversion("float:default", s_floatConversion);
        this.m_outerContext.setDefaultConversion("int:default", s_intConversion);
        this.m_outerContext.setDefaultConversion("long:default", s_longConversion);
        this.m_outerContext.setDefaultConversion("short:default", s_shortConversion);
        this.m_outerContext.setDefaultConversion("boolean:default", s_booleanConversion);
        this.m_outerContext.setDefaultConversion("Date:default", s_dateConversion);
        this.m_outerContext.setDefaultConversion("SqlDate:default", s_sqlDateConversion);
        this.m_outerContext.setDefaultConversion("byte[]:default", s_base64Conversion);
        this.m_outerContext.setDefaultConversion("String:default", s_stringConversion);
        this.m_outerContext.setDefaultConversion("Object:default", s_objectConversion);
        this.m_index = s_bindings.size();
        s_bindings.add(this);
    }

    public BoundClass getBoundClass() {
        return null;
    }

    public int getStyleDefault() {
        return this.m_styleDefault;
    }

    public boolean setIdChild(IComponent child) {
        throw new IllegalStateException("Internal error - setIdChild for root");
    }

    public String getDefaultPackage() {
        return this.m_targetPackage;
    }

    public File getDefaultRoot() {
        return this.m_targetRoot;
    }

    public void setFactoryLocation(String tpack, File root) {
        this.m_targetPackage = tpack;
        this.m_targetRoot = root;
    }

    public int getIndex() {
        return this.m_index;
    }

    public boolean isInput() {
        return this.m_isInput;
    }

    public boolean isOutput() {
        return this.m_isOutput;
    }

    public boolean isIdGlobal() {
        return this.m_isIdGlobal;
    }

    public boolean isForwards() {
        return this.m_isForwards;
    }

    public boolean isTrackSource() {
        return this.m_isTrackSource;
    }

    public String getPrefix() {
        return GENERATE_PREFIX + this.m_name;
    }

    public int getMappedClassIndex(String name) {
        if (this.m_isMappedDone) {
            throw new IllegalStateException("Internal error: Call out of sequence");
        }
        return s_mappedClasses.findOrAdd(name);
    }

    public int getMarshallerUnmarshallerIndex(String clas) {
        if (!this.m_isMappedDone) {
            this.m_isMappedDone = true;
            this.m_mumIndex = s_mappedClasses.size();
            this.m_extraClasses = new ArrayList();
            this.m_extraMarshallers = new ArrayList();
            this.m_extraUnmarshallers = new ArrayList();
        }
        this.m_extraClasses.add(clas);
        this.m_extraMarshallers.add(null);
        this.m_extraUnmarshallers.add(null);
        return this.m_mumIndex++;
    }

    public void setMarshallerUnmarshallerClasses(int slot, String mclas, String uclas) {
        int index = slot - s_mappedClasses.size();
        this.m_extraMarshallers.set(index, mclas);
        this.m_extraUnmarshallers.set(index, uclas);
    }

    public int getIdClassIndex(String name) {
        if (this.m_isIdGlobal) {
            return 0;
        }
        if (this.m_uniqueIds == null) {
            this.m_uniqueIds = new ArrayMap();
        }
        return this.m_uniqueIds.findOrAdd(name);
    }

    public int getNamespaceUriIndex(String name) {
        return this.m_namespaceUris.findOrAdd(name);
    }

    public void generateCode() throws JiBXException {
        NameDefinition ndef;
        IMapping map;
        String cname;
        int i;
        int mcnt;
        this.m_activeContext.setLinkages();
        this.m_activeContext.generateCode();
        String name = this.m_targetPackage.length() == 0 ? this.getPrefix() + FACTORY_SUFFIX : this.m_targetPackage + '.' + this.getPrefix() + FACTORY_SUFFIX;
        ClassFile base = ClassCache.getClassFile("java.lang.Object");
        ClassFile cf = new ClassFile(name, this.m_targetRoot, base, 1, FACTORY_INTERFACES);
        ArrayList maps = this.m_activeContext.getMappings();
        for (int i2 = 0; i2 < maps.size(); ++i2) {
            BoundClass bound;
            IMapping map2 = (IMapping)maps.get(i2);
            if (!(map2 instanceof MappingBase) || !(bound = ((MappingBase)map2).getBoundClass()).getClassFile().isModifiable()) continue;
            bound.addFactory(name);
        }
        int count = s_mappedClasses.size();
        ClassItem inst = cf.addField(FACTORY_INTERFACE, FACTORY_INSTNAME, 10);
        ClassItem marshs = cf.addPrivateField(STRING_ARRAYTYPE, MARSHALLER_ARRAYNAME);
        ClassItem umarshs = cf.addPrivateField(STRING_ARRAYTYPE, UNMARSHALLER_ARRAYNAME);
        ClassItem classes = cf.addPrivateField(STRING_ARRAYTYPE, CLASSES_ARRAYNAME);
        ClassItem uris = cf.addPrivateField(STRING_ARRAYTYPE, URIS_ARRAYNAME);
        ClassItem gnames = cf.addPrivateField(STRING_ARRAYTYPE, GNAMES_ARRAYNAME);
        ClassItem guris = cf.addPrivateField(STRING_ARRAYTYPE, GURIS_ARRAYNAME);
        ClassItem idnames = cf.addPrivateField(STRING_ARRAYTYPE, IDNAMES_ARRAYNAME);
        ExceptionMethodBuilder mb = new ExceptionMethodBuilder("<init>", Type.VOID, new Type[0], cf, 2);
        mb.appendLoadLocal(0);
        mb.appendCallInit("java.lang.Object", "()V");
        int n = mcnt = this.m_isMappedDone ? this.m_mumIndex : count;
        if (this.m_isInput) {
            mb.appendLoadLocal(0);
            mb.appendLoadConstant(mcnt);
            mb.appendCreateArray("java.lang.String");
            for (i = 0; i < count; ++i) {
                cname = (String)s_mappedClasses.get(i);
                map = this.m_activeContext.getMappingAtLevel(cname);
                if (map == null) continue;
                mb.appendDUP();
                mb.appendLoadConstant(i);
                mb.appendLoadConstant(map.getUnmarshaller().getName());
                mb.appendAASTORE();
            }
            for (i = count; i < mcnt; ++i) {
                mb.appendDUP();
                mb.appendLoadConstant(i);
                mb.appendLoadConstant((String)this.m_extraUnmarshallers.get(i - count));
                mb.appendAASTORE();
            }
            mb.appendPutField(umarshs);
        }
        if (this.m_isOutput) {
            mb.appendLoadLocal(0);
            mb.appendLoadConstant(mcnt);
            mb.appendCreateArray("java.lang.String");
            for (i = 0; i < count; ++i) {
                cname = (String)s_mappedClasses.get(i);
                map = this.m_activeContext.getMappingAtLevel(cname);
                if (map == null) continue;
                mb.appendDUP();
                mb.appendLoadConstant(i);
                mb.appendLoadConstant(map.getMarshaller().getName());
                mb.appendAASTORE();
            }
            for (i = count; i < mcnt; ++i) {
                mb.appendDUP();
                mb.appendLoadConstant(i);
                mb.appendLoadConstant((String)this.m_extraMarshallers.get(i - count));
                mb.appendAASTORE();
            }
            mb.appendPutField(marshs);
        }
        mb.appendLoadLocal(0);
        mb.appendLoadConstant(mcnt);
        mb.appendCreateArray("java.lang.String");
        for (i = 0; i < count; ++i) {
            mb.appendDUP();
            mb.appendLoadConstant(i);
            mb.appendLoadConstant((String)s_mappedClasses.get(i));
            mb.appendAASTORE();
        }
        for (i = count; i < mcnt; ++i) {
            mb.appendDUP();
            mb.appendLoadConstant(i);
            mb.appendLoadConstant((String)this.m_extraClasses.get(i - count));
            mb.appendAASTORE();
        }
        mb.appendPutField(classes);
        if (this.m_isOutput) {
            mb.appendLoadLocal(0);
            mb.appendLoadConstant(this.m_namespaceUris.size());
            mb.appendCreateArray("java.lang.String");
            for (i = 0; i < this.m_namespaceUris.size(); ++i) {
                mb.appendDUP();
                mb.appendLoadConstant(i);
                mb.appendLoadConstant((String)this.m_namespaceUris.get(i));
                mb.appendAASTORE();
            }
            mb.appendPutField(uris);
        }
        mb.appendLoadLocal(0);
        mb.appendLoadConstant(count);
        mb.appendCreateArray("java.lang.String");
        for (i = 0; i < count; ++i) {
            cname = (String)s_mappedClasses.get(i);
            map = this.m_activeContext.getMappingAtLevel(cname);
            if (map == null || (ndef = map.getName()) == null) continue;
            mb.appendDUP();
            mb.appendLoadConstant(i);
            ndef.genPushName(mb);
            mb.appendAASTORE();
        }
        mb.appendPutField(gnames);
        mb.appendLoadLocal(0);
        mb.appendLoadConstant(count);
        mb.appendCreateArray("java.lang.String");
        for (i = 0; i < count; ++i) {
            cname = (String)s_mappedClasses.get(i);
            map = this.m_activeContext.getMappingAtLevel(cname);
            if (map == null || (ndef = map.getName()) == null) continue;
            mb.appendDUP();
            mb.appendLoadConstant(i);
            ndef.genPushUri(mb);
            mb.appendAASTORE();
        }
        mb.appendPutField(guris);
        mb.appendLoadLocal(0);
        if (this.m_uniqueIds != null && this.m_uniqueIds.size() > 0) {
            mb.appendLoadConstant(this.m_uniqueIds.size());
            mb.appendCreateArray("java.lang.String");
            for (i = 0; i < this.m_uniqueIds.size(); ++i) {
                mb.appendDUP();
                mb.appendLoadConstant(i);
                mb.appendLoadConstant((String)this.m_uniqueIds.get(i));
                mb.appendAASTORE();
            }
        } else {
            mb.appendACONST_NULL();
        }
        mb.appendPutField(idnames);
        mb.appendReturn();
        mb.codeComplete(false);
        mb.addMethod();
        mb = new ExceptionMethodBuilder(CREATEMARSHAL_METHODNAME, ClassItem.typeFromName(MARSHALCONTEXT_INTERFACE), new Type[0], cf, 1);
        if (this.m_isOutput) {
            mb.appendCreateNew(MARSHALCONTEXT_IMPLEMENTATION);
            mb.appendDUP();
            mb.appendLoadLocal(0);
            mb.appendGetField(classes);
            mb.appendLoadLocal(0);
            mb.appendGetField(marshs);
            mb.appendLoadLocal(0);
            mb.appendGetField(uris);
            mb.appendCallInit(MARSHALCONTEXT_IMPLEMENTATION, MARSHALCONTEXTINIT_SIGNATURE);
            mb.appendReturn(MARSHALCONTEXT_IMPLEMENTATION);
        } else {
            mb.appendCreateNew(UNSUPPORTED_EXCEPTION_CLASS);
            mb.appendDUP();
            mb.appendLoadConstant("Binding is input only - cannot create unmarshaller");
            mb.appendCallInit(UNSUPPORTED_EXCEPTION_CLASS, "(Ljava/lang/String;)V");
            mb.appendThrow();
        }
        mb.codeComplete(false);
        mb.addMethod();
        mb = new ExceptionMethodBuilder(CREATEUNMARSHAL_METHODNAME, ClassItem.typeFromName(UNMARSHALCONTEXT_INTERFACE), new Type[0], cf, 1);
        if (this.m_isInput) {
            mb.appendCreateNew(UNMARSHALCONTEXT_IMPLEMENTATION);
            mb.appendDUP();
            mb.appendLoadConstant(mcnt);
            mb.appendLoadLocal(0);
            mb.appendGetField(umarshs);
            mb.appendLoadLocal(0);
            mb.appendGetField(guris);
            mb.appendLoadLocal(0);
            mb.appendGetField(gnames);
            mb.appendLoadLocal(0);
            mb.appendGetField(idnames);
            mb.appendCallInit(UNMARSHALCONTEXT_IMPLEMENTATION, UNMARSHALCONTEXTINIT_SIGNATURE);
            mb.appendReturn(UNMARSHALCONTEXT_IMPLEMENTATION);
        } else {
            mb.appendCreateNew(UNSUPPORTED_EXCEPTION_CLASS);
            mb.appendDUP();
            mb.appendLoadConstant("Binding is output only - cannot create marshaller");
            mb.appendCallInit(UNSUPPORTED_EXCEPTION_CLASS, "(Ljava/lang/String;)V");
            mb.appendThrow();
        }
        mb.codeComplete(false);
        mb.addMethod();
        mb = new ExceptionMethodBuilder(GETVERSION_METHODNAME, Type.INT, new Type[0], cf, 1);
        mb.appendLoadConstant(0);
        mb.appendReturn("int");
        mb.codeComplete(false);
        mb.addMethod();
        mb = new ExceptionMethodBuilder(GETDISTRIB_METHODNAME, Type.STRING, new Type[0], cf, 1);
        mb.appendLoadConstant(CURRENT_VERSION_NAME);
        mb.appendReturn(Type.STRING);
        mb.codeComplete(false);
        mb.addMethod();
        ArrayType satype = new ArrayType(Type.STRING, 1);
        mb = new ExceptionMethodBuilder(GETDEFINEDNSS_METHODNAME, satype, new Type[0], cf, 1);
        mb.appendLoadLocal(0);
        mb.appendGetField(uris);
        mb.appendReturn(satype);
        mb.codeComplete(false);
        mb.addMethod();
        mb = new ExceptionMethodBuilder(GETCLASSES_METHODNAME, satype, new Type[0], cf, 1);
        mb.appendLoadLocal(0);
        mb.appendGetField(classes);
        mb.appendReturn(satype);
        mb.codeComplete(false);
        mb.addMethod();
        mb = new ExceptionMethodBuilder(GETELEMENTNSS_METHODNAME, satype, new Type[0], cf, 1);
        mb.appendLoadLocal(0);
        mb.appendGetField(guris);
        mb.appendReturn(satype);
        mb.codeComplete(false);
        mb.addMethod();
        mb = new ExceptionMethodBuilder(GETELEMENTNAMES_METHODNAME, satype, new Type[0], cf, 1);
        mb.appendLoadLocal(0);
        mb.appendGetField(gnames);
        mb.appendReturn(satype);
        mb.codeComplete(false);
        mb.addMethod();
        mb = new ExceptionMethodBuilder(GETINST_METHODNAME, ClassItem.typeFromName(FACTORY_INTERFACE), new Type[0], cf, 9);
        mb.appendGetStatic(inst);
        BranchWrapper ifdone = mb.appendIFNONNULL(this);
        mb.appendCreateNew(cf.getName());
        mb.appendDUP();
        mb.appendCallInit(cf.getName(), "()V");
        mb.appendPutStatic(inst);
        mb.targetNext(ifdone);
        mb.appendGetStatic(inst);
        mb.appendReturn(FACTORY_INTERFACE);
        mb.codeComplete(false);
        mb.addMethod();
        MungedClass.getUniqueSupportClass(cf);
    }

    public static BindingDefinition getBinding(int index) {
        return (BindingDefinition)s_bindings.get(index);
    }

    public static void reset() {
        s_bindings = new ArrayList();
        s_mappedClasses = new ArrayMap();
    }

    public boolean isContentOrdered() {
        return true;
    }

    public boolean hasNamespaces() {
        return false;
    }

    public BindingDefinition getBindingRoot() {
        return this;
    }

    public DefinitionContext getDefinitionContext() {
        return this.m_activeContext;
    }

    public static void indent(int depth) {
        if (depth < s_blanks.length) {
            System.out.write(s_blanks, 0, depth);
        } else {
            System.out.print(s_blanks);
        }
    }

    public void print() {
        System.out.println("binding " + this.m_name + ":");
        this.m_activeContext.print(1);
    }

    static {
        s_byteConversion = new PrimitiveStringConversion(Byte.TYPE, new Byte(0), "B", "serializeByte", "parseByte", "attributeByte", "parseElementByte");
        s_charConversion = new PrimitiveStringConversion(Character.TYPE, new Character('\u0000'), "C", "serializeChar", "parseChar", "attributeChar", "parseElementChar");
        s_doubleConversion = new PrimitiveStringConversion(Double.TYPE, new Double(0.0), "D", "serializeDouble", "parseDouble", "attributeDouble", "parseElementDouble");
        s_floatConversion = new PrimitiveStringConversion(Float.TYPE, new Float(0.0f), "F", "serializeFloat", "parseFloat", "attributeFloat", "parseElementFloat");
        s_intConversion = new PrimitiveStringConversion(Integer.TYPE, new Integer(0), "I", "serializeInt", "parseInt", "attributeInt", "parseElementInt");
        s_longConversion = new PrimitiveStringConversion(Long.TYPE, new Long(0L), "J", "serializeLong", "parseLong", "attributeLong", "parseElementLong");
        s_shortConversion = new PrimitiveStringConversion(Short.TYPE, new Short(0), "S", "serializeShort", "parseShort", "attributeShort", "parseElementShort");
        s_booleanConversion = new PrimitiveStringConversion(Boolean.TYPE, Boolean.FALSE, "Z", "serializeBoolean", "parseBoolean", "attributeBoolean", "parseElementBoolean");
        s_dateConversion = new ObjectStringConversion(null, "org.jibx.runtime.Utility.serializeDateTime", "org.jibx.runtime.Utility.deserializeDateTime", "java.util.Date");
        s_sqlDateConversion = new ObjectStringConversion(null, "org.jibx.runtime.Utility.serializeSqlDate", "org.jibx.runtime.Utility.deserializeSqlDate", "java.sql.Date");
        s_base64Conversion = new ObjectStringConversion(null, "org.jibx.runtime.Utility.serializeBase64", "org.jibx.runtime.Utility.deserializeBase64", "byte[]");
        s_stringConversion = new ObjectStringConversion(null, null, null, "java.lang.String");
        s_objectConversion = new ObjectStringConversion(null, null, null, "java.lang.Object");
        FACTORY_INTERFACES = new String[]{FACTORY_INTERFACE};
        s_blanks = "                                                   ".getBytes();
    }
}

