/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.classes;

import java.io.File;
import java.util.HashMap;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.Type;
import org.jibx.binding.classes.BindingMethod;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.classes.ExceptionMethodBuilder;
import org.jibx.binding.classes.MethodBuilder;
import org.jibx.binding.classes.MungedClass;
import org.jibx.runtime.JiBXException;

public class BoundClass {
    private static final String GENERIC_MUNGE_CLASS = "JiBX_MungeAdapter";
    private static final String ACCESS_PREFIX = "JiBX_access_";
    private static final Type[] EMPTY_TYPE_ARGS = new Type[0];
    private static HashMap s_nameMap;
    private static String s_modifyPackage;
    private static File s_modifyRoot;
    private static MungedClass s_genericMunge;
    private final ClassFile m_boundClass;
    private final MungedClass m_mungedClass;
    private HashMap m_loadMap;
    private HashMap m_storeMap;

    private BoundClass(ClassFile bound, MungedClass munge) {
        this.m_boundClass = bound;
        this.m_mungedClass = munge;
    }

    public ClassFile getClassFile() {
        return this.m_boundClass;
    }

    public String getClassName() {
        return this.m_boundClass.getName();
    }

    public ClassFile getMungedFile() {
        return this.m_mungedClass.getClassFile();
    }

    public boolean isDirectAccess() {
        return this.m_boundClass == this.m_mungedClass.getClassFile();
    }

    public ClassItem getLoadMethod(ClassItem item, ClassFile from) throws JiBXException {
        BindingMethod method;
        if (this.m_loadMap == null) {
            this.m_loadMap = new HashMap();
        }
        if ((method = (BindingMethod)this.m_loadMap.get(item)) == null) {
            String name = "JiBX_access_load_" + item.getName();
            ClassFile cf = item.getClassFile();
            Type type = Type.getType(Utility.getSignature(item.getTypeName()));
            ExceptionMethodBuilder mb = new ExceptionMethodBuilder(name, type, EMPTY_TYPE_ARGS, cf, 0);
            mb.appendLoadLocal(0);
            if (item.isMethod()) {
                mb.addMethodExceptions(item);
                mb.appendCall(item);
            } else {
                mb.appendGetField(item);
            }
            mb.appendReturn(type);
            method = this.m_mungedClass.getUniqueMethod(mb, true);
            this.m_loadMap.put(item, method);
        }
        method.makeAccessible(from);
        return method.getItem();
    }

    public ClassItem getStoreMethod(ClassItem item, ClassFile from) throws JiBXException {
        BindingMethod method;
        if (this.m_storeMap == null) {
            this.m_storeMap = new HashMap();
        }
        if ((method = (BindingMethod)this.m_storeMap.get(item)) == null) {
            Type type;
            String name = "JiBX_access_store_" + item.getName();
            ClassFile cf = item.getClassFile();
            if (item.isMethod()) {
                String sig = item.getSignature();
                int start = sig.indexOf(40);
                int end = sig.indexOf(41);
                type = Type.getType(sig.substring(start + 1, end));
            } else {
                type = Type.getType(Utility.getSignature(item.getTypeName()));
            }
            ExceptionMethodBuilder mb = new ExceptionMethodBuilder(name, Type.VOID, new Type[]{type}, cf, 0);
            mb.appendLoadLocal(0);
            mb.appendLoadLocal(1);
            if (item.isMethod()) {
                mb.addMethodExceptions(item);
                mb.appendCall(item);
            } else {
                mb.appendPutField(item);
            }
            mb.appendReturn();
            method = this.m_mungedClass.getUniqueMethod(mb, true);
            this.m_storeMap.put(item, method);
        }
        method.makeAccessible(from);
        return method.getItem();
    }

    public BindingMethod getUniqueMethod(MethodBuilder builder) throws JiBXException {
        return this.m_mungedClass.getUniqueMethod(builder, true);
    }

    public BindingMethod getUniqueNamed(MethodBuilder builder) throws JiBXException {
        return this.m_mungedClass.getUniqueMethod(builder, false);
    }

    public void addFactory(String fact) {
        if (!this.isDirectAccess()) {
            throw new IllegalStateException("Internal error: not directly modifiable class");
        }
        this.m_mungedClass.addFactory(fact);
    }

    public void setFactoryList() throws JiBXException {
        if (!this.isDirectAccess()) {
            throw new IllegalStateException("Internal error: not directly modifiable class");
        }
        this.m_mungedClass.setFactoryList();
    }

    private static BoundClass createInstance(String key, ClassFile bound, MungedClass munge) {
        BoundClass inst = new BoundClass(bound, munge);
        s_nameMap.put(key, inst);
        return inst;
    }

    private static BoundClass findOrCreateInstance(ClassFile bound, MungedClass munge) {
        String key = bound.getName() + ':' + munge.getClassFile().getName();
        BoundClass inst = (BoundClass)s_nameMap.get(key);
        if (inst == null) {
            inst = BoundClass.createInstance(key, bound, munge);
        }
        return inst;
    }

    public static BoundClass getInstance(String name, BoundClass context) throws JiBXException {
        BoundClass inst = (BoundClass)s_nameMap.get(name);
        if (inst == null) {
            ClassFile cf = ClassCache.getClassFile(name);
            if (!cf.isInterface() && cf.isModifiable()) {
                if (s_modifyRoot == null) {
                    s_modifyRoot = cf.getRoot();
                    s_modifyPackage = cf.getPackage();
                    if (s_modifyPackage.length() == 0) {
                        s_modifyPackage = null;
                    }
                }
                inst = BoundClass.createInstance(name, cf, MungedClass.getInstance(cf));
            } else if (context != null && context.getClassFile().isSuperclass(name)) {
                inst = BoundClass.findOrCreateInstance(cf, context.m_mungedClass);
            } else {
                if (s_genericMunge == null) {
                    String mname = s_modifyPackage == null ? GENERIC_MUNGE_CLASS : s_modifyPackage + '.' + GENERIC_MUNGE_CLASS;
                    ClassFile base = ClassCache.getClassFile("java.lang.Object");
                    ClassFile gen = new ClassFile(mname, s_modifyRoot, base, 1025, new String[0]);
                    gen.addDefaultConstructor();
                    s_genericMunge = MungedClass.getInstance(gen);
                    MungedClass.delayedAddUnique(gen);
                }
                inst = BoundClass.findOrCreateInstance(cf, s_genericMunge);
            }
        }
        return inst;
    }

    public static void reset() {
        s_nameMap = new HashMap();
        s_modifyPackage = null;
        s_modifyRoot = null;
        s_genericMunge = null;
    }
}

