/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.protocol;

import com.funambol.framework.core.AbstractCommand;
import com.funambol.framework.core.Add;
import com.funambol.framework.core.Alert;
import com.funambol.framework.core.CmdID;
import com.funambol.framework.core.Copy;
import com.funambol.framework.core.Data;
import com.funambol.framework.core.Delete;
import com.funambol.framework.core.Exec;
import com.funambol.framework.core.Item;
import com.funambol.framework.core.Meta;
import com.funambol.framework.core.ModificationCommand;
import com.funambol.framework.core.Replace;
import com.funambol.framework.core.RepresentationException;
import com.funambol.framework.core.Results;
import com.funambol.framework.core.Source;
import com.funambol.framework.core.SourceRef;
import com.funambol.framework.core.Status;
import com.funambol.framework.core.Sync;
import com.funambol.framework.core.Sync4jException;
import com.funambol.framework.core.SyncBody;
import com.funambol.framework.core.SyncHdr;
import com.funambol.framework.core.SyncML;
import com.funambol.framework.core.Target;
import com.funambol.framework.core.TargetRef;
import com.funambol.framework.database.Database;
import com.funambol.framework.protocol.Flags;
import com.funambol.framework.protocol.ProtocolException;
import com.funambol.framework.protocol.ProtocolUtil;
import com.funambol.framework.protocol.SyncPackage;
import com.funambol.framework.protocol.v11.ClientModificationsRequirements;
import java.util.ArrayList;

public class ClientModifications
extends SyncPackage
implements Flags {
    private CmdID serverCapabilitiesCmdId = null;
    private CmdID clientCapabilitiesCmdId = null;
    private Results clientCapabilitiesResults = null;
    private Status serverCapabilitiesStatus = null;
    private CmdID clientSyncCmdId = null;
    private AbstractCommand[] serverModifications = null;
    private Status[] clientModificationsStatus = null;
    private AbstractCommand[] clientCommands = null;
    private Sync[] clientSyncCommands = null;
    private Database[] databases = null;
    private Alert[] modificationsAlert = null;

    public ClientModifications(SyncHdr syncHeader, SyncBody syncBody, Database[] syncDb) throws ProtocolException {
        super(syncHeader, syncBody);
        this.checkRequirements();
        this.databases = syncDb;
    }

    public ClientModifications(SyncHdr syncHeader, SyncBody syncBody) throws Sync4jException {
        super(syncHeader, syncBody);
    }

    public CmdID getServerCapabilitiesCmdId() {
        return this.serverCapabilitiesCmdId;
    }

    public void setServerCapabilitiesCmdId(CmdID serverCapabilitiesCmdId) {
        this.serverCapabilitiesCmdId = serverCapabilitiesCmdId;
    }

    public CmdID getClientCapabilitiesCmdId() {
        return this.clientCapabilitiesCmdId;
    }

    public void setClientCapabilitiesCmdId(CmdID clientCapabilitiesCmdId) {
        this.clientCapabilitiesCmdId = clientCapabilitiesCmdId;
    }

    public Results getClientCapabilitiesResults() {
        return this.clientCapabilitiesResults;
    }

    public Status getServerCapabilitiesStatus() {
        return this.serverCapabilitiesStatus;
    }

    public CmdID getClientSyncCmdId() {
        return this.clientSyncCmdId;
    }

    public void setClientSyncCmdId(CmdID clientSyncCmdId) {
        this.clientSyncCmdId = clientSyncCmdId;
    }

    public AbstractCommand[] getServerModifications() {
        return this.serverModifications;
    }

    public void setServerModifications(AbstractCommand[] serverModifications) {
        this.serverModifications = serverModifications;
    }

    public Status[] getClientModificationsStatus() {
        return this.clientModificationsStatus;
    }

    public void setClientModificationsStatus(Status[] clientModificationsStatus) {
        this.clientModificationsStatus = clientModificationsStatus;
    }

    public AbstractCommand[] getClientCommands() {
        return this.clientCommands;
    }

    public Sync[] getClientSyncCommands() {
        return this.clientSyncCommands;
    }

    public void setDatabases(Database[] databases) {
        this.databases = databases;
    }

    public Database[] getDatabases() {
        return this.databases;
    }

    public Alert[] getModificationsAlert() {
        return this.modificationsAlert;
    }

    public void setModificationsAlert(Alert[] modificationsAlert) {
        this.modificationsAlert = modificationsAlert;
    }

    @Override
    public void checkHeaderRequirements() throws ProtocolException {
        ClientModificationsRequirements.checkDTDVersion(this.syncHeader.getVerDTD());
        ClientModificationsRequirements.checkProtocolVersion(this.syncHeader.getVerProto());
        ClientModificationsRequirements.checkSessionId(this.syncHeader.getSessionID());
        ClientModificationsRequirements.checkMessageId(this.syncHeader.getMsgID());
        ClientModificationsRequirements.checkTarget(this.syncHeader.getTarget());
        ClientModificationsRequirements.checkSource(this.syncHeader.getSource());
    }

    @Override
    public void checkBodyRequirements() throws ProtocolException {
        this.clientCommands = this.syncBody.getCommands().toArray(new AbstractCommand[0]);
        this.checkServerCapabilitiesStatus();
        this.checkClientCapabilitiesResult();
        this.checkSyncCommand();
    }

    @Override
    public SyncML getResponse(String msgId) throws ProtocolException {
        int i;
        ArrayList<AbstractCommand> commandList = new ArrayList<AbstractCommand>();
        if (this.idGenerator == null) {
            throw new NullPointerException("The id generator is null. Please set a value for idGenerator");
        }
        if (!this.syncHeader.isNoResp()) {
            TargetRef[] targetRefs = new TargetRef[]{new TargetRef(this.syncHeader.getTarget().getLocURI())};
            SourceRef[] sourceRefs = new SourceRef[]{new SourceRef(this.syncHeader.getSource().getLocURI())};
            Status statusCommand = new Status(this.idGenerator.next(), this.syncHeader.getMsgID(), "0", "SyncHdr", targetRefs, sourceRefs, null, null, new Data(200L), new Item[0]);
            commandList.add(statusCommand);
            for (int i2 = 0; this.isFlag(2) && this.clientModificationsStatus != null && i2 < this.clientModificationsStatus.length; ++i2) {
                commandList.add(this.clientModificationsStatus[i2]);
            }
        }
        for (i = 0; this.modificationsAlert != null && i < this.modificationsAlert.length; ++i) {
            commandList.add(this.modificationsAlert[i]);
        }
        for (i = 0; this.serverModifications != null && i < this.serverModifications.length; ++i) {
            commandList.add(this.serverModifications[i]);
        }
        Target target = new Target(this.syncHeader.getSource().getLocURI(), this.syncHeader.getSource().getLocName());
        Source source = new Source(this.syncHeader.getTarget().getLocURI(), this.syncHeader.getTarget().getLocName());
        SyncHdr responseHeader = new SyncHdr(this.getDTDVersion(), this.getProtocolVersion(), this.syncHeader.getSessionID(), msgId, target, source, null, false, null, null);
        AbstractCommand[] commands = null;
        int size = commandList.size();
        commands = size == 0 ? new AbstractCommand[1] : new AbstractCommand[size];
        for (int i3 = 0; i3 < size; ++i3) {
            commands[i3] = (AbstractCommand)commandList.get(i3);
        }
        SyncBody responseBody = new SyncBody(commands, this.isFlag(3));
        try {
            return new SyncML(responseHeader, responseBody);
        }
        catch (RepresentationException e) {
            throw new ProtocolException("Unexpected error", e);
        }
    }

    public Status createSyncStatusCommand() {
        return new Status(this.idGenerator.next(), "0", this.clientSyncCmdId.getCmdID(), Sync.COMMAND_NAME, (TargetRef[])null, (SourceRef[])null, null, null, null, null);
    }

    public Sync createSyncCommand(Database db) throws ProtocolException {
        CmdID syncId = this.idGenerator.next();
        AbstractCommand[] commands = null;
        if (db.getMethod() != 202) {
            commands = this.prepareCommands(db);
        }
        return new Sync(syncId, this.isFlag(0), null, db.getTarget(), db.getSource(), null, 0, commands);
    }

    public AbstractCommand[] prepareCommands(Database db) {
        ArrayList<ModificationCommand> commands = new ArrayList<ModificationCommand>();
        Meta meta = new Meta();
        meta.setType(db.getType());
        Item[] items = null;
        items = db.getAddItems();
        if (items != null) {
            commands.add(new Add(this.idGenerator.next(), this.isFlag(1), null, meta, items));
        }
        if ((items = db.getCopyItems()) != null) {
            commands.add(new Copy(this.idGenerator.next(), this.isFlag(1), null, meta, items));
        }
        if ((items = db.getDeleteItems()) != null) {
            commands.add(new Delete(this.idGenerator.next(), this.isFlag(1), this.isFlag(4), this.isFlag(5), null, meta, items));
        }
        items = db.getExecItems();
        for (int i = 0; items != null && i < items.length; ++i) {
            commands.add(new Exec(this.idGenerator.next(), this.isFlag(1), null, null, items[i]));
        }
        items = db.getReplaceItems();
        if (items != null) {
            commands.add(new Replace(this.idGenerator.next(), this.isFlag(1), null, meta, items));
        }
        int size = commands.size();
        AbstractCommand[] aCommands = new AbstractCommand[size];
        for (int i = 0; i < size; ++i) {
            aCommands[i] = (AbstractCommand)commands.get(i);
        }
        return aCommands;
    }

    private void checkServerCapabilitiesStatus() throws ProtocolException {
        if (this.serverCapabilitiesCmdId == null) {
            return;
        }
        ArrayList<AbstractCommand> list = ProtocolUtil.filterCommands(this.clientCommands, Status.class, this.serverCapabilitiesCmdId);
        if (list.isEmpty()) {
            Object[] args = new Object[]{this.serverCapabilitiesCmdId.getCmdID()};
            throw new ProtocolException("Missing status command for command {1}", args);
        }
        this.serverCapabilitiesStatus = (Status)list.get(0);
    }

    private void checkClientCapabilitiesResult() throws ProtocolException {
        if (this.clientCapabilitiesCmdId == null) {
            return;
        }
        ArrayList<AbstractCommand> list = ProtocolUtil.filterCommands(this.clientCommands, Results.class, this.clientCapabilitiesCmdId);
        if (list.isEmpty()) {
            Object[] args = new Object[]{this.clientCapabilitiesCmdId.getCmdID()};
            throw new ProtocolException("Missing results command for command {1}", args);
        }
        Results results = (Results)list.get(0);
        ClientModificationsRequirements.checkCapabilities(results, "client");
        this.clientCapabilitiesResults = results;
    }

    private void checkSyncCommand() throws ProtocolException {
        ArrayList<AbstractCommand> list = ProtocolUtil.filterCommands(this.clientCommands, Sync.class);
        if (list.isEmpty()) {
            this.clientSyncCommands = new Sync[0];
            return;
        }
        this.clientSyncCommands = list.toArray(new Sync[list.size()]);
    }
}

