/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

public class ClasspathUrlExtender {
    public static final String CLASSPATH_PROTOCOL = "classpath";
    private static ClasspathHandler s_handler;
    static /* synthetic */ Class class$org$jibx$util$ClasspathUrlExtender;

    public static void setClassLoader(ClassLoader loader) {
        s_handler = new ClasspathHandler(loader);
    }

    public static boolean isClasspathUrl(String url) {
        return url.toLowerCase().startsWith(CLASSPATH_PROTOCOL);
    }

    public static URL buildURL(URL base, String path) throws MalformedURLException {
        if (s_handler == null) {
            s_handler = new ClasspathHandler((class$org$jibx$util$ClasspathUrlExtender == null ? (class$org$jibx$util$ClasspathUrlExtender = ClasspathUrlExtender.class$("org.jibx.util.ClasspathUrlExtender")) : class$org$jibx$util$ClasspathUrlExtender).getClassLoader());
        }
        if (path.toLowerCase().startsWith("classpath:")) {
            return new URL(null, path, s_handler);
        }
        if (base != null && CLASSPATH_PROTOCOL.equals(base.getProtocol())) {
            return new URL(base, path, s_handler);
        }
        return new URL(base, path);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ClasspathHandler
    extends URLStreamHandler {
        private final ClassLoader m_loader;

        public ClasspathHandler(ClassLoader loader) {
            this.m_loader = loader;
        }

        protected URLConnection openConnection(URL url) throws IOException {
            URL alturl;
            String path = url.getPath();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if ((alturl = this.m_loader.getResource(path)) == null) {
                throw new IOException("Classpath resource not found with path '" + path + '\'');
            }
            return alturl.openConnection();
        }
    }
}

