/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import org.jgroups.log.Trace;
import org.jgroups.util.Util;

public class ReusableThread
implements Runnable {
    volatile Thread thread = null;
    Runnable task = null;
    String thread_name = "ReusableThread";
    volatile boolean suspended = false;
    long TASK_JOIN_TIME = 3000L;

    public ReusableThread() {
    }

    public ReusableThread(String thread_name) {
        this.thread_name = thread_name;
    }

    public boolean done() {
        return this.task == null;
    }

    public boolean available() {
        return this.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        ReusableThread reusableThread = this;
        synchronized (reusableThread) {
            if (this.thread == null) {
                this.thread = new Thread((Runnable)this, this.thread_name);
                this.thread.setDaemon(true);
                this.thread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Thread tmp = null;
        boolean ret = true;
        ReusableThread reusableThread = this;
        synchronized (reusableThread) {
            if (this.thread != null && this.thread.isAlive()) {
                tmp = this.thread;
                this.thread = null;
                this.task = null;
                this.notifyAll();
            }
            this.thread = null;
            this.task = null;
        }
        if (tmp != null && tmp.isAlive()) {
            long s1 = System.currentTimeMillis();
            long s2 = 0L;
            try {
                tmp.join(this.TASK_JOIN_TIME);
            }
            catch (Exception e) {
                // empty catch block
            }
            s2 = System.currentTimeMillis();
            if (tmp.isAlive()) {
                Trace.error("ReusableThread.stop()", "thread is still alive");
            }
            tmp = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        ReusableThread reusableThread = this;
        synchronized (reusableThread) {
            if (this.suspended) {
                return;
            }
            this.suspended = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        ReusableThread reusableThread = this;
        synchronized (reusableThread) {
            this.suspended = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean assignTask(Runnable t) {
        ReusableThread reusableThread = this;
        synchronized (reusableThread) {
            this.start();
            if (this.task == null) {
                this.task = t;
                this.notifyAll();
                return true;
            }
            Trace.error("ReusableThread.assignTask()", "already working on a thread: current_task=" + this.task + ", new task=" + t + ", thread=" + this.thread + ", is alive=" + (this.thread != null ? "" + this.thread.isAlive() : "null"));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.thread != null) {
            ReusableThread reusableThread;
            try {
                reusableThread = this;
                synchronized (reusableThread) {
                    while (this.task == null && this.thread != null) {
                        this.wait();
                    }
                }
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            if (this.thread == null) {
                return;
            }
            try {
                ReusableThread ex = this;
                synchronized (ex) {
                    while (this.suspended && this.thread != null) {
                        this.wait();
                    }
                }
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            if (this.thread == null) {
                return;
            }
            if (this.task != null) {
                try {
                    this.task.run();
                }
                catch (Throwable ex) {
                    Trace.error("ReusableThread().run()", "exception=" + Util.printStackTrace(ex));
                }
            }
            reusableThread = this;
            synchronized (reusableThread) {
                this.task = null;
                this.notifyAll();
            }
        }
    }

    String printObj(Object obj) {
        if (obj == null) {
            return "null";
        }
        return "non-null";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilDone() {
        ReusableThread reusableThread = this;
        synchronized (reusableThread) {
            while (this.task != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public String toString() {
        return "suspended=" + this.suspended;
    }
}

