/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.blocks.PullPushAdapter;
import org.jgroups.debug.Debugger;
import org.jgroups.log.Trace;
import org.jgroups.util.Util;

public class MessageLoadTest
extends TestCase {
    public static boolean USE_DEBUGGER = false;
    public static boolean CUMMULATIVE = false;
    public static boolean LOOPBACK = false;
    public static int MESSAGE_NUMBER = 5000;
    public static boolean SLEEP_BETWEEN_SENDING = true;
    public static int SLEEP_TIME = 1;
    public static final String NETWORK_TRANSPORT = "UDP(mcast_addr=224.0.0.35;mcast_port=45566;ip_ttl=1;mcast_send_buf_size=150000;mcast_recv_buf_size=80000;down_thread=false):";
    public static final String LOOPBACK_TRANSPORT = "LOOPBACK(down_thread=false;up_thread=false):";
    public static final String JAVAGROUPS_STACK = "PING(timeout=500;num_initial_members=1;down_thread=false;up_thread=false):FD(down_thread=false;up_thread=false):VERIFY_SUSPECT(timeout=1500;down_thread=false;up_thread=false):pbcast.NAKACK(gc_lag=50;retransmit_timeout=300,600,1200,2400,4800;down_thread=false):pbcast.STABLE(desired_avg_gossip=200;down_thread=false;up_thread=false):FRAG(frag_size=4096):pbcast.GMS(join_timeout=5000;join_retry_timeout=1000;shun=false;print_local_addr=false;down_thread=true;up_thread=true)";
    protected JChannel channel1;
    protected PullPushAdapter adapter1;
    protected Debugger debugger1;
    protected JChannel channel2;
    protected PullPushAdapter adapter2;
    protected Debugger debugger2;
    protected boolean finishedReceiving;
    static /* synthetic */ Class class$org$jgroups$tests$MessageLoadTest;

    public static String getProtocolStack() {
        return (LOOPBACK ? LOOPBACK_TRANSPORT : NETWORK_TRANSPORT) + JAVAGROUPS_STACK;
    }

    public MessageLoadTest(String string) {
        super(string);
    }

    protected static void printSelectedOptions() {
        System.out.println("will sleep : " + SLEEP_BETWEEN_SENDING);
        if (SLEEP_BETWEEN_SENDING) {
            System.out.println("sleep time : " + SLEEP_TIME);
        }
        System.out.println("msg num : " + MESSAGE_NUMBER);
        System.out.println("loopback : " + LOOPBACK);
    }

    protected void setUp() throws Exception {
        Trace.init();
        MessageLoadTest.printSelectedOptions();
        this.channel1 = new JChannel(MessageLoadTest.getProtocolStack());
        System.out.print("Connecting to channel...");
        this.channel1.connect("LOAD_TEST");
        System.out.println("connected.");
        this.adapter1 = new PullPushAdapter(this.channel1);
        if (USE_DEBUGGER) {
            this.debugger1 = new Debugger(this.channel1, CUMMULATIVE, "channel 1");
            this.debugger1.start();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        if (!LOOPBACK) {
            this.channel2 = new JChannel(MessageLoadTest.getProtocolStack());
            this.channel2.connect("LOAD_TEST");
            this.adapter2 = new PullPushAdapter(this.channel2);
            if (USE_DEBUGGER) {
                this.debugger2 = new Debugger(this.channel2, CUMMULATIVE, "channel 2");
                this.debugger2.start();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void tearDown() throws Exception {
        if (!LOOPBACK) {
            this.adapter2.stop();
            this.channel2.close();
        }
        this.adapter1.stop();
        this.channel1.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLoad() {
        try {
            Object message;
            String startMessage = "start";
            String stopMessage = "stop";
            final Object mutex = new Object();
            final Vector receivedTimes = new Vector(MESSAGE_NUMBER);
            final Vector normalMessages = new Vector(MESSAGE_NUMBER);
            final Vector tooQuickMessages = new Vector();
            final Vector tooSlowMessages = new Vector();
            if (USE_DEBUGGER) {
                System.out.println("Press any key to continue...");
                try {
                    System.in.read();
                }
                catch (IOException ioex) {
                    // empty catch block
                }
            }
            this.adapter1.setListener(new MessageListener(){
                private boolean started = false;
                private boolean stopped = false;

                public byte[] getState() {
                    return null;
                }

                public void setState(byte[] state) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void receive(Message jgMessage) {
                    Object message = jgMessage.getObject();
                    if ("start".equals(message)) {
                        this.started = true;
                        MessageLoadTest.this.finishedReceiving = false;
                    } else if ("stop".equals(message)) {
                        this.stopped = true;
                        MessageLoadTest.this.finishedReceiving = true;
                        Object object = mutex;
                        synchronized (object) {
                            mutex.notifyAll();
                        }
                    } else if (message instanceof Long) {
                        Long travelTime = new Long(System.currentTimeMillis() - (Long)message);
                        if (!this.started) {
                            tooQuickMessages.add(message);
                        } else if (this.started && !this.stopped) {
                            receivedTimes.add(travelTime);
                            normalMessages.add(message);
                        } else {
                            tooSlowMessages.add(message);
                        }
                    }
                }
            });
            System.out.println("Free memory: " + Runtime.getRuntime().freeMemory());
            System.out.println("Total memory: " + Runtime.getRuntime().totalMemory());
            System.out.println("Starting sending messages.");
            long time = System.currentTimeMillis();
            Message startJgMessage = new Message();
            startJgMessage.setObject((Serializable)((Object)"start"));
            JChannel sender = LOOPBACK ? this.channel1 : this.channel2;
            sender.send(startJgMessage);
            for (int i = 0; i < MESSAGE_NUMBER; ++i) {
                message = new Long(System.currentTimeMillis());
                Message jgMessage = new Message();
                jgMessage.setObject((Serializable)message);
                sender.send(jgMessage);
                if (i % 1000 == 0) {
                    System.out.println("sent " + i + " messages.");
                }
                if (!SLEEP_BETWEEN_SENDING) continue;
                Util.sleep(1L, true);
            }
            Message stopJgMessage = new Message();
            stopJgMessage.setObject((Serializable)((Object)"stop"));
            sender.send(stopJgMessage);
            time = System.currentTimeMillis() - time;
            System.out.println("Finished sending messages. Operation took " + time);
            message = mutex;
            synchronized (message) {
                int received = 0;
                while (!this.finishedReceiving) {
                    mutex.wait(1000L);
                    if (receivedTimes.size() != received) {
                        received = receivedTimes.size();
                        System.out.println();
                        System.out.print("Received " + receivedTimes.size() + " messages.");
                        continue;
                    }
                    System.out.print(".");
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception ex) {
                // empty catch block
            }
            double avgDeliveryTime = -1.0;
            long maxDeliveryTime = Long.MIN_VALUE;
            long minDeliveryTime = Long.MAX_VALUE;
            Iterator iterator = receivedTimes.iterator();
            while (iterator.hasNext()) {
                Long message2 = (Long)iterator.next();
                avgDeliveryTime = avgDeliveryTime == -1.0 ? (double)message2.longValue() : (avgDeliveryTime + message2.doubleValue()) / 2.0;
                if (message2 > maxDeliveryTime) {
                    maxDeliveryTime = message2;
                }
                if (message2 >= minDeliveryTime) continue;
                minDeliveryTime = message2;
            }
            System.out.println("Sent " + MESSAGE_NUMBER + " messages.");
            System.out.println("Received " + receivedTimes.size() + " messages.");
            System.out.println("Average delivery time " + avgDeliveryTime + " ms");
            System.out.println("Minimum delivery time " + minDeliveryTime + " ms");
            System.out.println("Maximum delivery time " + maxDeliveryTime + " ms");
            System.out.println("Received " + tooQuickMessages.size() + " too quick messages");
            System.out.println("Received " + tooSlowMessages.size() + " too slow messages");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.out.println("Free memory: " + Runtime.getRuntime().freeMemory());
        System.out.println("Total memory: " + Runtime.getRuntime().totalMemory());
        System.out.println("Performing GC");
        Runtime.getRuntime().gc();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        System.out.println("Free memory: " + Runtime.getRuntime().freeMemory());
        System.out.println("Total memory: " + Runtime.getRuntime().totalMemory());
        if (USE_DEBUGGER) {
            System.out.println("Press any key to finish...");
            try {
                System.in.read();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-sleep")) {
                SLEEP_BETWEEN_SENDING = true;
                if (i >= args.length - 1) {
                    throw new RuntimeException("You have to specify sleep time");
                }
                try {
                    SLEEP_TIME = Integer.parseInt(args[++i]);
                    continue;
                }
                catch (NumberFormatException nfex) {
                    throw new RuntimeException("Cannot parse sleep time");
                }
            }
            if (args[i].equals("-msg_num")) {
                if (i >= args.length - 1) {
                    throw new RuntimeException("You have to specify messages number");
                }
                try {
                    MESSAGE_NUMBER = Integer.parseInt(args[++i]);
                    continue;
                }
                catch (NumberFormatException nfex) {
                    throw new RuntimeException("Cannot parse messages number");
                }
            }
            if (args[i].equals("-loopback")) {
                LOOPBACK = true;
                continue;
            }
            if (args[i].equals("-debug")) {
                USE_DEBUGGER = true;
                continue;
            }
            if (args[i].equals("-cummulative")) {
                CUMMULATIVE = true;
                continue;
            }
            if (!args[i].equals("-help")) continue;
            MessageLoadTest.help();
            return;
        }
        TestRunner.run((Class)(class$org$jgroups$tests$MessageLoadTest == null ? (class$org$jgroups$tests$MessageLoadTest = MessageLoadTest.class$("org.jgroups.tests.MessageLoadTest")) : class$org$jgroups$tests$MessageLoadTest));
    }

    static void help() {
        System.out.println("MessageLoadTest [-help] [-sleep <sleep time between sends (ms)>]  [-msg_num <number of msgs to send>] [-debug [-cummulative]] [-loopback]");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

