/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.View;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RpcDispatcher;

public class DeadlockTest {
    private String name = "JG";
    private String stack = "UDP:PING(num_initial_members=2;timeout=3000):FD:STABLE:NAKACK:UNICAST:FRAG:FLUSH:GMS:VIEW_ENFORCER:STATE_TRANSFER:QUEUE";
    private JChannel channel;
    private RpcDispatcher disp;

    private void _in_rpc_1() {
        System.out.println("In rpc_1()");
        this.cast_call("rpc_2", new Object[0]);
        System.out.println("Exiting rpc_1()");
    }

    private void _in_rpc_2() {
        System.out.println("In rpc_2()");
        System.out.println("Exiting rpc_2()");
    }

    private void cast_call(String method, Object[] args) {
        MethodCall call = new MethodCall(method);
        for (int i = 0; i < args.length; ++i) {
            call.addArg(args[i]);
        }
        this.disp.callRemoteMethods(null, call, 2, 0L);
    }

    public DeadlockTest(boolean use_deadlock_detection) {
        Handler handler = new Handler();
        InRpc in_rpc = new InRpc();
        try {
            this.channel = new JChannel(this.stack);
            this.disp = new RpcDispatcher((Channel)this.channel, (MessageListener)handler, (MembershipListener)handler, in_rpc, use_deadlock_detection);
            this.channel.connect(this.name);
        }
        catch (ChannelClosedException ex) {
            ex.printStackTrace();
        }
        catch (ChannelException ex) {
            ex.printStackTrace();
        }
        System.out.println("Calling rpc_1()");
        if (!use_deadlock_detection) {
            System.out.println("** Not using deadlock detection -- recursive call will hang !");
        } else {
            System.out.println("** Using deadlock detection -- recursive call will succeed");
        }
        this.cast_call("rpc_1", new Object[0]);
        System.out.println("Out of rpc_1()");
        this.channel.disconnect();
        this.channel.close();
        System.out.println("Disconnected");
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("DeadlockTest <true|false (use_deadlock_detection)>");
            return;
        }
        new DeadlockTest(new Boolean(args[0]));
    }

    private class Handler
    implements MessageListener,
    MembershipListener {
        public byte[] getState() {
            return null;
        }

        public void setState(byte[] state) {
        }

        public void receive(Message msg) {
        }

        public void block() {
        }

        public void suspect(Address suspect) {
        }

        public void viewAccepted(View view) {
        }
    }

    public class InRpc {
        public void rpc_1() {
            DeadlockTest.this._in_rpc_1();
        }

        public void rpc_2() {
            DeadlockTest.this._in_rpc_2();
        }
    }
}

