/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;
import org.jgroups.blocks.DistributedQueue;
import org.jgroups.log.Trace;

public class DistributedQueueTest
extends TestCase {
    final int NUM_ITEMS = 10;
    static Logger logger = Logger.getLogger((String)(class$org$jgroups$blocks$DistributedQueueTest == null ? (class$org$jgroups$blocks$DistributedQueueTest = DistributedQueueTest.class$("org.jgroups.blocks.DistributedQueueTest")) : class$org$jgroups$blocks$DistributedQueueTest).getName());
    String props;
    protected DistributedQueue queue1;
    protected DistributedQueue queue2;
    protected DistributedQueue queue3;
    static /* synthetic */ Class class$org$jgroups$blocks$DistributedQueueTest;

    public DistributedQueueTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return new TestSuite(class$org$jgroups$blocks$DistributedQueueTest == null ? (class$org$jgroups$blocks$DistributedQueueTest = DistributedQueueTest.class$("org.jgroups.blocks.DistributedQueueTest")) : class$org$jgroups$blocks$DistributedQueueTest);
    }

    public void setUp() throws Exception {
        this.props = "UDP(mcast_recv_buf_size=80000;mcast_send_buf_size=150000;mcast_port=45566;mcast_addr=228.8.8.8;ip_ttl=32):PING(timeout=2000;num_initial_members=3):FD_SOCK:VERIFY_SUSPECT(timeout=1500):UNICAST(timeout=600,1200,2000,2500):FRAG(frag_size=8096;down_thread=false;up_thread=false):TOTAL_TOKEN(unblock_sending=10;block_sending=50):pbcast.GMS(print_local_addr=true;join_timeout=3000;join_retry_timeout=2000;shun=true):STATE_TRANSFER:QUEUE";
        Trace.init();
        this.queue1 = new DistributedQueue("testing", null, this.props, 5000L);
        try {
            Thread.sleep(1000L);
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.queue2 = new DistributedQueue("testing", null, this.props, 5000L);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        this.queue3 = new DistributedQueue("testing", null, this.props, 5000L);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void tearDown() throws Exception {
        this.queue1.stop();
        this.queue2.stop();
        this.queue3.stop();
    }

    public void testConcurrent() throws Exception {
        PutTask t1 = new PutTask("Queue1", this.queue1);
        PutTask t2 = new PutTask("Queue2", this.queue2);
        PutTask t3 = new PutTask("Queue3", this.queue3);
        Thread rTask1 = new Thread(t1);
        Thread rTask2 = new Thread(t2);
        Thread rTask3 = new Thread(t3);
        rTask1.start();
        rTask2.start();
        rTask3.start();
        while (!(t1.finished() && t2.finished() && t3.finished())) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {}
        }
        DistributedQueueTest.assertEquals((int)this.queue1.size(), (int)this.queue2.size());
        DistributedQueueTest.assertEquals((int)this.queue1.size(), (int)this.queue3.size());
        this.checkContents(this.queue1.getContents(), this.queue2.getContents());
        this.checkContents(this.queue1.getContents(), this.queue3.getContents());
    }

    protected void checkContents(Vector q1, Vector q2) {
        for (int i = 0; i < q1.size(); ++i) {
            Object e2;
            Object e1 = q1.elementAt(i);
            boolean t = e1.equals(e2 = q2.elementAt(i));
            if (!t) {
                logger.error((Object)("Data order differs :" + e1 + "!=" + e2));
            } else {
                logger.debug((Object)("Data order ok :" + e1 + "==" + e2));
            }
            DistributedQueueTest.assertTrue((boolean)e1.equals(e2));
        }
    }

    public static void main(String[] args) {
        TestRunner.run((Test)DistributedQueueTest.suite());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class PutTask
    implements Runnable {
        protected DistributedQueue queue;
        protected String name;
        protected boolean finished;

        public PutTask(String name, DistributedQueue q) {
            this.queue = q;
            this.name = name;
            this.finished = false;
        }

        public void run() {
            for (int i = 0; i < 10; ++i) {
                this.queue.add(this.name + "_" + i);
            }
            this.finished = true;
        }

        public boolean finished() {
            return this.finished;
        }
    }
}

