/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.server.store;

import com.funambol.framework.server.store.Clause;
import com.funambol.framework.server.store.PreparedWhere;
import java.io.Serializable;
import org.apache.commons.lang.builder.ToStringBuilder;

public class WhereClause
extends Clause
implements Serializable {
    public static final String OPT_START_WITH = "START_WITH";
    public static final String OPT_END_WITH = "END_WITH";
    public static final String OPT_CONTAINS = "CONTAINS";
    public static final String OPT_EQ = "EQ";
    public static final String OPT_GT = "GT";
    public static final String OPT_LT = "LT";
    public static final String OPT_BETWEEN = "BETWEEN";
    public static final String OPT_GE = "GE";
    public static final String OPT_LE = "LE";
    private static final String OPT_UPPER = "upper(";
    private String property;
    private String[] value;
    private String operator;
    private boolean caseSensitive;

    protected WhereClause() {
        this(null, null, null, false);
    }

    public WhereClause(String property, String[] value, String operator, boolean caseSensitive) {
        this.property = property;
        this.value = value;
        this.operator = operator;
        this.caseSensitive = caseSensitive;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String[] getvalue() {
        return this.value;
    }

    public void setValue(String[] value) {
        this.value = value;
    }

    public void setParameter(String[] value) {
        this.value = value;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    @Override
    public PreparedWhere getPreparedWhere() {
        String property = this.getProperty();
        String operator = this.getOperator();
        String[] values = this.getvalue();
        boolean caseSensitive = this.isCaseSensitive();
        StringBuffer query = new StringBuffer();
        assert (values != null);
        PreparedWhere where = new PreparedWhere();
        where.parameters = new Object[values.length];
        String uprOpen = "";
        String uprClose = "";
        String uprProperty = property;
        if (!caseSensitive) {
            uprOpen = OPT_UPPER;
            uprClose = ")";
            uprProperty = " UPPER(" + property + ")";
        }
        if (OPT_START_WITH.equalsIgnoreCase(operator)) {
            query.append(uprProperty).append(" LIKE ").append(uprOpen).append('?').append(uprClose);
            where.sql = query.toString();
            where.parameters[0] = values[0] + '%';
        } else if (OPT_END_WITH.equalsIgnoreCase(operator)) {
            query.append(uprProperty).append(" LIKE ").append(uprOpen).append('?').append(uprClose);
            where.sql = query.toString();
            where.parameters[0] = '%' + values[0];
        } else if (OPT_CONTAINS.equalsIgnoreCase(operator)) {
            query.append(uprProperty).append(" LIKE ").append(uprOpen).append('?').append(uprClose);
            where.sql = query.toString();
            where.parameters[0] = '%' + values[0] + '%';
        } else if (OPT_EQ.equalsIgnoreCase(operator)) {
            query.append(uprProperty).append(" = ").append(uprOpen).append('?').append(uprClose);
            where.sql = query.toString();
            where.parameters[0] = values[0];
        } else if (OPT_GT.equalsIgnoreCase(operator)) {
            query.append(uprProperty).append(" > ").append(uprOpen).append('?').append(uprClose);
            where.sql = query.toString();
            where.parameters[0] = values[0];
        } else if (OPT_LT.equalsIgnoreCase(operator)) {
            query.append(uprProperty).append(" < ").append(uprOpen).append('?').append(uprClose);
            where.sql = query.toString();
            where.parameters[0] = values[0];
        } else if (OPT_BETWEEN.equalsIgnoreCase(operator)) {
            query.append(uprProperty).append(' ').append(OPT_BETWEEN).append(' ').append(uprOpen).append('?').append(uprClose).append(" AND ").append(uprOpen).append('?').append(uprClose);
            where.sql = query.toString();
            where.parameters[0] = values[0];
            where.parameters[1] = values[1];
        } else if (OPT_GE.equalsIgnoreCase(operator)) {
            query.append(uprProperty).append(" >= ").append(uprOpen).append('?').append(uprClose);
            where.sql = query.toString();
            where.parameters[0] = values[0];
        } else if (OPT_LE.equalsIgnoreCase(operator)) {
            query.append(uprProperty).append(" <= ").append(uprOpen).append('?').append(uprClose);
            where.sql = query.toString();
            where.parameters[0] = values[0];
        }
        where.sql = '(' + where.sql + ')';
        return where;
    }

    public String toString() {
        ToStringBuilder sb = new ToStringBuilder((Object)this);
        sb.append("operator:", (Object)this.operator);
        sb.append("property:", (Object)this.property);
        for (int i = 0; i < this.value.length; ++i) {
            sb.append("value:", (Object)this.value[i]);
        }
        sb.append("caseSensitive:", this.caseSensitive);
        return sb.toString();
    }
}

