/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.BlockEvent;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.Event;
import org.jgroups.ExitEvent;
import org.jgroups.GetStateEvent;
import org.jgroups.Message;
import org.jgroups.SetStateEvent;
import org.jgroups.SuspectEvent;
import org.jgroups.TimeoutException;
import org.jgroups.View;
import org.jgroups.conf.ConfiguratorFactory;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.log.Trace;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.stack.StateTransferInfo;
import org.jgroups.util.Queue;
import org.jgroups.util.QueueClosedException;
import org.jgroups.util.Util;

public class JChannel
extends Channel {
    private String props = "UDP(mcast_addr=228.1.2.3;mcast_port=45566;ip_ttl=32):PING(timeout=3000;num_initial_members=6):FD(timeout=3000):VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=10;retransmit_timeout=600,1200,2400,4800):UNICAST(timeout=600,1200,2400,4800):pbcast.STABLE(desired_avg_gossip=10000):FRAG:pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=true;print_local_addr=true)";
    final String FORCE_PROPS = "force.properties";
    private Address local_addr = null;
    private String channel_name = null;
    private View my_view = null;
    private Queue mq = new Queue();
    private ProtocolStack prot_stack = null;
    private Object local_addr_mutex = new Object();
    private Object connect_mutex = new Object();
    private boolean connect_ok_event_received = false;
    private Object disconnect_mutex = new Object();
    private boolean disconnect_ok_event_received = false;
    private Object get_state_mutex = new Object();
    private Object flow_control_mutex = new Object();
    private long LOCAL_ADDR_TIMEOUT = Long.parseLong(System.getProperty("local_addr.timeout", "30000"));
    private long GET_STATE_DEFAULT_TIMEOUT = 5000L;
    private boolean receive_views = true;
    private boolean receive_suspects = true;
    private boolean receive_blocks = false;
    private boolean receive_local_msgs = true;
    private boolean receive_get_states = false;
    private boolean auto_reconnect = false;
    private boolean auto_getstate = false;
    private boolean connected = false;
    private boolean block_sending = false;
    private boolean closed = false;
    private Object state = null;
    private boolean state_transfer_supported = false;

    protected JChannel(boolean dummy) throws ChannelException {
    }

    public JChannel() throws ChannelException {
        this(null);
    }

    public JChannel(Object properties) throws ChannelException {
        String tmp_props = System.getProperty("force.properties");
        if (tmp_props != null) {
            if (Trace.trace) {
                Trace.info("JChannel.JChannel()", "properties override: " + tmp_props);
            }
            properties = tmp_props;
        }
        if (properties != null) {
            try {
                ProtocolStackConfigurator c = ConfiguratorFactory.getStackConfigurator(properties);
                this.props = c.getProtocolStackString();
            }
            catch (Exception x) {
                String strace = Trace.getStackTrace(x);
                Trace.error("JChannel.constructor", strace);
                throw new ChannelException("JChannel: Unable to load protocol stack: {" + x.getMessage() + ";" + strace + "}");
            }
        }
        this.prot_stack = new ProtocolStack(this, this.props);
        try {
            this.prot_stack.setup();
        }
        catch (Throwable e) {
            throw new ChannelException("JChannel(): " + e);
        }
    }

    public ProtocolStack getProtocolStack() {
        return this.prot_stack;
    }

    public String getProperties() {
        return this.props;
    }

    public String printProtocolSpec(boolean include_properties) {
        return this.prot_stack != null ? this.prot_stack.printProtocolSpec(include_properties) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void connect(String channel_name) throws ChannelException, ChannelClosedException {
        this.checkClosed();
        if (this.connected) {
            Trace.error("JChannel.connect()", "already connected to " + channel_name);
            return;
        }
        if (channel_name == null) {
            if (Trace.trace) {
                Trace.info("JChannel.connect()", "channel_name is null, assuming unicast channel");
            }
        } else {
            this.channel_name = channel_name;
        }
        try {
            this.prot_stack.start();
        }
        catch (Throwable e) {
            Trace.error("JChannel.connect()", "exception: " + e);
            throw new ChannelException(e.toString());
        }
        Object e = this.local_addr_mutex;
        synchronized (e) {
            long start = System.currentTimeMillis();
            for (long wait_time = this.LOCAL_ADDR_TIMEOUT; this.local_addr == null && wait_time > 0L; wait_time -= System.currentTimeMillis() - start) {
                try {
                    this.local_addr_mutex.wait(wait_time);
                    continue;
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
        }
        if (this.local_addr == null) {
            Trace.fatal("JChannel.connect()", "local_addr == null; cannot connect");
            throw new ChannelException("local_addr is null");
        }
        Vector<Address> t = new Vector<Address>();
        t.addElement(this.local_addr);
        this.my_view = new View(this.local_addr, 0L, t);
        if (channel_name != null) {
            Object object = this.connect_mutex;
            synchronized (object) {
                Event connect_event = new Event(2, channel_name);
                this.connect_ok_event_received = false;
                this.down(connect_event);
                try {
                    while (!this.connect_ok_event_received) {
                        this.connect_mutex.wait();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
        }
        this.connected = true;
        if (this.channel_listener != null) {
            this.channel_listener.channelConnected(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnect() {
        if (this.closed) {
            return;
        }
        if (this.connected) {
            if (this.channel_name != null) {
                Event disconnect_event = new Event(4, this.local_addr);
                Object object = this.disconnect_mutex;
                synchronized (object) {
                    try {
                        this.disconnect_ok_event_received = false;
                        this.down(disconnect_event);
                        while (!this.disconnect_ok_event_received) {
                            this.disconnect_mutex.wait();
                        }
                    }
                    catch (Exception e) {
                        Trace.error("JChannel.disconnect()", "exception: " + e);
                    }
                }
            }
            this.down(new Event(23));
            this.connected = false;
            try {
                this.prot_stack.stop();
            }
            catch (Exception e) {
                Trace.error("JChannel.disconnect()", "exception: " + e);
            }
            if (this.channel_listener != null) {
                this.channel_listener.channelDisconnected(this);
            }
            this.init();
        }
    }

    public synchronized void close() {
        this._close(true, true);
    }

    public synchronized void open() throws ChannelException {
        if (!this.closed) {
            throw new ChannelException("JChannel.open(): channel is already open");
        }
        try {
            this.mq.reset();
            this.prot_stack = new ProtocolStack(this, this.props);
            this.prot_stack.setup();
            this.closed = false;
        }
        catch (Exception e) {
            throw new ChannelException("JChannel().open(): " + e.getMessage());
        }
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public int getNumMessages() {
        return this.mq != null ? this.mq.size() : -1;
    }

    public void send(Message msg) throws ChannelNotConnectedException, ChannelClosedException {
        this.checkClosed();
        this.checkNotConnected();
        this.down(new Event(1, msg));
    }

    public void send(Address dst, Address src, Serializable obj) throws ChannelNotConnectedException, ChannelClosedException {
        this.send(new Message(dst, src, obj));
    }

    public Object receive(long timeout) throws ChannelNotConnectedException, ChannelClosedException, TimeoutException {
        Object retval = null;
        this.checkClosed();
        this.checkNotConnected();
        try {
            Event evt = timeout <= 0L ? (Event)this.mq.remove() : (Event)this.mq.remove(timeout);
            retval = this.getEvent(evt);
            evt = null;
            return retval;
        }
        catch (QueueClosedException queue_closed) {
            throw new ChannelClosedException();
        }
        catch (TimeoutException t) {
            throw t;
        }
        catch (Exception e) {
            Trace.error("JChannel.receive()", "exception: " + e);
            return null;
        }
    }

    public Object peek(long timeout) throws ChannelNotConnectedException, ChannelClosedException, TimeoutException {
        Object retval = null;
        this.checkClosed();
        this.checkNotConnected();
        try {
            Event evt = timeout <= 0L ? (Event)this.mq.peek() : (Event)this.mq.peek(timeout);
            retval = this.getEvent(evt);
            evt = null;
            return retval;
        }
        catch (QueueClosedException queue_closed) {
            Trace.error("JChannel.peek()", "exception: " + queue_closed);
            return null;
        }
        catch (TimeoutException t) {
            return null;
        }
        catch (Exception e) {
            Trace.error("JChannel.peek()", "exception: " + e);
            return null;
        }
    }

    public View getView() {
        return this.closed || !this.connected ? null : this.my_view;
    }

    public Address getLocalAddress() {
        return this.closed ? null : this.local_addr;
    }

    public String getChannelName() {
        return this.closed ? null : (!this.connected ? null : this.channel_name);
    }

    public void setOpt(int option, Object value) {
        if (this.closed) {
            Trace.warn("JChannel.setOpt()", "channel is closed; option not set !");
            return;
        }
        switch (option) {
            case 1: {
                if (value instanceof Boolean) {
                    this.receive_views = (Boolean)value;
                    break;
                }
                Trace.error("JChannel.setOpt()", "option " + Channel.option2String(option) + " (" + value + "): value has to be Boolean");
                break;
            }
            case 2: {
                if (value instanceof Boolean) {
                    this.receive_suspects = (Boolean)value;
                    break;
                }
                Trace.error("JChannel.setOpt()", "option " + Channel.option2String(option) + " (" + value + "): value has to be Boolean");
                break;
            }
            case 0: {
                if (value instanceof Boolean) {
                    this.receive_blocks = (Boolean)value;
                } else {
                    Trace.error("JChannel.setOpt()", "option " + Channel.option2String(option) + " (" + value + "): value has to be Boolean");
                }
                if (!this.receive_blocks) break;
                this.receive_views = true;
                break;
            }
            case 4: {
                if (value instanceof Boolean) {
                    this.receive_get_states = (Boolean)value;
                    break;
                }
                Trace.error("JChannel.setOpt()", "option " + Channel.option2String(option) + " (" + value + "): value has to be Boolean");
                break;
            }
            case 3: {
                if (value instanceof Boolean) {
                    this.receive_local_msgs = (Boolean)value;
                    break;
                }
                Trace.error("JChannel.setOpt()", "option " + Channel.option2String(option) + " (" + value + "): value has to be Boolean");
                break;
            }
            case 5: {
                if (value instanceof Boolean) {
                    this.auto_reconnect = (Boolean)value;
                    break;
                }
                Trace.error("JChannel.setOpt()", "option " + Channel.option2String(option) + " (" + value + "): value has to be Boolean");
                break;
            }
            case 6: {
                if (value instanceof Boolean) {
                    this.auto_getstate = (Boolean)value;
                    if (!this.auto_getstate) break;
                    this.auto_reconnect = true;
                    break;
                }
                Trace.error("JChannel.setOpt()", "option " + Channel.option2String(option) + " (" + value + "): value has to be Boolean");
                break;
            }
            default: {
                Trace.error("JChannel.setOpt()", "option " + Channel.option2String(option) + " not known");
            }
        }
    }

    public Object getOpt(int option) {
        switch (option) {
            case 1: {
                return new Boolean(this.receive_views);
            }
            case 0: {
                return new Boolean(this.receive_blocks);
            }
            case 2: {
                return new Boolean(this.receive_suspects);
            }
            case 4: {
                return new Boolean(this.receive_get_states);
            }
            case 3: {
                return new Boolean(this.receive_local_msgs);
            }
        }
        Trace.error("JChannel.getOpt()", "option " + Channel.option2String(option) + " not known");
        return null;
    }

    public void blockOk() {
        this.down(new Event(11));
        this.down(new Event(22));
    }

    public boolean getState(Address target, long timeout) throws ChannelNotConnectedException, ChannelClosedException {
        StateTransferInfo info = new StateTransferInfo(1, target);
        return this._getState(new Event(19, info), timeout);
    }

    public boolean getAllStates(Vector targets, long timeout) throws ChannelNotConnectedException, ChannelClosedException {
        StateTransferInfo info = new StateTransferInfo(2, targets);
        return this._getState(new Event(19, info), timeout);
    }

    public void returnState(byte[] state) {
        this.down(new Event(18, state));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void up(Event evt) {
        int type = evt.getType();
        if (this.mq == null) {
            Trace.error("JChannel.up()", "message queue is null");
            return;
        }
        switch (type) {
            case 1: {
                Message msg = (Message)evt.getArg();
                if (this.receive_local_msgs || this.local_addr == null || msg.getSrc() == null || !this.local_addr.equals(msg.getSrc())) break;
                return;
            }
            case 6: {
                this.my_view = (View)evt.getArg();
                if (!this.connected) {
                    this.connected = true;
                }
                this.down(new Event(23));
                if (this.receive_views) break;
                return;
            }
            case 9: {
                if (this.receive_suspects) break;
                return;
            }
            case 17: {
                if (this.receive_get_states) break;
                this.down(new Event(18, null));
                return;
            }
            case 56: {
                HashMap config = (HashMap)evt.getArg();
                if (config == null || !config.containsKey("state_transfer")) break;
                this.state_transfer_supported = (Boolean)config.get("state_transfer");
                break;
            }
            case 10: {
                if (this.receive_blocks) break;
                this.down(new Event(11));
                this.down(new Event(22));
                return;
            }
            case 3: {
                Object object = this.connect_mutex;
                synchronized (object) {
                    this.connect_ok_event_received = true;
                    this.connect_mutex.notify();
                    break;
                }
            }
            case 5: {
                Object object = this.disconnect_mutex;
                synchronized (object) {
                    this.disconnect_ok_event_received = true;
                    this.disconnect_mutex.notifyAll();
                    break;
                }
            }
            case 20: {
                try {
                    this.mq.add(new Event(21, evt.getArg()));
                }
                catch (Exception e) {
                    // empty catch block
                }
                Object object = this.get_state_mutex;
                synchronized (object) {
                    this.state = evt.getArg();
                    this.get_state_mutex.notify();
                    break;
                }
            }
            case 8: {
                Object object = this.local_addr_mutex;
                synchronized (object) {
                    this.local_addr = (Address)evt.getArg();
                    this.local_addr_mutex.notifyAll();
                    break;
                }
            }
            case 46: {
                this.handleExit(evt);
                return;
            }
            case 54: {
                Object object = this.flow_control_mutex;
                synchronized (object) {
                    if (Trace.trace) {
                        Trace.info("JChannel.up()", "received BLOCK_SEND");
                    }
                    this.block_sending = true;
                    this.flow_control_mutex.notifyAll();
                    break;
                }
            }
            case 55: {
                Object object = this.flow_control_mutex;
                synchronized (object) {
                    if (Trace.trace) {
                        Trace.info("JChannel.up()", "received UNBLOCK_SEND");
                    }
                    this.block_sending = false;
                    this.flow_control_mutex.notifyAll();
                    break;
                }
            }
        }
        if (this.up_handler != null) {
            this.up_handler.up(evt);
            return;
        }
        if (type == 1 || type == 6 || type == 9 || type == 17 || type == 10 || type == 46) {
            try {
                this.mq.add(evt);
            }
            catch (Exception e) {
                Trace.error("JChannel.up()", "exception: " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void down(Event evt) {
        if (evt == null) {
            return;
        }
        if (this.block_sending && evt.getType() == 1) {
            Object object = this.flow_control_mutex;
            synchronized (object) {
                while (this.block_sending) {
                    try {
                        if (Trace.trace) {
                            Trace.info("JChannel.down()", "down() blocks because block_sending == true");
                        }
                        this.flow_control_mutex.wait();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (this.prot_stack != null) {
            this.prot_stack.down(evt);
        } else {
            Trace.error("JChannel.down()", "no protocol stack available");
        }
    }

    public String toString(boolean details) {
        StringBuffer sb = new StringBuffer();
        sb.append("local_addr=").append(this.local_addr).append("\n");
        sb.append("channel_name=").append(this.channel_name).append("\n");
        sb.append("my_view=").append(this.my_view).append("\n");
        sb.append("connected=").append(this.connected).append("\n");
        sb.append("closed=").append(this.closed).append("\n");
        if (this.mq != null) {
            sb.append("incoming queue size=").append(this.mq.size()).append("\n");
        }
        if (details) {
            sb.append("block_sending=").append(this.block_sending).append("\n");
            sb.append("receive_views=").append(this.receive_views).append("\n");
            sb.append("receive_suspects=").append(this.receive_suspects).append("\n");
            sb.append("receive_blocks=").append(this.receive_blocks).append("\n");
            sb.append("receive_local_msgs=").append(this.receive_local_msgs).append("\n");
            sb.append("receive_get_states=").append(this.receive_get_states).append("\n");
            sb.append("auto_reconnect=").append(this.auto_reconnect).append("\n");
            sb.append("auto_getstate=").append(this.auto_getstate).append("\n");
            sb.append("state_transfer_supported=").append(this.state_transfer_supported).append("\n");
            sb.append("props=").append(this.props).append("\n");
        }
        return sb.toString();
    }

    private void init() {
        this.local_addr = null;
        this.channel_name = null;
        this.my_view = null;
        if (this.mq != null && this.mq.closed()) {
            this.mq.reset();
        }
        this.connect_ok_event_received = false;
        this.disconnect_ok_event_received = false;
        this.connected = false;
        this.block_sending = false;
    }

    void checkNotConnected() throws ChannelNotConnectedException {
        if (!this.connected) {
            throw new ChannelNotConnectedException();
        }
    }

    void checkClosed() throws ChannelClosedException {
        if (this.closed) {
            throw new ChannelClosedException();
        }
    }

    Object getEvent(Event evt) {
        if (evt == null) {
            return null;
        }
        switch (evt.getType()) {
            case 1: {
                return evt.getArg();
            }
            case 6: {
                return evt.getArg();
            }
            case 9: {
                return new SuspectEvent(evt.getArg());
            }
            case 10: {
                return new BlockEvent();
            }
            case 17: {
                return new GetStateEvent(evt.getArg());
            }
            case 21: {
                return new SetStateEvent((byte[])evt.getArg());
            }
            case 46: {
                return new ExitEvent();
            }
        }
        return evt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean _getState(Event evt, long timeout) throws ChannelNotConnectedException, ChannelClosedException {
        this.checkClosed();
        this.checkNotConnected();
        if (!this.state_transfer_supported) {
            Trace.warn("JChannel._getState()", "fetching state will fail as state transfer is not supported. Add one of the STATE_TRANSFER protocols to your protocol specification");
        }
        Object object = this.get_state_mutex;
        synchronized (object) {
            this.state = null;
            this.down(evt);
            try {
                if (timeout <= 0L) {
                    this.get_state_mutex.wait();
                } else {
                    this.get_state_mutex.wait(timeout);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return this.state != null;
            {
            }
        }
    }

    void _close(boolean disconnect, boolean close_mq) {
        if (this.closed) {
            return;
        }
        if (disconnect) {
            this.disconnect();
        }
        if (close_mq) {
            try {
                this.mq.close(false);
            }
            catch (Exception e) {
                Trace.error("JChannel._close()", "exception: " + e);
            }
        }
        if (this.prot_stack != null) {
            try {
                this.prot_stack.stop();
                this.prot_stack.destroy();
            }
            catch (Exception e) {
                Trace.error("JChannel._close()", "exception: " + e);
            }
        }
        this.closed = true;
        this.connected = false;
        if (this.channel_listener != null) {
            this.channel_listener.channelClosed(this);
        }
        this.init();
    }

    void handleExit(Event evt) {
        if (this.channel_listener != null) {
            this.channel_listener.channelShunned();
        }
        new CloserThread(evt);
    }

    class CloserThread
    implements Runnable {
        Event evt;
        Thread t = null;

        CloserThread(Event evt) {
            this.evt = evt;
            this.start();
        }

        public void start() {
            this.t = new Thread((Runnable)this, "CloserThread");
            this.t.setDaemon(true);
            this.t.start();
        }

        public void run() {
            try {
                String old_channel_name = JChannel.this.channel_name;
                JChannel.this._close(false, false);
                if (JChannel.this.up_handler != null) {
                    JChannel.this.up_handler.up(this.evt);
                } else {
                    try {
                        JChannel.this.mq.add(this.evt);
                    }
                    catch (Exception ex) {
                        Trace.error("JChannel.CloserThread.run()", "exception: " + ex);
                    }
                }
                if (JChannel.this.mq != null) {
                    Util.sleep(500L);
                    try {
                        JChannel.this.mq.close(false);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (JChannel.this.auto_reconnect) {
                    try {
                        Trace.info("JChannel.CloserThread.run()", "reconnecting to group " + old_channel_name);
                        JChannel.this.open();
                        JChannel.this.connect(old_channel_name);
                        if (JChannel.this.channel_listener != null) {
                            JChannel.this.channel_listener.channelReconnected(JChannel.this.local_addr);
                        }
                    }
                    catch (Exception ex) {
                        Trace.error("JChannel.CloserThread.run()", "failure reopening channel: " + ex);
                        return;
                    }
                }
                if (JChannel.this.auto_getstate) {
                    boolean rc = JChannel.this.getState(null, JChannel.this.GET_STATE_DEFAULT_TIMEOUT);
                    if (rc) {
                        Trace.info("JChannel.CloserThread.run()", "state was retrieved successfully");
                    } else {
                        Trace.info("JChannel.CloserThread.run()", "state transfer failed");
                    }
                }
            }
            catch (Exception ex) {
                Trace.error("JChannel.CloserThread.run()", "exception: " + ex);
            }
        }
    }
}

