/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class JDOMAbout {
    public static void main(String[] args) {
        Info info = new JDOMAbout().new Info();
        String title = info.title;
        System.out.println(String.valueOf(title) + " version " + info.version);
        System.out.println("Copyright " + info.copyright);
        System.out.println();
        System.out.println(info.description);
        System.out.println();
        System.out.println("Authors:");
        Iterator it = info.authors.iterator();
        while (it.hasNext()) {
            Author author = (Author)it.next();
            System.out.print("  " + author.name);
            if (author.email == null) {
                System.out.println();
                continue;
            }
            System.out.println(" <" + author.email + ">");
        }
        System.out.println();
        System.out.println(String.valueOf(title) + " license:");
        System.out.println(info.license);
        System.out.println();
        System.out.println(String.valueOf(title) + " support:");
        System.out.println(info.support);
        System.out.println();
        System.out.println(String.valueOf(title) + " web site: " + info.website);
        System.out.println();
    }

    private class Info {
        String title;
        String version;
        String copyright;
        String description;
        List authors;
        String license;
        String support;
        String website;

        Info() {
            String INFO_FILENAME = "META-INF/info.xml";
            SAXBuilder builder = new SAXBuilder();
            String jarFileName = System.getProperty("java.class.path");
            try {
                JarFile jarFile = new JarFile(jarFileName);
                ZipEntry zipEntry = jarFile.getEntry("META-INF/info.xml");
                if (zipEntry == null) {
                    System.err.println("Incomplete JAR file - META-INF/info.xml file not found");
                    System.exit(1);
                }
                InputStream in = jarFile.getInputStream(zipEntry);
                Document doc = builder.build(in);
                Element root = doc.getRootElement();
                this.title = root.getChildTextTrim("title");
                this.version = root.getChildTextTrim("version");
                this.copyright = root.getChildTextTrim("copyright");
                this.description = root.getChildTextTrim("description");
                this.license = root.getChildTextTrim("license");
                this.support = root.getChildTextTrim("support");
                this.website = root.getChildTextTrim("web-site");
                List authorElements = root.getChildren("author");
                this.authors = new LinkedList();
                Iterator it = authorElements.iterator();
                while (it.hasNext()) {
                    Element element = (Element)it.next();
                    Author author = new Author();
                    author.name = element.getChildTextTrim("name");
                    author.email = element.getChildTextTrim("e-mail");
                    this.authors.add(author);
                }
            }
            catch (JDOMException exJdom) {
                System.err.println(exJdom);
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }
    }

    private class Author {
        String name;
        String email;

        Author() {
        }
    }
}

