/*
 * Decompiled with CFR 0.152.
 */
package org.vmguys.vmtools.ota;

import java.util.List;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.vmguys.vmtools.ota.OtaUpdate;
import org.vmguys.vmtools.ota.UniqueId;
import org.vmguys.vmtools.utils.CostOps;
import org.vmguys.vmtools.utils.DiffElement;
import org.vmguys.vmtools.utils.DifferenceFinder2;

public class TestOtaUpdate
extends TestCase {
    private DiffElement original;
    private DiffElement modified;
    private UniqueId id;
    private OtaUpdate otaUpdate;
    private Namespace namespace;

    public TestOtaUpdate(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.original = this.createOriginal();
        this.modified = this.createModified();
        this.id = new UniqueId("Profile", "12345");
        this.otaUpdate = new OtaUpdate(true);
        this.namespace = Namespace.getNamespace((String)"http://www.opentravel.org/OTA");
    }

    protected void tearDown() throws Exception {
        this.original = null;
        this.modified = null;
        this.id = null;
        this.otaUpdate = null;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new TestOtaUpdate("testNothing"));
        suite.addTest((Test)new TestOtaUpdate("testReplace"));
        suite.addTest((Test)new TestOtaUpdate("testGenDiff"));
        return suite;
    }

    public void testNothing() {
    }

    public void testReplace() {
        Assert.assertTrue((String)"initial value of 'replace' is incorrect", (this.otaUpdate.replace ? 1 : 0) != 0);
        this.otaUpdate.setReplace(false);
        Assert.assertTrue((String)"can't set 'replace' to false", (!this.otaUpdate.replace ? 1 : 0) != 0);
        this.otaUpdate.setReplace(true);
        Assert.assertTrue((String)"can't set 'replace' to true", (this.otaUpdate.replace ? 1 : 0) != 0);
    }

    public void testGenDiff() {
        try {
            DiffElement diffs = (DiffElement)this.otaUpdate.generateDiffs(this.original, this.modified, this.id);
            boolean looksGood = false;
            if (diffs.getName().equals("OTA_UpdateRQ")) {
                Element position = diffs.getChild("Position", this.namespace);
                if (position != null) {
                    Element root = position.getChild("Root", this.namespace);
                    if (root != null) {
                        List children = root.getChildren();
                        if (children.size() == 1) {
                            DifferenceFinder2 diff = new DifferenceFinder2();
                            Element content = (Element)children.get(0);
                            CostOps co = diff.findDifferences((Element)this.modified, content);
                            looksGood = co.getCost() == 0;
                        } else {
                            Assert.fail((String)("Root contains " + children.size() + " elements instead of 1"));
                        }
                    } else {
                        Assert.fail((String)"can't get Root element");
                    }
                } else {
                    Assert.fail((String)"can't get Position element");
                }
            } else {
                Assert.fail((String)"first element is not OTA_UpdateRQ");
            }
            if (!looksGood) {
                Assert.fail((String)"the diffs don't look right");
            }
        }
        catch (JDOMException jde) {
            Assert.fail((String)("caught JDOMException generating diffs: " + jde.getMessage()));
        }
    }

    private DiffElement createOriginal() {
        DiffElement nameTitle = new DiffElement("NameTitle");
        nameTitle.addContent("Mr.");
        DiffElement givenName = new DiffElement("GivenName");
        givenName.addContent("George");
        DiffElement surName = new DiffElement("SurName");
        surName.addContent("Smith");
        DiffElement personName = new DiffElement("PersonName");
        personName.setAttribute("NameType", "Default");
        personName.addContent(nameTitle);
        personName.addContent(givenName);
        personName.addContent(surName);
        DiffElement customer = new DiffElement("Customer");
        customer.addContent(personName);
        DiffElement profile = new DiffElement("Profile");
        profile.addContent(customer);
        return profile;
    }

    private DiffElement createModified() {
        DiffElement newSurName = new DiffElement("SurName");
        newSurName.addContent("Jones");
        DiffElement profile = this.createOriginal();
        DiffElement personName = (DiffElement)profile.getChild("Customer").getChild("PersonName");
        personName.removeChild("SurName");
        personName.addContent(newSurName);
        return profile;
    }

    private String listTree(Element root) {
        String nl = System.getProperty("line.separator");
        StringBuffer xml = new StringBuffer();
        this.listTree(root, xml, nl);
        return xml.toString();
    }

    private void listTree(Element node, StringBuffer xml, String nl) {
        xml.append("<" + node.getName() + this.listAttribs(node) + ">" + nl);
        xml.append(this.listContents(node) + nl);
        List children = node.getChildren();
        int i = 0;
        while (i < children.size()) {
            this.listTree((Element)children.get(i), xml, nl);
            ++i;
        }
        xml.append("</" + node.getName() + ">" + nl);
    }

    private String listAttribs(Element n) {
        StringBuffer rslt = new StringBuffer();
        List attribs = n.getAttributes();
        int a = 0;
        while (a < attribs.size()) {
            Attribute attrib = (Attribute)attribs.get(a);
            rslt.append(" " + attrib.getName() + "=\"" + attrib.getValue() + "\"");
            ++a;
        }
        return rslt.toString();
    }

    private String listContents(Element n) {
        StringBuffer rslt = new StringBuffer();
        List cont = n.getContent();
        int i = 0;
        while (i < cont.size()) {
            Object x = cont.get(i);
            if (x instanceof String) {
                rslt.append((String)x + " ");
            }
            ++i;
        }
        return rslt.toString();
    }
}

