/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.util.Enumeration;

public class McastReceiverTest1_4 {
    public static void main(String[] args) {
        InetAddress mcast_addr = null;
        InetAddress bind_addr = null;
        int port = 5555;
        boolean use_all_interfaces = false;
        try {
            for (int i = 0; i < args.length; ++i) {
                String tmp = args[i];
                if (tmp.equals("-help")) {
                    McastReceiverTest1_4.help();
                    return;
                }
                if (tmp.equals("-bind_addr")) {
                    bind_addr = InetAddress.getByName(args[++i]);
                    continue;
                }
                if (tmp.equals("-mcast_addr")) {
                    mcast_addr = InetAddress.getByName(args[++i]);
                    continue;
                }
                if (tmp.equals("-port")) {
                    port = Integer.parseInt(args[++i]);
                    continue;
                }
                if (tmp.equals("-use_all_interfaces")) {
                    use_all_interfaces = true;
                    continue;
                }
                McastReceiverTest1_4.help();
                return;
            }
            if (mcast_addr == null) {
                mcast_addr = InetAddress.getByName("224.0.0.150");
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
            return;
        }
        if (use_all_interfaces && !McastReceiverTest1_4.is1_4()) {
            System.err.println("-use_all_interfaces flag requires JDK 1.4 or greater");
            return;
        }
        try {
            if (use_all_interfaces) {
                Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
                while (en.hasMoreElements()) {
                    NetworkInterface intf = en.nextElement();
                    Enumeration<InetAddress> e2 = intf.getInetAddresses();
                    while (e2.hasMoreElements()) {
                        bind_addr = e2.nextElement();
                        Receiver r = new Receiver(mcast_addr, bind_addr, port);
                        r.start();
                    }
                }
            } else {
                Receiver r = new Receiver(mcast_addr, bind_addr, port);
                r.start();
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    static boolean is1_4() {
        try {
            Class<?> cl = Thread.currentThread().getContextClassLoader().loadClass("java.net.NetworkInterface");
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    static void help() {
        System.out.println("McastSenderTest [-bind_addr <bind address>] [-help] [-mcast_addr <multicast address>] [-port <port for multicast socket>] [-use_all_interfaces (JDK 1.4 only)]");
    }

    static class Receiver
    extends Thread {
        MulticastSocket sock = null;
        DatagramPacket packet;
        byte[] buf = null;
        byte[] recv_buf;

        Receiver(InetAddress mcast_addr, InetAddress bind_interface, int port) throws Exception {
            this.sock = new MulticastSocket(port);
            if (bind_interface != null) {
                this.sock.setInterface(bind_interface);
            }
            this.sock.joinGroup(mcast_addr);
            System.out.println("Socket=" + this.sock.getLocalAddress() + ":" + this.sock.getLocalPort() + ", bind interface=" + this.sock.getInterface());
        }

        public void run() {
            try {
                while (true) {
                    this.buf = new byte[256];
                    this.packet = new DatagramPacket(this.buf, this.buf.length);
                    this.sock.receive(this.packet);
                    this.recv_buf = this.packet.getData();
                    System.out.println(new String(this.recv_buf) + " [sender=" + this.packet.getAddress().getHostAddress() + ":" + this.packet.getPort() + "]");
                }
            }
            catch (Exception ex) {
                System.err.println("Receiver terminated: " + ex);
                return;
            }
        }
    }
}

