/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.log.Trace;
import org.jgroups.protocols.pbcast.Digest;
import org.jgroups.protocols.pbcast.Gossip;
import org.jgroups.protocols.pbcast.PbcastHeader;
import org.jgroups.stack.NakReceiverWindow;
import org.jgroups.stack.Protocol;
import org.jgroups.util.List;
import org.jgroups.util.Queue;
import org.jgroups.util.QueueClosedException;
import org.jgroups.util.Util;

public class PBCAST
extends Protocol
implements Runnable {
    boolean operational = false;
    long seqno = 1L;
    long gossip_round = 1L;
    Address local_addr = null;
    Hashtable digest = new Hashtable();
    Thread gossip_thread = null;
    GossipHandler gossip_handler = null;
    Queue gossip_queue = new Queue();
    int max_queue = 100;
    long gossip_interval = 5000L;
    double subset = 0.1;
    long desired_avg_gossip = 30000L;
    Vector members = new Vector();
    List gossip_list = new List();
    int max_gossip_cache = 100;
    int gc_lag = 30;
    Hashtable invalid_gossipers = new Hashtable();
    int max_invalid_gossips = 2;
    Vector seen_list = null;
    boolean shun = false;
    boolean dynamic = true;
    boolean skip_sleep = true;
    boolean mcast_gossip = true;

    public String getName() {
        return "PBCAST";
    }

    public Vector providedUpServices() {
        Vector<Integer> retval = new Vector<Integer>();
        retval.addElement(new Integer(39));
        retval.addElement(new Integer(41));
        retval.addElement(new Integer(42));
        return retval;
    }

    public void stop() {
        this.stopGossipThread();
        this.stopGossipHandler();
        this.operational = false;
    }

    public void up(Event evt) {
        Address sender = null;
        switch (evt.getType()) {
            case 1: {
                Message m = (Message)evt.getArg();
                if (m.getDest() != null && !m.getDest().isMulticastAddress() && !(m.getHeader(this.getName()) instanceof PbcastHeader)) break;
                if (!this.operational) {
                    if (Trace.trace) {
                        Trace.info("PBCAST.up()", "event was discarded as I'm not yet operational. Event: " + Util.printEvent(evt));
                    }
                    return;
                }
                if (!(m.getHeader(this.getName()) instanceof PbcastHeader)) {
                    sender = m.getSrc();
                    if (!Trace.trace) break;
                    Trace.error("PBCAST.up()", "PbcastHeader expected, but received header of type " + m.getHeader(this.getName()).getClass().getName() + " from " + sender + ". Passing event up unchanged");
                    break;
                }
                PbcastHeader hdr = (PbcastHeader)m.removeHeader(this.getName());
                switch (hdr.type) {
                    case 0: {
                        this.handleUpMessage(m, hdr);
                        return;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        try {
                            if (this.gossip_queue.size() >= this.max_queue) {
                                if (Trace.trace) {
                                    Trace.warn("PBCAST.up()", "gossip request " + PbcastHeader.type2String(hdr.type) + " discarded because " + "gossip_queue is full (number of elements=" + this.gossip_queue.size() + ")");
                                }
                                return;
                            }
                            this.gossip_queue.add(new GossipEntry(hdr, m.getSrc(), m.getBuffer()));
                        }
                        catch (Exception ex) {
                            Trace.warn("PBCAST.up()", "exception adding request to gossip_queue, details=" + ex);
                        }
                        return;
                    }
                }
                Trace.error("PBCAST.up()", "type (" + hdr.type + ") of PbcastHeader not known !");
                return;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message m = (Message)evt.getArg();
                if (m.getDest() != null && !m.getDest().isMulticastAddress()) break;
                PbcastHeader hdr = new PbcastHeader(0, this.seqno);
                m.putHeader(this.getName(), hdr);
                Hashtable hashtable = this.digest;
                synchronized (hashtable) {
                    NakReceiverWindow win = (NakReceiverWindow)this.digest.get(this.local_addr);
                    if (win == null) {
                        Trace.info("PBCAST.down()", "NakReceiverWindow for sender " + this.local_addr + " not found. Creating new NakReceiverWindow starting at seqno=" + this.seqno);
                        win = new NakReceiverWindow(this.local_addr, this.seqno);
                        this.digest.put(this.local_addr, win);
                    }
                    Message copy = m.copy();
                    copy.setSrc(this.local_addr);
                    win.add(this.seqno, copy);
                }
                ++this.seqno;
                break;
            }
            case 41: {
                this.setDigest((Digest)evt.getArg());
                return;
            }
            case 39: {
                this.passUp(new Event(40, this.getDigest()));
                return;
            }
            case 42: {
                this.passUp(new Event(43, this.getDigest()));
                return;
            }
            case 6: {
                Address key;
                View v = (View)evt.getArg();
                if (v == null) {
                    Trace.error("PBCAST.down(VIEW_CHANGE)", "view is null !");
                    break;
                }
                Vector mbrs = v.getMembers();
                Cloneable cloneable = this.members;
                synchronized (cloneable) {
                    this.members.removeAllElements();
                    for (int i = 0; i < mbrs.size(); ++i) {
                        this.members.addElement(mbrs.elementAt(i));
                    }
                }
                if (mbrs.size() > 0) {
                    cloneable = this.digest;
                    synchronized (cloneable) {
                        Enumeration e = this.digest.keys();
                        while (e.hasMoreElements()) {
                            key = (Address)e.nextElement();
                            if (mbrs.contains(key)) continue;
                            NakReceiverWindow win = (NakReceiverWindow)this.digest.get(key);
                            win.reset();
                            this.digest.remove(key);
                        }
                    }
                }
                for (int i = 0; i < mbrs.size(); ++i) {
                    key = (Address)mbrs.elementAt(i);
                    if (this.digest.containsKey(key)) continue;
                    this.digest.put(key, new NakReceiverWindow(key, 1L));
                }
                if (this.dynamic) {
                    this.gossip_interval = this.computeGossipInterval(this.members.size(), this.desired_avg_gossip);
                    if (Trace.trace) {
                        Trace.info("PBCAST.down()", "VIEW_CHANGE: gossip_interval=" + this.gossip_interval);
                    }
                    if (this.gossip_thread != null) {
                        this.skip_sleep = true;
                        this.gossip_thread.interrupt();
                    }
                }
                this.startGossipThread();
                this.startGossipHandler();
                break;
            }
            case 16: {
                this.operational = true;
            }
        }
        this.passDown(evt);
    }

    public void run() {
        while (this.gossip_thread != null) {
            if (this.dynamic) {
                this.gossip_interval = this.computeGossipInterval(this.members.size(), this.desired_avg_gossip);
                if (Trace.trace) {
                    Trace.info("PBCAST.run()", "gossip_interval=" + this.gossip_interval);
                }
            }
            Util.sleep(this.gossip_interval);
            if (this.skip_sleep) {
                this.skip_sleep = false;
                continue;
            }
            this.sendGossip();
        }
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("dynamic");
        if (str != null) {
            this.dynamic = new Boolean(str);
            props.remove("dynamic");
        }
        if ((str = props.getProperty("shun")) != null) {
            this.shun = new Boolean(str);
            props.remove("shun");
        }
        if ((str = props.getProperty("gossip_interval")) != null) {
            this.gossip_interval = new Long(str);
            props.remove("gossip_interval");
        }
        if ((str = props.getProperty("mcast_gossip")) != null) {
            this.mcast_gossip = new Boolean(str);
            props.remove("mcast_gossip");
        }
        if ((str = props.getProperty("subset")) != null) {
            this.subset = new Double(str);
            props.remove("subset");
        }
        if ((str = props.getProperty("desired_avg_gossip")) != null) {
            this.desired_avg_gossip = new Long(str);
            props.remove("desired_avg_gossip");
        }
        if ((str = props.getProperty("max_queue")) != null) {
            this.max_queue = new Integer(str);
            props.remove("max_queue");
        }
        if ((str = props.getProperty("max_gossip_cache")) != null) {
            this.max_gossip_cache = new Integer(str);
            props.remove("max_gossip_cache");
        }
        if ((str = props.getProperty("gc_lag")) != null) {
            this.gc_lag = new Integer(str);
            props.remove("gc_lag");
        }
        if (props.size() > 0) {
            System.err.println("PBCAST.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleUpMessage(Message m, PbcastHeader hdr) {
        Address sender = m.getSrc();
        NakReceiverWindow win = null;
        long seqno = hdr.seqno;
        if (sender == null) {
            Trace.error("PBCAST.handleUpMessage()", "sender is null");
            return;
        }
        Hashtable hashtable = this.digest;
        synchronized (hashtable) {
            Message tmpmsg;
            win = (NakReceiverWindow)this.digest.get(sender);
            if (win == null) {
                Trace.warn("PBCAST.handleUpMessage()", "NakReceiverWindow for sender " + sender + " not found. Creating new NakReceiverWindow starting at seqno=" + seqno);
                win = new NakReceiverWindow(sender, seqno);
                this.digest.put(sender, win);
            }
            m.putHeader(this.getName(), hdr);
            win.add(seqno, m);
            if (Trace.trace) {
                Trace.info("PBCAST.handleUpMessage()", "receiver window for " + sender + " is " + win);
            }
            while ((tmpmsg = win.remove()) != null) {
                tmpmsg.removeHeader(this.getName());
                this.passUp(new Event(1, tmpmsg));
            }
            if (this.members.size() == 1 && (seqno = Math.max(seqno - (long)this.gc_lag, 0L)) > 0L) {
                if (Trace.trace) {
                    Trace.info("PBCAST.handleUpMessage()", "deleting messages < " + seqno + " from " + sender);
                }
                win.stable(seqno);
            }
        }
    }

    Digest getDigest() {
        Digest ret = new Digest(this.digest.size());
        Enumeration e = this.digest.keys();
        while (e.hasMoreElements()) {
            Address key = (Address)e.nextElement();
            NakReceiverWindow win = (NakReceiverWindow)this.digest.get(key);
            long lowest_seqno = win.getLowestSeen();
            long highest_seqno = win.getHighestSeen();
            ret.add(key, lowest_seqno, highest_seqno);
        }
        Trace.info("PBCAST.getDigest()", "digest is " + ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDigest(Digest d) {
        long seqno = 1L;
        Hashtable hashtable = this.digest;
        synchronized (hashtable) {
            Enumeration e = this.digest.elements();
            while (e.hasMoreElements()) {
                NakReceiverWindow win = (NakReceiverWindow)e.nextElement();
                win.reset();
            }
            this.digest.clear();
            for (int i = 0; i < d.size(); ++i) {
                Address sender = d.senderAt(i);
                seqno = d.highSeqnoAt(i);
                if (sender == null) {
                    Trace.error("PBCAST.setDigest()", "cannot set item because sender is null");
                    continue;
                }
                this.digest.put(sender, new NakReceiverWindow(sender, seqno + 1L));
            }
        }
    }

    String printDigest() {
        StringBuffer sb = new StringBuffer();
        Enumeration e = this.digest.keys();
        while (e.hasMoreElements()) {
            Address key = (Address)e.nextElement();
            NakReceiverWindow win = (NakReceiverWindow)this.digest.get(key);
            long highest_seqno = win.getHighestSeen();
            sb.append(key + ": " + highest_seqno + "\n");
        }
        return sb.toString();
    }

    String printIncomingMessageQueue() {
        StringBuffer sb = new StringBuffer();
        NakReceiverWindow win = (NakReceiverWindow)this.digest.get(this.local_addr);
        sb.append(win);
        return sb.toString();
    }

    void startGossipThread() {
        if (this.gossip_thread == null) {
            this.gossip_thread = new Thread(this);
            this.gossip_thread.setDaemon(true);
            this.gossip_thread.start();
        }
    }

    void stopGossipThread() {
        if (this.gossip_thread != null && this.gossip_thread.isAlive()) {
            Thread tmp = this.gossip_thread;
            this.gossip_thread = null;
            tmp.interrupt();
            Object var1_1 = null;
        }
        this.gossip_thread = null;
    }

    void startGossipHandler() {
        if (this.gossip_handler == null) {
            this.gossip_handler = new GossipHandler(this.gossip_queue);
            this.gossip_handler.start();
        }
    }

    void stopGossipHandler() {
        if (this.gossip_handler != null) {
            this.gossip_handler.stop();
            this.gossip_handler = null;
        }
    }

    void sendGossip() {
        Vector current_mbrs = (Vector)this.members.clone();
        Vector subset_mbrs = null;
        Gossip gossip = null;
        if (this.local_addr != null) {
            current_mbrs.remove(this.local_addr);
        }
        if (this.mcast_gossip) {
            gossip = new Gossip(this.local_addr, this.gossip_round, this.getDigest().copy(), null);
            for (int i = 0; i < current_mbrs.size(); ++i) {
                gossip.addToSeenList((Address)current_mbrs.elementAt(i));
            }
            PbcastHeader hdr = new PbcastHeader(gossip, 1);
            Message msg = new Message();
            msg.putHeader(this.getName(), hdr);
            if (Trace.trace) {
                Trace.info("PBCAST.sendGossip()", "(from " + this.local_addr + ") multicasting gossip " + gossip.shortForm() + " to all members");
            }
            this.passDown(new Event(1, msg));
        } else {
            subset_mbrs = Util.pickSubset(current_mbrs, this.subset);
            for (int i = 0; i < subset_mbrs.size(); ++i) {
                gossip = new Gossip(this.local_addr, this.gossip_round, this.getDigest().copy(), (Vector)current_mbrs.clone());
                gossip.addToSeenList(this.local_addr);
                PbcastHeader hdr = new PbcastHeader(gossip, 1);
                Address dest = (Address)subset_mbrs.elementAt(i);
                Message msg = new Message(dest, null, null);
                msg.putHeader(this.getName(), hdr);
                if (Trace.trace) {
                    Trace.info("PBCAST.sendGossip()", "(from " + this.local_addr + ") sending gossip " + gossip.shortForm() + " to " + subset_mbrs);
                }
                this.passDown(new Event(1, msg));
            }
        }
        ++this.gossip_round;
    }

    void handleGossip(Gossip gossip) {
        Message msg;
        PbcastHeader hdr;
        int i;
        long my_low = 0L;
        long my_high = 0L;
        Hashtable<Address, List> ht = null;
        Address sender = null;
        if (Trace.trace) {
            Trace.info("PBCAST.handleGossip()", "(from " + this.local_addr + ") received gossip " + gossip.shortForm() + " from " + gossip.sender);
        }
        if (gossip == null || gossip.digest == null) {
            Trace.warn("PBCAST.handleGossip()", "gossip is null or digest is null");
            return;
        }
        if (gossip.sender == null) {
            Trace.error("PBCAST.handleGossip()", "sender of gossip is null; don't know where to send XMIT_REQ to. Discarding gossip");
            return;
        }
        if (!this.members.contains(gossip.sender)) {
            Trace.warn("PBCAST.handleGossip()", "sender " + gossip.sender + " is not a member. Gossip will not be processed");
            if (this.shun) {
                this.shunInvalidGossiper(gossip.sender);
            }
            return;
        }
        while (this.gossip_list.size() >= this.max_gossip_cache) {
            this.gossip_list.removeFromHead();
        }
        if (this.gossip_list.contains(gossip)) {
            return;
        }
        this.gossip_list.add(gossip.copy());
        this.seen_list = gossip.getSeenList();
        if (this.seen_list.size() > 0) {
            this.passDown(new Event(50, this.seen_list.clone()));
        }
        Digest their_digest = gossip.digest;
        for (i = 0; i < their_digest.size(); ++i) {
            List missing_msgs;
            sender = their_digest.senderAt(i);
            long their_low = their_digest.lowSeqnoAt(i);
            long their_high = their_digest.highSeqnoAt(i);
            if (their_low == 0L && their_high == 0L) continue;
            NakReceiverWindow win = (NakReceiverWindow)this.digest.get(sender);
            if (win == null) {
                if (!Trace.trace) continue;
                Trace.warn("PBCAST.handleGossip()", "sender " + sender + " not found, skipping...");
                continue;
            }
            my_low = win.getLowestSeen();
            my_high = win.getHighestSeen();
            if (my_high >= their_high || my_low + 1L < their_low || (missing_msgs = win.getMissingMessages(my_high, their_high)) == null) continue;
            if (Trace.trace) {
                Trace.info("PBCAST.sendXmitReq()", "asking " + gossip.sender + " for retransmission of " + sender + ", missing messages: " + missing_msgs + "\nwin for " + sender + ":\n" + win + "\n");
            }
            if (ht == null) {
                ht = new Hashtable<Address, List>();
            }
            ht.put(sender, missing_msgs);
        }
        if (ht != null && ht.size() != 0) {
            hdr = new PbcastHeader(2);
            hdr.xmit_reqs = ht;
            if (Trace.trace) {
                Trace.info("PBCAST.handleGossip()", "sending XMIT_REQ to " + gossip.sender);
            }
            msg = new Message(gossip.sender, null, null);
            msg.putHeader(this.getName(), hdr);
            this.passDown(new Event(1, msg));
        }
        gossip.removeFromNotSeenList(this.local_addr);
        if (gossip.sizeOfNotSeenList() == 0) {
            this.garbageCollect(gossip.digest);
            return;
        }
        Vector new_dests = Util.pickSubset(gossip.getNotSeenList(), this.subset);
        if (Trace.trace) {
            Trace.info("PBCAST.handleGossip()", "(from " + this.local_addr + ") forwarding gossip " + gossip.shortForm() + " to " + new_dests);
        }
        gossip.addToSeenList(this.local_addr);
        for (i = 0; i < new_dests.size(); ++i) {
            Address dest = (Address)new_dests.elementAt(i);
            msg = new Message(dest, null, null);
            hdr = new PbcastHeader(gossip.copy(), 1);
            msg.putHeader(this.getName(), hdr);
            this.passDown(new Event(1, msg));
        }
    }

    void handleXmitRequest(Address requester, Hashtable xmit_reqs) {
        if (requester == null) {
            Trace.error("PBCAST.handleXmitRequest()", "requester is null");
            return;
        }
        if (Trace.trace) {
            Trace.info("PBCAST.handleXmitRequest()", "retransmission requests are " + this.printXmitReqs(xmit_reqs));
        }
        Enumeration e = xmit_reqs.keys();
        while (e.hasMoreElements()) {
            Message msg;
            Address sender = (Address)e.nextElement();
            NakReceiverWindow win = (NakReceiverWindow)this.digest.get(sender);
            if (win == null) {
                Trace.warn("PBCAST.handleXmitRequest()", "sender " + sender + " not found in my digest; skipping retransmit request !");
                continue;
            }
            List missing_msgs = (List)xmit_reqs.get(sender);
            List msgs = win.getMessagesInList(missing_msgs);
            List xmit_msgs = new List();
            Enumeration en = msgs.elements();
            while (en.hasMoreElements()) {
                msg = ((Message)en.nextElement()).copy();
                xmit_msgs.add(msg);
            }
            msg = new Message(requester, null, xmit_msgs);
            msg.putHeader(this.getName(), new PbcastHeader(3));
            this.passDown(new Event(1, msg));
        }
    }

    void handleXmitRsp(List xmit_msgs) {
        Enumeration e = xmit_msgs.elements();
        while (e.hasMoreElements()) {
            Message m = (Message)e.nextElement();
            PbcastHeader hdr = (PbcastHeader)m.removeHeader(this.getName());
            if (Trace.trace) {
                Trace.info("PBCAST.handleXmitRsp()", "received #" + hdr.seqno + ", type=" + PbcastHeader.type2String(hdr.type) + ", msg=" + m);
            }
            this.handleUpMessage(m, hdr);
        }
    }

    String printXmitReqs(Hashtable xmit_reqs) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        if (xmit_reqs == null) {
            return "<null>";
        }
        Enumeration e = xmit_reqs.keys();
        while (e.hasMoreElements()) {
            Address key = (Address)e.nextElement();
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(key + ": " + xmit_reqs.get(key));
        }
        return sb.toString();
    }

    void garbageCollect(Digest gc) {
        for (int i = 0; i < gc.size(); ++i) {
            Address sender = gc.senderAt(i);
            NakReceiverWindow win = (NakReceiverWindow)this.digest.get(sender);
            if (win == null) {
                Trace.debug("PBCAST.garbageCollect()", "sender " + sender + " not found in our message digest, skipping");
                continue;
            }
            long seqno = gc.highSeqnoAt(i);
            if ((seqno = Math.max(seqno - (long)this.gc_lag, 0L)) <= 0L) continue;
            if (Trace.trace) {
                Trace.info("PBCAST.garbageCollect()", "(from " + this.local_addr + ") GC: deleting messages < " + seqno + " from " + sender);
            }
            win.stable(seqno);
        }
    }

    void shunInvalidGossiper(Address invalid_gossiper) {
        int num_pings = 0;
        if (this.invalid_gossipers.containsKey(invalid_gossiper)) {
            num_pings = (Integer)this.invalid_gossipers.get(invalid_gossiper);
            if (num_pings >= this.max_invalid_gossips) {
                if (Trace.trace) {
                    Trace.info("PBCAST.shunInvalidGossiper()", "sender " + invalid_gossiper + " is not member of " + this.members + " ! Telling it to leave group");
                }
                Message shun_msg = new Message(invalid_gossiper, null, null);
                shun_msg.putHeader(this.getName(), new PbcastHeader(4));
                this.passDown(new Event(1, shun_msg));
                this.invalid_gossipers.remove(invalid_gossiper);
            } else {
                this.invalid_gossipers.put(invalid_gossiper, new Integer(++num_pings));
            }
        } else {
            this.invalid_gossipers.put(invalid_gossiper, new Integer(++num_pings));
        }
    }

    long computeGossipInterval(int num_mbrs, double desired_avg_gossip) {
        return this.getRandom((long)((double)num_mbrs * desired_avg_gossip * 2.0));
    }

    long getRandom(long range) {
        return (long)(Math.random() * (double)range % (double)range);
    }

    private class GossipHandler
    implements Runnable {
        Thread t = null;
        Queue gossip_queue;

        GossipHandler(Queue q) {
            this.gossip_queue = q;
        }

        void start() {
            if (this.t == null) {
                this.t = new Thread((Runnable)this, "PBCAST.GossipHandlerThread");
                this.t.setDaemon(true);
                this.t.start();
            }
        }

        void stop() {
            if (this.t != null && this.t.isAlive()) {
                Thread tmp = this.t;
                this.t = null;
                if (this.gossip_queue != null) {
                    this.gossip_queue.close(false);
                }
                tmp.interrupt();
            }
            this.t = null;
        }

        public void run() {
            block10: while (this.t != null && this.gossip_queue != null) {
                try {
                    GossipEntry entry = (GossipEntry)this.gossip_queue.remove();
                    PbcastHeader hdr = entry.hdr;
                    if (hdr == null) {
                        Trace.error("PBCAST.GossipHandler.run()", "gossip entry has no PbcastHeader");
                        continue;
                    }
                    switch (hdr.type) {
                        case 1: {
                            PBCAST.this.handleGossip(hdr.gossip);
                            continue block10;
                        }
                        case 2: {
                            if (hdr.xmit_reqs == null) {
                                Trace.warn("PBCAST.GossipHandler.run(MSG.XMIT_REQ)", "request is null !");
                                continue block10;
                            }
                            PBCAST.this.handleXmitRequest(entry.sender, hdr.xmit_reqs);
                            continue block10;
                        }
                        case 3: {
                            List xmit_msgs;
                            byte[] data = entry.data;
                            if (data == null) {
                                Trace.warn("PBCAST.GossipHandler.run(XMIT_RSP)", "buffer is null (no xmitted msgs)");
                                continue block10;
                            }
                            try {
                                xmit_msgs = (List)Util.objectFromByteBuffer(data);
                            }
                            catch (Exception ex) {
                                Trace.error("PBCAST.GossipHandler.run(XMIT_RSP)", ex.getMessage());
                                continue block10;
                            }
                            PBCAST.this.handleXmitRsp(xmit_msgs);
                            continue block10;
                        }
                        case 4: {
                            if (!PBCAST.this.shun) continue block10;
                            Trace.info("PBCAST.GossipHandler.run(NOT_MEMBER)", "I am being shunned. Will leave and re-join");
                            PBCAST.this.passUp(new Event(46));
                            continue block10;
                        }
                    }
                    Trace.error("PBCAST.GossipHandler.run(MSG)", "type (" + hdr.type + ") of PbcastHeader not known !");
                    return;
                }
                catch (QueueClosedException closed) {
                    break;
                }
            }
        }
    }

    private static class GossipEntry {
        PbcastHeader hdr = null;
        Address sender = null;
        byte[] data = null;

        GossipEntry(PbcastHeader hdr, Address sender, byte[] data) {
            this.hdr = hdr;
            this.sender = sender;
            this.data = data;
        }

        public String toString() {
            return "hdr=" + this.hdr + ", sender=" + this.sender + ", data=" + this.data;
        }
    }
}

