/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.server.admin.ejb;

import com.funambol.framework.config.ConfigClassLoader;
import com.funambol.framework.config.Configuration;
import com.funambol.framework.config.ConfigurationConstants;
import com.funambol.framework.config.ConfigurationException;
import com.funambol.framework.engine.source.SyncSource;
import com.funambol.framework.engine.source.SyncSourceException;
import com.funambol.framework.security.Sync4jPrincipal;
import com.funambol.framework.server.Sync4jConnector;
import com.funambol.framework.server.Sync4jDevice;
import com.funambol.framework.server.Sync4jModule;
import com.funambol.framework.server.Sync4jSourceType;
import com.funambol.framework.server.SyncUser;
import com.funambol.framework.server.error.ServerException;
import com.funambol.framework.server.store.Clause;
import com.funambol.framework.server.store.ConfigPersistentStoreException;
import com.funambol.framework.server.store.LogicalClause;
import com.funambol.framework.server.store.PersistentStore;
import com.funambol.framework.server.store.PersistentStoreException;
import com.funambol.framework.server.store.WhereClause;
import com.funambol.framework.tools.beans.BeanException;
import com.funambol.framework.tools.beans.BeanFactory;
import com.funambol.server.admin.AdminException;
import com.funambol.server.admin.DBUserManager;
import com.funambol.server.admin.ejb.AdminLocal;
import com.funambol.server.admin.ejb.AdminRemote;
import com.funambol.server.engine.Sync4jSource;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.ejb.Init;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.ejb.Remove;
import javax.ejb.Stateful;
import org.jboss.logging.Logger;

@Stateful
public class AdminBean
implements ConfigurationConstants,
AdminLocal,
AdminRemote {
    private static final String CONFIG_PATH_PREFIX = File.separator + "config";
    private static final String SERVER_CONFIG_FILE = "Funambol.properties";
    private static final String OPT_INSERT = "INSERT";
    private static final String OPT_UPDATE = "UPDATE";
    private static final String SEARCH_COUNT_DEVICES = "SCD";
    private static final String SEARCH_COUNT_PRINCIPALS = "SCP";
    private static final String PROPERTY_CONFIG_PATH = "funambol.dm.home";
    private static final String ROLE_SPECIAL = "special_sync_admin";
    private static final transient Logger log = Logger.getLogger((String)AdminBean.class.getName());
    private Configuration config = null;
    private PersistentStore ps = null;
    private DBUserManager dbUserManager = null;
    private URL configPath = null;

    @Init
    public void init() {
    }

    @Override
    @PostConstruct
    public void initBussiness() throws ServerException {
        this.loadConfiguration();
        HashMap<String, ClassLoader> psConfig = new HashMap<String, ClassLoader>(1);
        psConfig.put("class-loader", this.config.getClassLoader());
        this.ps = (PersistentStore)this.config.getBeanInstance("engine.store");
        try {
            this.ps.configure(psConfig);
        }
        catch (ConfigPersistentStoreException e) {
            if (log.isEnabled(Logger.Level.FATAL)) {
                log.fatal((Object)("Error configuring the persistent store: " + e.getMessage()));
            }
            log.debug((Object)"<init>", (Throwable)e);
            String msg = "Error " + ((Object)((Object)e)).getClass().getName() + " creating the AdminBean: " + e.getMessage();
            throw new ServerException(msg, (Throwable)e);
        }
        this.dbUserManager = (DBUserManager)this.config.getBeanInstance("user.manager");
    }

    @Override
    public Configuration getConfig() {
        return this.config;
    }

    @Override
    @Remove
    public void remove() {
    }

    @PostActivate
    public void postActivate() {
    }

    @PrePassivate
    public void prePassivate() {
    }

    @Override
    public String[] getRoles() throws ServerException, AdminException {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"AdminBean method getRoles");
        }
        String[] roles = null;
        try {
            roles = this.dbUserManager.getRoles();
            if (roles != null) {
                ArrayList<String> lst = new ArrayList<String>();
                for (String role : roles) {
                    if (role.startsWith(ROLE_SPECIAL)) continue;
                    lst.add(role);
                }
                roles = lst.toArray(new String[0]);
            }
        }
        catch (PersistentStoreException e) {
            String msg = "Error reading roles: " + e.getMessage();
            if (log.isEnabled(Logger.Level.FATAL)) {
                log.fatal((Object)msg);
            }
            log.debug((Object)"getRoles", (Throwable)e);
            throw new ServerException(msg, (Throwable)e);
        }
        return roles;
    }

    @Override
    public SyncUser[] getUsers(Clause clause) throws ServerException, AdminException {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"AdminBean method getUsers");
        }
        SyncUser[] users = null;
        try {
            users = this.dbUserManager.getUsers(clause);
            for (int i = 0; users != null && i < users.length; ++i) {
                this.dbUserManager.getUserRoles(users[i]);
            }
        }
        catch (PersistentStoreException e) {
            String msg = "Error reading Users: " + e.getMessage();
            if (log.isEnabled(Logger.Level.FATAL)) {
                log.fatal((Object)msg);
            }
            log.debug((Object)"getUsers", (Throwable)e);
            throw new ServerException(msg, (Throwable)e);
        }
        return users;
    }

    @Override
    public void insertUser(SyncUser user) throws ServerException, AdminException {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"AdminBean method insertUser");
        }
        try {
            this.dbUserManager.insertUser(user);
        }
        catch (PersistentStoreException e) {
            String msg = "Error inserting User: " + e.getMessage();
            if (log.isEnabled(Logger.Level.FATAL)) {
                log.fatal((Object)msg);
            }
            log.debug((Object)"insertUser", (Throwable)e);
            throw new ServerException(msg, (Throwable)e);
        }
    }

    @Override
    public void setUser(SyncUser user) throws ServerException, AdminException {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"AdminBean method setUser");
        }
        try {
            this.dbUserManager.setUser(user);
        }
        catch (PersistentStoreException e) {
            String msg = "Error updating User: " + e.getMessage();
            if (log.isEnabled(Logger.Level.FATAL)) {
                log.fatal((Object)msg);
            }
            log.debug((Object)"setUser", (Throwable)e);
            throw new ServerException(msg, (Throwable)e);
        }
    }

    @Override
    public void deleteUser(String userName) throws ServerException, AdminException {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"AdminBean method deleteUser");
        }
        try {
            SyncUser user = new SyncUser(userName, null, null, null, null, null);
            this.dbUserManager.deleteUser(user);
        }
        catch (PersistentStoreException e) {
            String msg = "Error deleting User: " + e.getMessage();
            if (log.isEnabled(Logger.Level.FATAL)) {
                log.fatal((Object)msg);
            }
            log.debug((Object)"deleteUser", (Throwable)e);
            throw new ServerException(msg, (Throwable)e);
        }
    }

    @Override
    public void importUser(SyncUser user) throws ServerException, AdminException {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"AdminBean method importUser");
        }
        throw new AdminException("Not implemented yet");
    }

    @Override
    public int countUsers(Clause clause) throws ServerException, AdminException {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"AdminBean method countUsers");
        }
        int n = 0;
        try {
            n = this.dbUserManager.countUsers(clause);
        }
        catch (PersistentStoreException e) {
            String msg = "Error counting users: " + e.getMessage();
            if (log.isEnabled(Logger.Level.FATAL)) {
                log.fatal((Object)msg);
            }
            log.debug((Object)"countUsers", (Throwable)e);
            throw new ServerException(msg, (Throwable)e);
        }
        return n;
    }

    @Override
    public Sync4jDevice[] getDevices(Clause clauses) throws ServerException, AdminException {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"AdminBean method getDevices");
        }
        Sync4jDevice[] devices = null;
        try {
            devices = (Sync4jDevice[])this.ps.read((Object)new Sync4jDevice(), clauses);
        }
        catch (PersistentStoreException e) {
            String msg = "Error reading devices: " + e.getMessage();
            if (log.isEnabled(Logger.Level.FATAL)) {
                log.fatal((Object)msg);
            }
            log.debug((Object)"getDevices", (Throwable)e);
            throw new ServerException(msg, (Throwable)e);
        }
        return devices;
    }

    @Override
    public String insertDevice(Sync4jDevice d) throws ServerException, AdminException {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"AdminBean method insertDevice");
        }
        try {
            this.ps.store((Object)d);
        }
        catch (PersistentStoreException e) {
            String msg = "Error adding device: " + e.getMessage();
            if (log.isEnabled(Logger.Level.FATAL)) {
                log.fatal((Object)msg);
            }
            log.debug((Object)"insertDevice", (Throwable)e);
            throw new ServerException(msg, (Throwable)e);
        }
        return d.getDeviceId();
    }

    @Override
    public void setDevice(Sync4jDevice d) throws ServerException, AdminException {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"AdminBean method setDevice");
        }
        try {
            this.ps.store((Object)d);
        }
        catch (PersistentStoreException e) {
            String msg = "Error updating device: " + e.getMessage();
            if (log.isEnabled(Logger.Level.FATAL)) {
                log.fatal((Object)msg);
            }
            log.debug((Object)"setDevice", (Throwable)e);
            throw new ServerException(msg, (Throwable)e);
        }
    }

    @Override
    public void deleteDevice(String deviceId) throws ServerException, AdminException {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"AdminBean method deleteDevice");
        }
        try {
            Sync4jDevice sd = new Sync4jDevice(deviceId, null, null);
            this.ps.delete((Object)sd);
        }
        catch (PersistentStoreException e) {
            String msg = "Error deleting device: " + e.getMessage();
            if (log.isEnabled(Logger.Level.FATAL)) {
                log.fatal((Object)msg);
            }
            log.debug((Object)"deleteDevice", (Throwable)e);
            throw new ServerException(msg, (Throwable)e);
        }
    }

    @Override
    public int countDevices(Clause clauses) throws ServerException, AdminException {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"AdminBean method countDevices");
        }
        int n = 0;
        try {
            String[] obj = (String[])this.ps.read((Object)SEARCH_COUNT_DEVICES, clauses);
            n = Integer.parseInt(obj[0]);
        }
        catch (PersistentStoreException e) {
            String msg = "Error counting devices: " + e.getMessage();
            if (log.isEnabled(Logger.Level.FATAL)) {
                log.fatal((Object)msg);
            }
            log.debug((Object)"countDevices", (Throwable)e);
            throw new ServerException(msg, (Throwable)e);
        }
        return n;
    }

    @Override
    public Sync4jPrincipal[] getPrincipals(Clause clauses) throws ServerException, AdminException {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"AdminBean method getPrincipals");
        }
        Sync4jPrincipal[] principals = null;
        try {
            principals = (Sync4jPrincipal[])this.ps.read((Object)new Sync4jPrincipal(null, null, null), clauses);
        }
        catch (PersistentStoreException e) {
            String msg = "Error reading principals: " + e.getMessage();
            if (log.isEnabled(Logger.Level.FATAL)) {
                log.fatal((Object)msg);
            }
            log.debug((Object)"getPrincipals", (Throwable)e);
            throw new ServerException(msg, (Throwable)e);
        }
        return principals;
    }

    @Override
    public String insertPrincipal(Sync4jPrincipal p) throws ServerException, AdminException {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"AdminBean method insertPrincipal");
        }
        try {
            this.ps.store((Object)p);
        }
        catch (PersistentStoreException e) {
            String msg = "Error adding rincipal: " + e.getMessage();
            if (log.isEnabled(Logger.Level.FATAL)) {
                log.fatal((Object)msg);
            }
            log.debug((Object)"insertPrincipal", (Throwable)e);
            throw new ServerException(msg, (Throwable)e);
        }
        return p.getId();
    }

    @Override
    public void deletePrincipal(String principalId) throws ServerException, AdminException {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"AdminBean method deletePrincipal");
        }
        try {
            Sync4jPrincipal sp = new Sync4jPrincipal(principalId, null, null);
            this.ps.delete((Object)sp);
        }
        catch (PersistentStoreException e) {
            String msg = "Error deleting principal: " + e.getMessage();
            if (log.isEnabled(Logger.Level.FATAL)) {
                log.fatal((Object)msg);
            }
            log.debug((Object)"deletePrincipal", (Throwable)e);
            throw new ServerException(msg, (Throwable)e);
        }
    }

    @Override
    public int countPrincipals(Clause clauses) throws ServerException, AdminException {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"AdminBean method countPrincipals");
        }
        int n = 0;
        try {
            String[] obj = (String[])this.ps.read((Object)SEARCH_COUNT_PRINCIPALS, clauses);
            n = Integer.parseInt(obj[0]);
        }
        catch (PersistentStoreException e) {
            String msg = "Error counting principals: " + e.getMessage();
            if (log.isEnabled(Logger.Level.FATAL)) {
                log.fatal((Object)msg);
            }
            log.debug((Object)"countPrincipals", (Throwable)e);
            throw new ServerException(msg, (Throwable)e);
        }
        return n;
    }

    @Override
    public Sync4jModule[] getModulesName() throws ServerException, AdminException {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"AdminBean method getModulesName");
        }
        Sync4jModule[] module = null;
        try {
            module = (Sync4jModule[])this.ps.read(Sync4jModule.class);
        }
        catch (PersistentStoreException e) {
            String msg = "Error reading modules: " + e.getMessage();
            if (log.isEnabled(Logger.Level.TRACE)) {
                log.fatal((Object)msg);
            }
            log.debug((Object)"getPrincipals", (Throwable)e);
            throw new ServerException(msg, (Throwable)e);
        }
        return module;
    }

    @Override
    public Sync4jModule getModule(String moduleId) throws ServerException, AdminException {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"AdminBean method getModule");
        }
        Sync4jModule module = null;
        try {
            module = new Sync4jModule(moduleId, null, null);
            this.ps.read((Object)module);
            Sync4jConnector[] syncConnectors = module.getConnectors();
            for (int i = 0; syncConnectors != null && i < syncConnectors.length; ++i) {
                Sync4jConnector sc = syncConnectors[i];
                Sync4jSourceType[] syncSourceTypes = sc.getSourceTypes();
                for (int y = 0; syncSourceTypes != null && y < syncSourceTypes.length; ++y) {
                    Sync4jSource[] sync4jSources = (Sync4jSource[])this.ps.read((Object)syncSourceTypes[y], null);
                    ArrayList<SyncSource> syncSources = new ArrayList<SyncSource>();
                    ArrayList<SyncSourceException> syncSourcesFailed = new ArrayList<SyncSourceException>();
                    for (int z = 0; z < sync4jSources.length; ++z) {
                        try {
                            SyncSource syncSource = (SyncSource)BeanFactory.getNoInitBeanInstance((ClassLoader)this.config.getClassLoader(), (String)sync4jSources[z].getConfig());
                            syncSources.add(syncSource);
                            continue;
                        }
                        catch (BeanException e) {
                            Throwable t = e.getCause();
                            String msg = "Error creating SyncSource " + module.getModuleName() + "/" + sc.getConnectorName() + "/" + syncSourceTypes[y].getDescription() + "/" + sync4jSources[z].getUri();
                            if (t != null) {
                                msg = msg + ": " + t.getMessage();
                            }
                            log.debug((Object)"getModule", t);
                            syncSourcesFailed.add(new SyncSourceException(sync4jSources[z].getUri(), sync4jSources[z].getConfig(), t));
                        }
                    }
                    SyncSource[] syncSourcesOK = syncSources.toArray(new SyncSource[syncSources.size()]);
                    syncSourceTypes[y].setSyncSources(syncSourcesOK);
                    SyncSourceException[] syncSourcesNO = syncSourcesFailed.toArray(new SyncSourceException[syncSourcesFailed.size()]);
                    syncSourceTypes[y].setSyncSourcesFailed(syncSourcesNO);
                }
            }
        }
        catch (PersistentStoreException e) {
            String msg = "Error getting module: " + e.getMessage();
            if (log.isEnabled(Logger.Level.FATAL)) {
                log.fatal((Object)("Error getting Module: " + e.getMessage()));
            }
            log.debug((Object)"getModule", (Throwable)e);
            throw new ServerException(msg, (Throwable)e);
        }
        return module;
    }

    @Override
    public void insertModule(Sync4jModule module, byte[] filess4j) throws ServerException, AdminException {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"AdminBean method insertModule");
        }
        throw new AdminException("Not implemented yet");
    }

    @Override
    public void deleteModule(String moduleId) throws ServerException, AdminException {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"AdminBean method deleteModule");
        }
        throw new AdminException("Not implemented yet");
    }

    @Override
    public void insertSource(String moduleId, String connectorId, String sourceTypeId, SyncSource source) throws ServerException, AdminException {
        String msg;
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"AdminBean method insertSource");
        }
        String uri = source.getSourceURI();
        String sourceName = source.getName();
        String config2 = moduleId + File.separator + connectorId + File.separator + sourceTypeId;
        Sync4jSource s4j = new Sync4jSource(uri, config2 + File.separator + sourceName + ".xml", sourceTypeId, sourceName);
        Sync4jSource[] existSource = null;
        try {
            WhereClause[] wc = new WhereClause[2];
            String[] value = new String[]{uri};
            wc[0] = new WhereClause("uri", value, "EQ", false);
            value[0] = sourceName;
            wc[1] = new WhereClause("name", value, "EQ", false);
            LogicalClause lc = new LogicalClause("OR", (Clause[])wc);
            existSource = (Sync4jSource[])this.ps.read((Object)s4j, (Clause)lc);
        }
        catch (PersistentStoreException e) {
            String msg2 = "Error reading sources existing: " + e.getMessage();
            if (log.isEnabled(Logger.Level.FATAL)) {
                log.fatal((Object)msg2);
            }
            log.debug((Object)"insertSource", (Throwable)e);
            throw new ServerException(msg2, (Throwable)e);
        }
        if (existSource == null || existSource.length == 0) {
            try {
                this.ps.store(sourceTypeId, (Object)s4j, OPT_INSERT);
            }
            catch (PersistentStoreException e) {
                msg = "Error adding the SyncSource: " + e.getMessage();
                if (log.isEnabled(Logger.Level.FATAL)) {
                    log.fatal((Object)msg);
                }
                log.debug((Object)"insertSource", (Throwable)e);
                throw new ServerException(msg, (Throwable)e);
            }
        } else {
            String msg3 = "A SyncSource with URI " + uri + " or with Name " + sourceName + " is already present.";
            throw new AdminException(msg3);
        }
        try {
            String path = this.configPath + config2;
            if (path.startsWith("file:")) {
                path = path.substring(6);
            }
            File f = new File(path);
            f.mkdirs();
            XMLEncoder encoder = null;
            encoder = new XMLEncoder(new FileOutputStream(path + File.separator + sourceName + ".xml"));
            encoder.writeObject(source);
            encoder.flush();
            encoder.close();
        }
        catch (FileNotFoundException e) {
            msg = "Error storing the SyncSource on file system: " + e.getMessage();
            if (log.isEnabled(Logger.Level.FATAL)) {
                log.fatal((Object)msg);
            }
            log.debug((Object)"insertSource", (Throwable)e);
            throw new ServerException(msg, (Throwable)e);
        }
    }

    @Override
    public void setSource(String moduleId, String connectorId, String sourceTypeId, SyncSource source) throws ServerException, AdminException {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"AdminBean method setSource");
        }
        String uri = source.getSourceURI();
        String sourceName = source.getName();
        String config2 = moduleId + File.separator + connectorId + File.separator + sourceTypeId;
        Sync4jSource s4j = new Sync4jSource(uri, null, sourceTypeId, null);
        try {
            this.ps.read((Object)s4j);
        }
        catch (PersistentStoreException e) {
            String msg = "Error reading sources existing: " + e.getMessage();
            if (log.isEnabled(Logger.Level.FATAL)) {
                log.fatal((Object)msg);
            }
            log.debug((Object)"insertSource", (Throwable)e);
            throw new ServerException(msg, (Throwable)e);
        }
        s4j.setSourceName(sourceName);
        String nameFileXml = s4j.getConfig().substring(config2.length() + 1);
        try {
            this.ps.store(sourceTypeId, (Object)s4j, OPT_UPDATE);
        }
        catch (PersistentStoreException e) {
            String msg = "Error storing SyncSource: " + e.getMessage();
            if (log.isEnabled(Logger.Level.FATAL)) {
                log.fatal((Object)msg);
            }
            log.debug((Object)"insertSource", (Throwable)e);
            throw new ServerException(msg, (Throwable)e);
        }
        try {
            String path = this.configPath + config2;
            if (path.startsWith("file:")) {
                path = path.substring(6);
            }
            File f = new File(path);
            f.mkdirs();
            XMLEncoder encoder = null;
            encoder = new XMLEncoder(new FileOutputStream(path + File.separator + nameFileXml));
            encoder.writeObject(source);
            encoder.flush();
            encoder.close();
        }
        catch (FileNotFoundException e) {
            String msg = "Error storing SyncSource: " + e.getMessage();
            if (log.isEnabled(Logger.Level.FATAL)) {
                log.fatal((Object)msg);
            }
            log.debug((Object)"insertSource", (Throwable)e);
            throw new ServerException(msg, (Throwable)e);
        }
    }

    @Override
    public void deleteSource(String sourceUri) throws ServerException, AdminException {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"AdminBean method deleteSource");
        }
        Sync4jSource s4j = new Sync4jSource(sourceUri, null, null, null);
        try {
            this.ps.read((Object)s4j);
        }
        catch (PersistentStoreException e) {
            String msg = "Error reading source: " + e.getMessage();
            if (log.isEnabled(Logger.Level.FATAL)) {
                log.fatal((Object)msg);
            }
            log.debug((Object)"deleteSource", (Throwable)e);
            throw new ServerException(msg, (Throwable)e);
        }
        try {
            this.ps.delete((Object)s4j);
        }
        catch (PersistentStoreException e) {
            String msg = "Error deleting SyncSource: " + e.getMessage();
            if (log.isEnabled(Logger.Level.FATAL)) {
                log.fatal((Object)msg);
            }
            log.debug((Object)"deleteSource", (Throwable)e);
            throw new ServerException(msg, (Throwable)e);
        }
        String path = this.configPath + s4j.getConfig();
        if (path.startsWith("file:")) {
            path = path.substring(6);
        }
        File f = new File(path);
        f.delete();
    }

    private void loadConfiguration() throws ConfigurationException {
        this.config = Configuration.getConfiguration();
        String propertiesFile = null;
        try {
            this.configPath = this.fixURI(System.getProperty(PROPERTY_CONFIG_PATH, ".") + CONFIG_PATH_PREFIX);
            this.config.setClassLoader((ClassLoader)new ConfigClassLoader(new URL[]{this.configPath}, this.getClass().getClassLoader()));
            propertiesFile = this.configPath.toString() + File.separatorChar + SERVER_CONFIG_FILE;
            this.config.load(propertiesFile);
            if (log.isEnabled(Logger.Level.TRACE)) {
                log.trace((Object)("Configuration: " + this.config));
            }
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException("Error loading configuration from " + propertiesFile, (Throwable)e);
        }
    }

    private URL fixURI(String s) throws MalformedURLException {
        try {
            return new URL(s);
        }
        catch (MalformedURLException e) {
            try {
                return new File(new File(s).getCanonicalPath()).toURI().toURL();
            }
            catch (IOException e2) {
                throw new MalformedURLException("Unable to convert" + s + " to a URL");
            }
        }
    }
}

