/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.core;

import com.funambol.framework.core.Authentication;

public class HMACAuthentication
extends Authentication {
    private final String DEFAULT_ALGORITHM = "MD5";
    private String userMac;
    private String algorithm;
    private String calculatedMac;

    protected HMACAuthentication() {
    }

    public HMACAuthentication(String string) {
        super("syncml:auth-MAC", "b64", string);
    }

    public String getUserMac() {
        return this.userMac;
    }

    public void setUserMac(String string) {
        this.userMac = string;
    }

    public String getCalculatedMac() {
        return this.calculatedMac;
    }

    public void setCalculatedMac(String string) {
        this.calculatedMac = string;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public void setData(String string) {
        if (string == null) {
            throw new IllegalArgumentException("data cannot be null");
        }
        int n = string.indexOf("algorithm");
        int n2 = -1;
        if (n == -1) {
            this.algorithm = "MD5";
        } else {
            n2 = string.indexOf(",", n);
            this.algorithm = string.substring(n + 10, n2);
        }
        int n3 = string.indexOf("username", n2 + 1);
        if (n3 == -1) {
            throw new IllegalArgumentException("Username missing in hmac header");
        }
        int n4 = string.indexOf("\"", n3 + 10);
        if (n4 == -1) {
            throw new IllegalArgumentException("Unable to get username from hmac header [" + string + "]");
        }
        while (string.charAt(n4 - 1) == '\\') {
            n4 = string.indexOf("\"", n4 + 1);
        }
        if (n4 == -1) {
            throw new IllegalArgumentException("Unable to get username from hmac header [" + string + "]");
        }
        this.setUsername(string.substring(n3 + 10, n4));
        int n5 = string.indexOf("mac", n4);
        if (n5 == -1) {
            throw new IllegalArgumentException("Mac value missing in hmac header");
        }
        this.userMac = string.substring(n5 + 4);
    }
}

