/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.server.syncbean;

import com.funambol.framework.config.Configuration;
import com.funambol.framework.server.SyncResponse;
import com.funambol.framework.server.error.ServerException;
import com.funambol.server.admin.ejb.AdminLocal;
import com.funambol.server.engine.SyncAdapter;
import com.funambol.server.syncbean.SyncLocal;
import com.funambol.server.syncbean.SyncRemote;
import javax.ejb.Init;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.ejb.Remove;
import javax.ejb.Stateful;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.logging.Logger;

@Stateful
public class SyncBean
implements SyncLocal,
SyncRemote {
    private static final String ADMINEJB_JNDI_NAME = "java:module/AdminBean!com.funambol.server.admin.ejb.AdminLocal";
    private static final Logger log = Logger.getLogger((String)SyncBean.class.getName());
    private String sessionId = null;
    private SyncAdapter syncAdapter = null;

    @Init
    public void init() {
    }

    @Override
    public void initBussiness(String sessionId) throws ServerException {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"initBussiness(sessionId) is called");
        }
        try {
            this.syncAdapter = new SyncAdapter(this.loadConfiguration());
            this.syncAdapter.setSessionId(sessionId);
            this.sessionId = sessionId;
        }
        catch (Exception e) {
            if (log.isEnabled(Logger.Level.FATAL)) {
                log.fatal((Object)("Error creating the SyncAdapter: " + e));
            }
            log.debug((Object)"init", (Throwable)e);
            String msg = "Error " + e.getClass().getName() + " creating the SyncBean: " + e.getMessage();
            throw new ServerException(msg, (Throwable)e);
        }
    }

    @Override
    public void initBussiness() throws ServerException {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"initBussiness() is called");
        }
        try {
            this.syncAdapter = new SyncAdapter(this.loadConfiguration());
        }
        catch (Exception e) {
            if (log.isEnabled(Logger.Level.FATAL)) {
                log.fatal((Object)("Error creating the SyncAdapter: " + e));
            }
            log.debug((Object)"init", (Throwable)e);
            String msg = "Error " + e.getClass().getName() + " creating the SyncBean: " + e.getMessage();
            throw new ServerException(msg, (Throwable)e);
        }
    }

    private Configuration loadConfiguration() throws ServerException {
        try {
            Configuration config = null;
            InitialContext ctx = new InitialContext();
            AdminLocal adminLocal = (AdminLocal)ctx.lookup(ADMINEJB_JNDI_NAME);
            config = adminLocal.getConfig();
            return config;
        }
        catch (NamingException e) {
            log.debug((Object)"loadConfiguration", (Throwable)e);
            throw new ServerException("Error " + e.getClass().getName() + " creating the AdminBean: " + e.getMessage());
        }
        catch (Exception e) {
            log.debug((Object)"loadConfiguration", (Throwable)e);
            throw new ServerException("Error " + e.getClass().getName() + " creating the AdminBean: " + e.getMessage());
        }
    }

    @Override
    @Remove
    public void remove() {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"remove() is called");
        }
        this.syncAdapter.endSync();
    }

    @PostActivate
    public void postActivate() {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"postActive() is called");
        }
    }

    @PrePassivate
    public void prePassivate() {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"prePassive is called");
        }
    }

    @Override
    public SyncResponse processMessage(byte[] msg, String mimeType, String hmacHeader) throws ServerException {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"processMessage() is called");
        }
        return this.syncAdapter.processMessage(msg, mimeType, hmacHeader);
    }

    @Override
    public SyncResponse processStatusCode(int statusCode, String info) {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"processStatus() is called");
        }
        return this.syncAdapter.processStatusCode(statusCode, info);
    }

    @Override
    public void setSessionId(String sessionId) {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"setSessionId(sessionId) is called");
        }
        this.sessionId = sessionId;
        this.syncAdapter.setSessionId(sessionId);
    }

    @Override
    public String getSessionId() {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"getSessionId() is called");
        }
        return this.sessionId;
    }
}

