/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.log.Trace;
import org.jgroups.stack.Protocol;

public class PARTITIONER
extends Protocol {
    Vector members = new Vector();
    Address local_addr = null;
    int my_partition = 1;

    public String getName() {
        return "PARTITIONER";
    }

    public boolean setProperties(Properties props) {
        if (props.size() > 0) {
            System.err.println("EXAMPLE.setProperties(): these properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void reset() {
    }

    public void up(Event evt) {
        PartitionerHeader partHead = null;
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                if (!Trace.trace) break;
                Trace.info("PARTITIONER.up()", "local address is " + this.local_addr);
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                partHead = (PartitionerHeader)msg.removeHeader(this.getName());
                if (partHead.type == 1) {
                    Integer num = (Integer)partHead.Destinations.get(this.local_addr);
                    if (num == null) {
                        return;
                    }
                    if (Trace.trace) {
                        Trace.info("PARTITIONER.up()", "new partition = " + num);
                    }
                    this.my_partition = num;
                    return;
                }
                if (partHead.type != 0 || partHead.partition == this.my_partition) break;
                return;
            }
        }
        this.passUp(evt);
    }

    public void down(Event evt) {
        switch (evt.getType()) {
            case 44: {
                if (Trace.trace) {
                    Trace.info("PARTITIONER.down()", "SET_PARTITIONS received, argument " + evt.getArg().toString());
                }
                Message msg = new Message(null, null, null);
                PartitionerHeader partHeader = new PartitionerHeader(1);
                partHeader.Destinations = (Hashtable)evt.getArg();
                msg.putHeader(this.getName(), partHeader);
                this.passDown(new Event(1, msg));
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                msg.putHeader(this.getName(), new PartitionerHeader(0, this.my_partition));
            }
        }
        this.passDown(evt);
    }

    public static class PartitionerHeader
    extends Header {
        static final int NORMAL = 0;
        static final int COMMAND = 1;
        int type = 0;
        int partition = 1;
        Hashtable Destinations = null;

        public PartitionerHeader() {
        }

        public PartitionerHeader(int type) {
            this.type = type;
        }

        public PartitionerHeader(int type, int partition) {
            this.type = type;
            this.partition = partition;
        }

        public String toString() {
            switch (this.type) {
                case 0: {
                    return "NORMAL ->partition :" + this.partition;
                }
                case 1: {
                    return "COMMAND ->hashtable :" + this.Destinations;
                }
            }
            return "<unknown>";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
            out.writeInt(this.partition);
            out.writeObject(this.Destinations);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
            this.partition = in.readInt();
            this.Destinations = (Hashtable)in.readObject();
        }
    }
}

