/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.server.store;

import com.funambol.framework.server.store.ConfigPersistentStoreException;
import com.funambol.framework.server.store.PersistentStoreException;
import java.util.Map;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;

public abstract class BasePersistentStore {
    public static final String CONFIG_JNDI_DATA_SOURCE_NAME = "jndi-data-source-name";
    protected static final transient Logger log = Logger.getLogger(BasePersistentStore.class.getName());
    protected String jndiDataSourceName = null;
    protected transient DataSource dataSource = null;

    public String getJndiDataSourceName() {
        return this.jndiDataSourceName;
    }

    public void setJndiDataSourceName(String jndiDataSourceName) throws PersistentStoreException {
        this.jndiDataSourceName = jndiDataSourceName;
        if (jndiDataSourceName == null) {
            this.dataSource = null;
        }
        try {
            InitialContext ctx = new InitialContext();
            this.dataSource = (DataSource)ctx.lookup(jndiDataSourceName);
        }
        catch (NamingException e) {
            throw new PersistentStoreException("Data source " + jndiDataSourceName + " not found", e);
        }
    }

    public void configure(Map config) throws ConfigPersistentStoreException {
        this.checkConfigParams(config);
        try {
            this.setJndiDataSourceName((String)config.get(CONFIG_JNDI_DATA_SOURCE_NAME));
        }
        catch (PersistentStoreException e) {
            throw new ConfigPersistentStoreException("Error creating the datasource: " + e.getMessage(), e);
        }
    }

    private void checkConfigParams(Map config) throws ConfigPersistentStoreException {
        StringBuffer sb = new StringBuffer();
        if (StringUtils.isEmpty((String)((String)config.get(CONFIG_JNDI_DATA_SOURCE_NAME)))) {
            sb.append(CONFIG_JNDI_DATA_SOURCE_NAME);
        }
    }
}

