/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.adapttcp;

import java.io.DataOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.jgroups.tests.adapttcp.Test;
import org.jgroups.util.Util;

public class SenderThread
extends Thread {
    private long msgs_burst;
    private long sleep_msec;
    private int num_bursts;
    private int msg_size;
    Logger log = Logger.getLogger(this.getClass());
    long log_interval = 1000L;
    boolean gnuplot_output = Boolean.getBoolean("gnuplot_output");
    List nodes;

    public SenderThread(List nodes, long mb, long st, int nb, int ms, long log_interval) {
        this.msgs_burst = mb;
        this.sleep_msec = st;
        this.num_bursts = nb;
        this.msg_size = ms;
        this.log_interval = log_interval;
        this.nodes = nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long total_msgs = 0L;
        ConnectionTable ct = null;
        System.out.println("Sender thread started...");
        try {
            ct = new ConnectionTable(this.nodes);
            byte[] msg = new byte[this.msg_size];
            for (int h = 0; h < this.msg_size; ++h) {
                msg[h] = (byte)h;
            }
            while (true) {
                try {
                    ct.init();
                }
                catch (Exception ex) {
                    Util.sleep(1000L);
                    continue;
                }
                break;
            }
            System.out.println("Everyone joined, ready to begin test...\ncluster: " + ct.toString());
            for (int i = 0; i < this.num_bursts; ++i) {
                int j = 0;
                while ((long)j < this.msgs_burst) {
                    ct.writeMessage(msg);
                    if (++total_msgs % 100L == 0L) {
                        System.out.println("++ sent " + total_msgs);
                    }
                    if (total_msgs % this.log_interval == 0L && !this.gnuplot_output) {
                        this.log.info((Object)this.dumpStats(total_msgs));
                    }
                    ++j;
                }
                SenderThread.sleep(this.sleep_msec);
            }
            System.out.println("Sent all bursts. Sender terminates.\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (ct != null) {
                ct.close();
            }
        }
    }

    String dumpStats(long sent_msgs) {
        StringBuffer sb = new StringBuffer();
        sb.append("\nmsgs_sent=").append(sent_msgs).append("\n");
        sb.append("free_mem=").append(Runtime.getRuntime().freeMemory());
        sb.append(" (total_mem=").append(Runtime.getRuntime().totalMemory()).append(")\n");
        return sb.toString();
    }

    class Connection {
        Socket sock;
        DataOutputStream out;

        Connection(InetAddress addr) throws Exception {
            this.sock = new Socket(addr, Test.srv_port);
            this.out = new DataOutputStream(this.sock.getOutputStream());
        }

        void writeMessage(byte[] msg) throws Exception {
            this.out.writeInt(msg.length);
            this.out.write(msg, 0, msg.length);
            this.out.flush();
        }

        void close() {
            try {
                this.sock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class ConnectionTable {
        List nodes;
        Connection[] connections;

        ConnectionTable(List nodes) throws Exception {
            this.nodes = nodes;
            this.connections = new Connection[nodes.size()];
        }

        void init() throws Exception {
            int i = 0;
            Iterator it = this.nodes.iterator();
            while (it.hasNext()) {
                InetAddress addr = (InetAddress)it.next();
                if (this.connections[i] == null) {
                    this.connections[i] = new Connection(addr);
                    System.out.println("-- connected to " + addr);
                    System.out.flush();
                }
                ++i;
            }
        }

        void writeMessage(byte[] msg) throws Exception {
            for (int i = 0; i < this.connections.length; ++i) {
                Connection c = this.connections[i];
                if (c == null) continue;
                c.writeMessage(msg);
            }
        }

        void close() {
            for (int i = 0; i < this.connections.length; ++i) {
                Connection c = this.connections[i];
                if (c == null) continue;
                c.close();
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            Iterator it = this.nodes.iterator();
            while (it.hasNext()) {
                InetAddress inetAddress = (InetAddress)it.next();
                sb.append(inetAddress).append(" ");
            }
            return sb.toString();
        }
    }
}

