/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Header;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.View;
import org.jgroups.blocks.PullPushAdapter;
import org.jgroups.log.Trace;
import org.jgroups.util.Util;

public class PerfTest
implements MessageListener,
MembershipListener {
    HashMap data = new HashMap();
    Vector mbrs = new Vector();
    String props = null;
    PullPushAdapter adapter = null;
    JChannel ch = null;
    boolean sender = true;
    long sleep_time = 10L;
    boolean busy_sleep = false;
    int num_bursts = 100;
    int num_msgs_per_burst = 10;
    int msg_size = 10000;
    byte[] buf = null;
    long sent_msgs = 0L;
    static final String HDRNAME = "PerfHeaderName";

    public PerfTest(String props, int num_bursts, int num_msgs_per_burst, int msg_size, long sleep_time, boolean sender) {
        this.props = props;
        this.num_bursts = num_bursts;
        this.num_msgs_per_burst = num_msgs_per_burst;
        this.msg_size = msg_size;
        this.sleep_time = sleep_time;
        this.buf = new byte[msg_size];
        this.sender = sender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        try {
            this.ch = new JChannel(this.props);
            this.ch.connect("PerfTest-Group");
            this.adapter = new PullPushAdapter(this.ch, this, this);
            this.mainLoop();
            Object var2_1 = null;
            if (this.ch != null) {
                this.ch.close();
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.ch != null) {
                this.ch.close();
            }
            throw throwable;
        }
    }

    void mainLoop() throws Exception {
        boolean looping = true;
        while (looping) {
            int choice = this.choice();
            switch (choice) {
                case 113: 
                case 120: {
                    looping = false;
                    break;
                }
                case 115: {
                    MyHeader hdr = new MyHeader(2, this.num_bursts * this.num_msgs_per_burst);
                    Message start_msg = new Message(null, null, null);
                    start_msg.putHeader(HDRNAME, hdr);
                    this.adapter.send(start_msg);
                    break;
                }
                case 99: {
                    Message clear_msg = new Message();
                    clear_msg.putHeader(HDRNAME, new MyHeader(3, 0));
                    this.adapter.send(clear_msg);
                    break;
                }
                case 116: {
                    this.printStats();
                    break;
                }
                case 112: {
                    this.printParams();
                    break;
                }
                case 118: {
                    System.out.println("-- view: " + this.ch.getView());
                    break;
                }
                case 97: {
                    this.printStatsForAllSenders();
                }
            }
        }
    }

    private void printStatsForAllSenders() {
        long start_time = 0L;
        long stop_time = 0L;
        int num_msgs = 0;
        int num_senders = 0;
        Iterator it = this.data.values().iterator();
        while (it.hasNext()) {
            Entry entry = (Entry)it.next();
            if (entry.num_received <= 0) continue;
            num_msgs += entry.num_received;
            ++num_senders;
            start_time = start_time == 0L ? entry.start : Math.min(start_time, entry.start);
            if (stop_time == 0L) {
                stop_time = entry.stop;
                continue;
            }
            stop_time = Math.max(stop_time, entry.stop);
        }
        long total_time = stop_time - start_time;
        StringBuffer sb = new StringBuffer();
        sb.append("total number of messages sent by me: ").append(this.sent_msgs).append("\n");
        sb.append("total number of messages received: ").append(num_msgs).append("\n");
        sb.append("total number of senders: ").append(num_senders).append("\n");
        sb.append("total time: ").append(total_time).append(" ms\n");
        sb.append("msgs/sec: ").append((double)num_msgs / ((double)total_time / 1000.0)).append("\n");
        sb.append("throughput (kb/sec): ").append((double)(num_msgs * this.msg_size) / 1000.0 / ((double)total_time / 1000.0)).append("\n");
        System.out.println(sb.toString());
    }

    private void printParams() {
        System.out.println("num_bursts: " + this.num_bursts + "\n" + "num_msgs_per_burst: " + this.num_msgs_per_burst + "\n" + "msg_size: " + this.msg_size + "\n" + "sleep_time: " + this.sleep_time + "\n" + "sender: " + this.sender);
    }

    private void printStats() {
        Iterator it = this.data.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            System.out.println("stats for " + entry.getKey() + "");
            System.out.println(((Entry)entry.getValue()).printStats() + "\n");
        }
    }

    void sendMessages() {
        int seqno = 0;
        if (!this.sender) {
            System.out.println("-- I'm not a sender; will not send messages");
            return;
        }
        System.out.println("-- sending " + this.num_bursts * this.num_msgs_per_burst + " msgs");
        this.sent_msgs = 0L;
        try {
            long start = System.currentTimeMillis();
            for (int i = 0; i < this.num_bursts; ++i) {
                for (int j = 0; j < this.num_msgs_per_burst; ++j) {
                    MyHeader hdr = new MyHeader(1, seqno++);
                    Message msg = new Message(null, null, this.buf);
                    msg.putHeader(HDRNAME, hdr);
                    this.adapter.send(msg);
                    ++this.sent_msgs;
                    if (this.sent_msgs % 100L != 0L) continue;
                    System.out.println("++ sent " + this.sent_msgs);
                }
                Util.sleep(this.sleep_time);
            }
            long stop = System.currentTimeMillis();
            System.out.println("-- sent " + this.num_bursts * this.num_msgs_per_burst + " msgs (in " + (stop - start) + " ms)");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    int choice() throws Exception {
        System.out.println("s=send, c=clear, t=print stats, p=print parameters v=view, a=times for all messages, q=quit\nChoice: ");
        System.out.flush();
        System.in.skip(System.in.available());
        int c = System.in.read();
        System.out.flush();
        return c;
    }

    public void receive(Message msg) {
        Address sender = msg.getSrc();
        MyHeader hdr = (MyHeader)msg.removeHeader(HDRNAME);
        if (hdr == null) {
            System.err.println("-- error: header was null");
            return;
        }
        switch (hdr.type) {
            case 2: {
                this.updateTimestamp();
                new Thread(){

                    public void run() {
                        PerfTest.this.sendMessages();
                    }
                }.start();
                break;
            }
            case 1: {
                Entry entry = (Entry)this.data.get(sender);
                if (entry == null) {
                    System.err.println("-- received a message from " + sender + ", who is not in the list");
                    break;
                }
                entry.add(hdr.seqno);
                if (hdr.seqno % 100 == 0) {
                    System.out.println("-- received " + sender + ":" + hdr.seqno);
                }
                if (entry.getNumReceived() < this.num_bursts * this.num_msgs_per_burst || !entry.done()) break;
                System.out.println("*--* " + sender + " DONE");
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                this.clear();
                break;
            }
        }
    }

    private void updateTimestamp() {
        Iterator it = this.data.values().iterator();
        while (it.hasNext()) {
            Entry entry = (Entry)it.next();
            entry.start = System.currentTimeMillis();
        }
    }

    void clear() {
        System.out.println("-- clearing the data");
        this.data.clear();
        for (int i = 0; i < this.mbrs.size(); ++i) {
            this.data.put(this.mbrs.elementAt(i), new Entry(this.num_bursts * this.num_msgs_per_burst));
        }
    }

    public byte[] getState() {
        return null;
    }

    public void setState(byte[] state) {
    }

    public void viewAccepted(View new_view) {
        System.out.println("-- new view: " + new_view.getMembers());
        this.mbrs.clear();
        this.mbrs.addAll(new_view.getMembers());
        this.clear();
    }

    public void suspect(Address suspected_mbr) {
    }

    public void block() {
    }

    public static void main(String[] args) {
        String props = null;
        int num_bursts = 100;
        int num_msgs_per_burst = 10;
        long sleep_time = 10L;
        int msg_size = 10000;
        boolean sender = true;
        Trace.init();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-props")) {
                props = args[++i];
                continue;
            }
            if (args[i].equals("-num_bursts")) {
                num_bursts = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-num_msgs_per_burst")) {
                num_msgs_per_burst = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-sleep_time")) {
                sleep_time = Long.parseLong(args[++i]);
                continue;
            }
            if (args[i].equals("-msg_size")) {
                msg_size = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-sender")) {
                sender = new Boolean(args[++i]);
                continue;
            }
            PerfTest.help();
            return;
        }
        try {
            PerfTest t = new PerfTest(props, num_bursts, num_msgs_per_burst, msg_size, sleep_time, sender);
            t.start();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    static void help() {
        System.out.println("PerfTest [-help] [-props <properties>] [-num_bursts <num>] [-num_msgs_per_burst <num>] [-sleep_time <number of msecs>] [-msg_size <bytes>] [-sender <true/false>]");
    }

    class Entry {
        long start = 0L;
        long stop = 0L;
        int num_received = 0;
        int[] seqnos = null;

        Entry(int num) {
            this.seqnos = new int[num];
            for (int i = 0; i < this.seqnos.length; ++i) {
                this.seqnos[i] = -1;
            }
            this.start = System.currentTimeMillis();
        }

        void add(int seqno) {
            if (this.seqnos != null) {
                this.seqnos[seqno] = seqno;
            }
            ++this.num_received;
            if (this.num_received >= this.seqnos.length && this.done()) {
                this.stop = System.currentTimeMillis();
            }
        }

        boolean done() {
            if (this.seqnos == null) {
                return false;
            }
            for (int i = 0; i < this.seqnos.length; ++i) {
                if (this.seqnos[i] >= 0) continue;
                return false;
            }
            return true;
        }

        int getNumReceived() {
            return this.num_received;
        }

        int getRealReceived() {
            int num = 0;
            if (this.seqnos == null) {
                return 0;
            }
            for (int i = 0; i < this.seqnos.length; ++i) {
                if (this.seqnos[i] <= -1) continue;
                ++num;
            }
            return num;
        }

        String printStats() {
            StringBuffer sb = new StringBuffer();
            sb.append("done=").append(this.done()).append("\n");
            sb.append("number of messages received: ").append(this.getRealReceived()).append("\n");
            sb.append("total time: ").append(this.stop - this.start).append(" ms\n");
            sb.append("msgs/sec: ").append((double)this.getRealReceived() / ((double)(this.stop - this.start) / 1000.0)).append("\n");
            sb.append("throughput (kb/sec): ").append((double)(this.getRealReceived() * PerfTest.this.msg_size) / 1000.0 / ((double)(this.stop - this.start) / 1000.0)).append("\n");
            return sb.toString();
        }
    }

    public static class MyHeader
    extends Header {
        public static final int DATA = 1;
        public static final int START = 2;
        public static final int CLEAR = 3;
        public static final int DONE = 4;
        int type = 0;
        int seqno = -1;

        public MyHeader() {
        }

        public MyHeader(int type, int seqno) {
            this.type = type;
            this.seqno = seqno;
        }

        public long size() {
            return 16L;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            switch (this.type) {
                case 1: {
                    sb.append("DATA (seqno=").append(this.seqno).append(")");
                    break;
                }
                case 2: {
                    sb.append("START");
                    break;
                }
                case 3: {
                    sb.append("CLEAR");
                    break;
                }
                default: {
                    sb.append("<n/a>");
                }
            }
            return sb.toString();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
            out.writeInt(this.seqno);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
            this.seqno = in.readInt();
        }
    }
}

