/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.NakReceiverWindow;
import org.jgroups.stack.Retransmitter;
import org.jgroups.util.Util;

public class NakReceiverWindowStressTest
implements Retransmitter.RetransmitCommand {
    NakReceiverWindow win = null;
    Address sender = null;
    int num_msgs = 1000;
    int prev_value = 0;
    double discard_prob = 0.1;
    long start;
    long stop;
    boolean trace = false;
    boolean debug = false;

    public NakReceiverWindowStressTest(int num_msgs, double discard_prob, boolean trace, boolean debug) {
        this.num_msgs = num_msgs;
        this.discard_prob = discard_prob;
        this.trace = trace;
    }

    public void retransmit(long first_seqno, long last_seqno, Address sender) {
        for (long i = first_seqno; i <= last_seqno; ++i) {
            if (this.debug) {
                this.out("-- xmit: " + i);
            }
            this.win.add(i, new Message(null, sender, new Long(i)));
        }
    }

    public void start() {
        System.out.println("num_msgs=" + this.num_msgs + "\ndiscard_prob=" + this.discard_prob);
        this.sender = new IpAddress("localhost", 5555);
        this.win = new NakReceiverWindow(this.sender, this, 1L);
        this.start = System.currentTimeMillis();
        this.sendMessages(this.num_msgs);
    }

    void sendMessages(int num_msgs) {
        Message msg;
        for (long i = 1L; i <= (long)num_msgs; ++i) {
            if (Util.tossWeightedCoin(this.discard_prob) && i <= (long)num_msgs) {
                if (!this.debug) continue;
                this.out("-- discarding " + i);
                continue;
            }
            if (this.debug) {
                this.out("-- adding " + i);
            }
            this.win.add(i, new Message(null, null, new Long(i)));
            if (this.trace && i % 100L == 0L) {
                System.out.println("-- added " + i);
            }
            while ((msg = this.win.remove()) != null) {
                this.processMessage(msg);
            }
        }
        while (true) {
            if ((msg = this.win.remove()) != null) {
                this.processMessage(msg);
                continue;
            }
            Util.sleep(50L);
        }
    }

    void processMessage(Message msg) {
        long i = (Long)msg.getObject();
        if ((long)(this.prev_value + 1) != i) {
            System.err.println("** processMessage(): removed seqno (" + i + ") is not 1 greater than " + "previous value (" + this.prev_value + ")");
            System.exit(0);
        }
        ++this.prev_value;
        if (this.trace && i % 100L == 0L) {
            System.out.println("Removed " + i);
        }
        if (i == (long)this.num_msgs) {
            this.stop = System.currentTimeMillis();
            System.out.println("Inserting and removing " + this.num_msgs + " messages into NakReceiverWindow took " + (this.stop - this.start) + "ms");
            System.out.println("<enter> to terminate");
            try {
                System.in.read();
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
            System.exit(0);
        }
    }

    void out(String msg) {
        System.out.println(msg);
    }

    public static void main(String[] args) {
        int num_msgs = 1000;
        double discard_prob = 0.1;
        boolean trace = false;
        boolean debug = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-help")) {
                NakReceiverWindowStressTest.help();
                return;
            }
            if (args[i].equals("-num_msgs")) {
                num_msgs = new Integer(args[++i]);
                continue;
            }
            if (args[i].equals("-discard")) {
                discard_prob = new Double(args[++i]);
                continue;
            }
            if (args[i].equals("-trace")) {
                trace = true;
                continue;
            }
            if (!args[i].equals("-debug")) continue;
            debug = true;
        }
        NakReceiverWindowStressTest test = new NakReceiverWindowStressTest(num_msgs, discard_prob, trace, debug);
        test.start();
    }

    static void help() {
        System.out.println("NakReceiverWindowStressTest [-help] [-num_msgs <number>] [-discard <probability>] [-trace]");
    }
}

