/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.View;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.log.Trace;
import org.jgroups.util.Util;

public class DistributedTree
implements MessageListener,
MembershipListener,
Cloneable {
    Node root = null;
    Vector listeners = new Vector();
    Vector view_listeners = new Vector();
    Vector members = new Vector();
    Channel channel = null;
    RpcDispatcher disp = null;
    String groupname = "DistributedTreeGroup";
    String channel_properties = "UDP(mcast_addr=228.1.2.3;mcast_port=45566;ip_ttl=0):PING(timeout=5000;num_initial_members=6):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.STABLE(desired_avg_gossip=10000):pbcast.NAKACK(gc_lag=5;retransmit_timeout=3000;trace=true):UNICAST(timeout=5000):FRAG(down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=true):pbcast.STATE_TRANSFER(trace=true)";
    long state_timeout = 5000L;
    private transient boolean send_message = false;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$Serializable;

    public DistributedTree() {
    }

    public DistributedTree(String groupname, String channel_properties) {
        this.groupname = groupname;
        if (channel_properties != null) {
            this.channel_properties = channel_properties;
        }
    }

    public Object getLocalAddress() {
        return this.channel != null ? this.channel.getLocalAddress() : null;
    }

    public void start() throws Exception {
        this.start(8000L);
    }

    public void start(long timeout) throws Exception {
        if (this.channel != null) {
            return;
        }
        this.channel = new JChannel(this.channel_properties);
        this.disp = new RpcDispatcher(this.channel, (MessageListener)this, (MembershipListener)this, (Object)this);
        this.channel.connect(this.groupname);
        this.channel.setOpt(4, new Boolean(true));
        boolean rc = this.channel.getState(null, timeout);
        if (rc) {
            Trace.info("DistributedTree.start()", "state was retrieved successfully");
        } else {
            Trace.info("DistributedTree.start()", "state could not be retrieved (must be first member in group)");
        }
    }

    public void stop() {
        if (this.channel != null) {
            this.channel.close();
            this.disp.stop();
        }
        this.channel = null;
        this.disp = null;
    }

    public void addDistributedTreeListener(DistributedTreeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    public void removeDistributedTreeListener(DistributedTreeListener listener) {
        this.listeners.removeElement(listener);
    }

    public void addViewListener(ViewListener listener) {
        if (!this.view_listeners.contains(listener)) {
            this.view_listeners.addElement(listener);
        }
    }

    public void removeViewListener(ViewListener listener) {
        this.view_listeners.removeElement(listener);
    }

    public void add(String fqn) {
        if (this.send_message) {
            try {
                MethodCall call = new MethodCall("_add", new Object[]{fqn}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = DistributedTree.class$("java.lang.String")) : class$java$lang$String).getName()});
                this.disp.callRemoteMethods(null, call, 2, 0L);
            }
            catch (Exception ex) {
                Trace.error("DistributedTree.add()", "exception=" + ex);
            }
        } else {
            this._add(fqn);
        }
    }

    public void add(String fqn, Serializable element) {
        if (this.send_message) {
            try {
                MethodCall call = new MethodCall("_add", new Object[]{fqn, element}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = DistributedTree.class$("java.lang.String")) : class$java$lang$String).getName(), (class$java$io$Serializable == null ? (class$java$io$Serializable = DistributedTree.class$("java.io.Serializable")) : class$java$io$Serializable).getName()});
                this.disp.callRemoteMethods(null, call, 2, 0L);
            }
            catch (Exception ex) {
                Trace.error("DistributedTree.add()", "exception=" + ex);
            }
        } else {
            this._add(fqn, element);
        }
    }

    public void remove(String fqn) {
        if (this.send_message) {
            try {
                MethodCall call = new MethodCall("_remove", new Object[]{fqn}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = DistributedTree.class$("java.lang.String")) : class$java$lang$String).getName()});
                this.disp.callRemoteMethods(null, call, 2, 0L);
            }
            catch (Exception ex) {
                Trace.error("DistributedTree.remove()", "exception=" + ex);
            }
        } else {
            this._remove(fqn);
        }
    }

    public boolean exists(String fqn) {
        if (fqn == null) {
            return false;
        }
        return this.findNode(fqn) != null;
    }

    public Serializable get(String fqn) {
        Node n = null;
        if (fqn == null) {
            return null;
        }
        n = this.findNode(fqn);
        if (n != null) {
            return n.element;
        }
        return null;
    }

    public void set(String fqn, Serializable element) {
        if (this.send_message) {
            try {
                MethodCall call = new MethodCall("_set", new Object[]{fqn, element}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = DistributedTree.class$("java.lang.String")) : class$java$lang$String).getName(), (class$java$io$Serializable == null ? (class$java$io$Serializable = DistributedTree.class$("java.io.Serializable")) : class$java$io$Serializable).getName()});
                this.disp.callRemoteMethods(null, call, 2, 0L);
            }
            catch (Exception ex) {
                Trace.error("DistributedTree.set()", "exception=" + ex);
            }
        } else {
            this._set(fqn, element);
        }
    }

    public Vector getChildrenNames(String fqn) {
        Vector<String> ret = new Vector<String>();
        if (fqn == null) {
            return ret;
        }
        Node n = this.findNode(fqn);
        if (n == null || n.children == null) {
            return ret;
        }
        for (int i = 0; i < n.children.size(); ++i) {
            ret.addElement(((Node)n.children.elementAt((int)i)).name);
        }
        return ret;
    }

    public String print() {
        StringBuffer sb = new StringBuffer();
        int indent = 0;
        if (this.root == null) {
            return "/";
        }
        sb.append(this.root.print(indent));
        return sb.toString();
    }

    Vector getChildren(String fqn) {
        if (fqn == null) {
            return null;
        }
        Node n = this.findNode(fqn);
        if (n == null) {
            return null;
        }
        return n.children;
    }

    public String getGroupName() {
        return this.groupname;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public int getGroupMembersNumber() {
        return this.members.size();
    }

    public void _add(String fqn) {
        this._add(fqn, null);
    }

    public void _add(String fqn, Serializable element) {
        String tmp_fqn = "";
        if (this.root == null) {
            this.root = new Node("/", null);
            this.notifyNodeAdded("/", null);
        }
        if (fqn == null) {
            return;
        }
        Node curr = this.root;
        StringTokenizer tok = new StringTokenizer(fqn, "/");
        while (tok.hasMoreTokens()) {
            String child_name = tok.nextToken();
            tmp_fqn = tmp_fqn + "/" + child_name;
            Node n = curr.findChild(child_name);
            if (n == null) {
                n = new Node(child_name, null);
                curr.addChild(n);
                if (!tok.hasMoreTokens()) {
                    n.element = element;
                    this.notifyNodeAdded(tmp_fqn, element);
                    return;
                }
                this.notifyNodeAdded(tmp_fqn, null);
            }
            curr = n;
        }
        curr.element = element;
        this.notifyNodeModified(fqn, null, element);
    }

    public void _remove(String fqn) {
        Node n;
        String child_name = null;
        if (fqn == null || this.root == null) {
            return;
        }
        Node curr = this.root;
        StringTokenizer tok = new StringTokenizer(fqn, "/");
        while (tok.countTokens() > 1) {
            child_name = tok.nextToken();
            n = curr.findChild(child_name);
            if (n == null) {
                return;
            }
            curr = n;
        }
        try {
            child_name = tok.nextToken();
            if (child_name != null && (n = curr.removeChild(child_name)) != null) {
                this.notifyNodeRemoved(fqn);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public void _set(String fqn, Serializable element) {
        Serializable old_el = null;
        if (fqn == null || element == null) {
            return;
        }
        Node n = this.findNode(fqn);
        if (n == null) {
            Trace.error("DistributedTree._set()", "node " + fqn + " not found");
            return;
        }
        old_el = n.element;
        n.element = element;
        this.notifyNodeModified(fqn, old_el, element);
    }

    public void receive(Message msg) {
    }

    public byte[] getState() {
        Node copy = this.root != null ? this.root.copy() : null;
        try {
            return Util.objectToByteBuffer(copy);
        }
        catch (Throwable ex) {
            Trace.error("DistributedTree.getState()", "exception marshalling state: " + ex);
            return null;
        }
    }

    public void setState(byte[] data) {
        Object new_state;
        try {
            new_state = Util.objectFromByteBuffer(data);
        }
        catch (Throwable ex) {
            Trace.error("DistributedTree.setState()", "exception unmarshalling state: " + ex);
            return;
        }
        if (new_state == null) {
            return;
        }
        if (!(new_state instanceof Node)) {
            Trace.error("DistributedTree.setState()", "object is not of type 'Node'");
            return;
        }
        this.root = ((Node)new_state).copy();
    }

    public void viewAccepted(View new_view) {
        Vector new_mbrs = new_view.getMembers();
        if (new_mbrs != null) {
            this.sendViewChangeNotifications(new_mbrs, this.members);
            this.members.removeAllElements();
            for (int i = 0; i < new_mbrs.size(); ++i) {
                this.members.addElement(new_mbrs.elementAt(i));
            }
        }
        this.send_message = this.members.size() > 1;
    }

    public void suspect(Address suspected_mbr) {
    }

    public void block() {
    }

    void sendViewChangeNotifications(Vector new_mbrs, Vector old_mbrs) {
        Object mbr;
        int i;
        if (this.view_listeners.size() == 0 || old_mbrs == null || new_mbrs == null) {
            return;
        }
        Vector joined = new Vector();
        for (i = 0; i < new_mbrs.size(); ++i) {
            mbr = new_mbrs.elementAt(i);
            if (old_mbrs.contains(mbr)) continue;
            joined.addElement(mbr);
        }
        Vector left = new Vector();
        for (i = 0; i < old_mbrs.size(); ++i) {
            mbr = old_mbrs.elementAt(i);
            if (new_mbrs.contains(mbr)) continue;
            left.addElement(mbr);
        }
        this.notifyViewChange(joined, left);
    }

    Node findNode(String fqn) {
        Node curr = this.root;
        if (fqn == null || this.root == null) {
            return null;
        }
        if (fqn.equals("/") || fqn.equals("")) {
            return this.root;
        }
        StringTokenizer tok = new StringTokenizer(fqn, "/");
        while (tok.hasMoreTokens()) {
            String child_name = tok.nextToken();
            if ((curr = curr.findChild(child_name)) != null) continue;
            return null;
        }
        return curr;
    }

    void notifyNodeAdded(String fqn, Serializable element) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((DistributedTreeListener)this.listeners.elementAt(i)).nodeAdded(fqn, element);
        }
    }

    void notifyNodeRemoved(String fqn) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((DistributedTreeListener)this.listeners.elementAt(i)).nodeRemoved(fqn);
        }
    }

    void notifyNodeModified(String fqn, Serializable old_element, Serializable new_element) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((DistributedTreeListener)this.listeners.elementAt(i)).nodeModified(fqn, old_element, new_element);
        }
    }

    void notifyAllNodesCreated(Node curr, String tmp_fqn) {
        if (curr == null) {
            return;
        }
        if (curr.name == null) {
            Trace.error("DistributedTree.notifyAllNodesCreated()", "curr.name is null");
            return;
        }
        if (curr.children != null) {
            for (int i = 0; i < curr.children.size(); ++i) {
                Node n = (Node)curr.children.elementAt(i);
                System.out.println("*** nodeAdded(): tmp_fqn is " + tmp_fqn);
                this.notifyNodeAdded(tmp_fqn, n.element);
                this.notifyAllNodesCreated(n, tmp_fqn + "/" + n.name);
            }
        }
    }

    void notifyViewChange(Vector new_mbrs, Vector old_mbrs) {
        for (int i = 0; i < this.view_listeners.size(); ++i) {
            ((ViewListener)this.view_listeners.elementAt(i)).viewChange(new_mbrs, old_mbrs);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Node
    implements Serializable {
        String name = null;
        Vector children = null;
        Serializable element = null;

        Node() {
        }

        Node(String name, Serializable element) {
            this.name = name;
            this.element = element;
        }

        void addChild(String relative_name, Serializable element) {
            if (relative_name == null) {
                return;
            }
            if (this.children == null) {
                this.children = new Vector();
            } else if (!this.children.contains(relative_name)) {
                this.children.addElement(new Node(relative_name, element));
            }
        }

        void addChild(Node n) {
            if (n == null) {
                return;
            }
            if (this.children == null) {
                this.children = new Vector();
            }
            if (!this.children.contains(n)) {
                this.children.addElement(n);
            }
        }

        Node removeChild(String rel_name) {
            Node n = this.findChild(rel_name);
            if (n != null) {
                this.children.removeElement(n);
            }
            return n;
        }

        Node findChild(String relative_name) {
            if (this.children == null || relative_name == null) {
                return null;
            }
            for (int i = 0; i < this.children.size(); ++i) {
                Node child = (Node)this.children.elementAt(i);
                if (child.name == null) {
                    Trace.error("Node.findChild()", "child.name is null for " + relative_name);
                    continue;
                }
                if (!child.name.equals(relative_name)) continue;
                return child;
            }
            return null;
        }

        public boolean equals(Object other) {
            return other != null && ((Node)other).name != null && this.name != null && this.name.equals(((Node)other).name);
        }

        Node copy() {
            Node ret = new Node(this.name, this.element);
            if (this.children != null) {
                ret.children = (Vector)this.children.clone();
            }
            return ret;
        }

        String print(int indent) {
            int i;
            StringBuffer sb = new StringBuffer();
            boolean is_root = this.name != null && this.name.equals("/");
            for (i = 0; i < indent; ++i) {
                sb.append(" ");
            }
            if (!is_root) {
                if (this.name == null) {
                    sb.append("/<unnamed>");
                } else {
                    sb.append("/" + this.name);
                }
            }
            sb.append("\n");
            if (this.children != null) {
                indent = is_root ? 0 : (indent += 4);
                for (i = 0; i < this.children.size(); ++i) {
                    sb.append(((Node)this.children.elementAt(i)).print(indent));
                }
            }
            return sb.toString();
        }

        public String toString() {
            if (this.element != null) {
                return "[name: " + this.name + ", element: " + this.element + "]";
            }
            return "[name: " + this.name + "]";
        }
    }

    public static interface ViewListener {
        public void viewChange(Vector var1, Vector var2);
    }

    public static interface DistributedTreeListener {
        public void nodeAdded(String var1, Serializable var2);

        public void nodeRemoved(String var1);

        public void nodeModified(String var1, Serializable var2, Serializable var3);
    }
}

