/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.server.error;

import com.funambol.framework.core.StatusCode;
import com.funambol.framework.core.Sync4jException;

public class ServerException
extends Sync4jException {
    public static int UNKNOWN = -1;
    private int statusCode = UNKNOWN;

    public ServerException(String strMsg) {
        super(strMsg);
    }

    public ServerException(int statusCode, String strMsg) {
        this(statusCode, strMsg, null);
    }

    public ServerException(String strMsg, Throwable cause) {
        this(UNKNOWN, strMsg, cause);
    }

    public ServerException(int statusCode, String strMsg, Throwable cause) {
        super(strMsg, cause);
        this.statusCode = statusCode;
    }

    public ServerException(Throwable cause) {
        this(UNKNOWN, "", cause);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getSyncMLMessage() {
        int code = this.getStatusCode();
        String msg = StatusCode.getStatusDescription(code);
        return msg == null ? "" : msg;
    }

    @Override
    public String getMessage() {
        return this.statusCode + " " + this.getSyncMLMessage() + " - " + super.getMessage();
    }
}

