/*
 * Decompiled with CFR 0.152.
 */
package org.kxml.wap;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.kxml.Attribute;
import org.kxml.io.ParseException;
import org.kxml.parser.AbstractXmlParser;
import org.kxml.parser.ParseEvent;
import org.kxml.parser.StartTag;
import org.kxml.parser.Tag;
import org.kxml.wap.PublicIDEntry;
import org.kxml.wap.VersionMismatchException;
import org.kxml.wap.WapExtensionEvent;
import org.kxml.wap.WbxmlInitialiser;
import org.kxml.wap.WbxmlInitialiserFactory;

public class WbxmlParser
extends AbstractXmlParser {
    InputStream in;
    private HashMap otherAttrStartTables = new HashMap();
    private HashMap otherAttrValueTables = new HashMap();
    private HashMap otherTagTables = new HashMap();
    private String[] attrStartTable;
    private String[] attrValueTable;
    private String[] tagTable;
    private String stringTable;
    private int version;
    private int publicIdentifierId;
    private String publicIdentifier = null;
    private String charset;
    private StartTag current;
    private ParseEvent next;
    private boolean whitespace;
    private PublicIDEntry documentPubID = null;
    private PublicIDEntry currentPubID = null;
    private HashMap myPublicIDMap = null;
    private HashMap myPublicIDCodeMap = null;
    private HashMap myPublicIDIndexMap = null;

    public WbxmlParser(InputStream in) throws Exception {
        this(in, -1, null);
    }

    public WbxmlParser(InputStream in, int expectedVersion) throws Exception {
        this(in, expectedVersion, null);
    }

    public WbxmlParser(InputStream in, String charset) throws Exception {
        this(in, -1, charset);
    }

    public WbxmlParser(InputStream in, int expectedVersion, String charset) throws Exception {
        int publicIdentifierOffset = -1;
        this.in = in;
        this.version = this.readByte();
        if (expectedVersion >= 0 && this.version != expectedVersion) {
            throw new VersionMismatchException();
        }
        this.publicIdentifierId = this.readInt();
        if (this.publicIdentifierId == 0) {
            publicIdentifierOffset = this.readInt();
        }
        if (charset != null) {
            if (!Charset.isSupported(charset)) {
                throw new UnsupportedCharsetException(charset + " is not supported");
            }
            this.charset = charset;
            this.readInt();
        } else {
            switch (this.readInt()) {
                case 4: {
                    this.charset = "ISO-8859-1";
                    break;
                }
                default: {
                    this.charset = "UTF-8";
                }
            }
        }
        int strTabSize = this.readInt();
        StringBuffer buf = new StringBuffer(strTabSize);
        for (int i = 0; i < strTabSize; ++i) {
            buf.append((char)this.readByte());
        }
        this.stringTable = buf.toString();
        WbxmlInitialiser initialiser = null;
        if (this.publicIdentifierId != 0) {
            initialiser = WbxmlInitialiserFactory.getInitialiserByPublicIdentifierCode(this.publicIdentifierId);
        } else if (publicIdentifierOffset >= 0) {
            this.extractInlinePublicID(publicIdentifierOffset);
            if (this.publicIdentifier != null) {
                initialiser = WbxmlInitialiserFactory.getInitialiserByPublicIdentifier(this.publicIdentifier);
            }
        }
        if (initialiser != null) {
            initialiser.initialise(this);
        }
        this.documentPubID = this.publicIdentifier == null ? this.getPublicIDEntryByCode(this.publicIdentifierId) : this.getPublicIDEntry(this.publicIdentifier);
    }

    private void extractInlinePublicID(int anOffset) {
        this.publicIdentifier = this.extractFromStrT(anOffset);
    }

    @Override
    public ParseEvent peek() throws IOException {
        if (this.next != null) {
            return this.next;
        }
        if (this.current != null && this.current.getDegenerated()) {
            this.next = new Tag(16, this.current, this.current.getNamespace(), this.current.getName());
            this.current = this.current.getParent();
            return this.next;
        }
        Object result = null;
        do {
            int id = this.in.read();
            switch (id) {
                case -1: {
                    if (this.current != null) {
                        throw new RuntimeException("unclosed elements: " + this.current);
                    }
                    this.next = new ParseEvent(8, null);
                    break;
                }
                case 0: {
                    int page = this.readByte();
                    this.switchPage(page);
                    break;
                }
                case 1: {
                    this.next = new Tag(16, this.current, this.current.getNamespace(), this.current.getName());
                    this.current = this.current.getParent();
                    break;
                }
                case 2: {
                    this.next = new ParseEvent(128, "" + (char)this.readInt());
                    break;
                }
                case 3: {
                    String s = this.readStrI();
                    this.next = new ParseEvent(this.whitespace ? 256 : 128, s);
                    break;
                }
                case 64: 
                case 65: 
                case 66: 
                case 128: 
                case 129: 
                case 130: 
                case 192: 
                case 193: 
                case 194: 
                case 195: {
                    this.next = this.parseWapExtension(id);
                    break;
                }
                case 67: {
                    throw new RuntimeException("PI curr. not supp.");
                }
                case 131: {
                    int pos = this.readInt();
                    int end = this.stringTable.indexOf(0, pos);
                    this.next = new ParseEvent(128, this.stringTable.substring(pos, end));
                    break;
                }
                default: {
                    this.next = this.parseElement(id);
                }
            }
        } while (this.next == null);
        return this.next;
    }

    @Override
    public ParseEvent read() throws IOException {
        if (this.next == null) {
            this.peek();
        }
        ParseEvent result = this.next;
        this.next = null;
        return result;
    }

    private void switchPage(int page) {
        Integer ipage = new Integer(page);
        this.attrStartTable = (String[])this.otherAttrStartTables.get(ipage);
        this.attrValueTable = (String[])this.otherAttrValueTables.get(ipage);
        this.tagTable = (String[])this.otherTagTables.get(ipage);
        this.currentPubID = this.getPublicIDEntryByIndex(page);
    }

    public ParseEvent parseWapExtension(int id) throws IOException {
        switch (id) {
            case 64: 
            case 65: 
            case 66: {
                return new WapExtensionEvent(id, (Object)this.readStrI());
            }
            case 128: 
            case 129: 
            case 130: {
                return new WapExtensionEvent(id, new Integer(this.readInt()));
            }
            case 192: 
            case 193: 
            case 194: {
                return new WapExtensionEvent(id, (Object)null);
            }
            case 195: {
                int len = this.readInt();
                byte[] buf = new byte[len];
                for (int i = 0; i < len; ++i) {
                    buf[i] = (byte)this.readByte();
                }
                return new WapExtensionEvent(id, buf);
            }
        }
        throw new IOException("illegal id!");
    }

    public List readAttr() throws IOException {
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        int id = this.readByte();
        while (id != 1) {
            StringBuffer value;
            if (id == 0) {
                int page = this.readByte();
                this.switchPage(page);
                id = this.readByte();
                continue;
            }
            String name = this.resolveId(this.attrStartTable, id, 5);
            int cut = name.indexOf(61);
            if (cut == -1) {
                value = new StringBuffer();
            } else {
                value = new StringBuffer(name.substring(cut + 1));
                name = name.substring(0, cut);
            }
            id = this.readByte();
            while (id > 128 || id == 2 || id == 0 || id == 3 || id == 131 || id >= 64 && id <= 66 || id >= 128 && id <= 130) {
                switch (id) {
                    case 0: {
                        int page = this.readByte();
                        this.switchPage(page);
                        id = this.readByte();
                        break;
                    }
                    case 2: {
                        value.append((char)this.readInt());
                        break;
                    }
                    case 3: {
                        value.append(this.readStrI());
                        break;
                    }
                    case 64: 
                    case 65: 
                    case 66: 
                    case 128: 
                    case 129: 
                    case 130: 
                    case 192: 
                    case 193: 
                    case 194: 
                    case 195: {
                        ParseEvent e = this.parseWapExtension(id);
                        if (e.getType() == 128 || e.getType() == 256) {
                            throw new RuntimeException("parse WapExtension must return Text Event in order to work inside Attributes!");
                        }
                        value.append(e.getText());
                        break;
                    }
                    case 131: {
                        value.append(this.readStrT());
                        break;
                    }
                    default: {
                        value.append(this.resolveId(this.attrValueTable, id, 0));
                    }
                }
                id = this.readByte();
            }
            result.add(new Attribute(null, name, value.toString()));
        }
        return result;
    }

    String resolveId(String[] tab, int id, int offset) throws IOException {
        int idx = (id & 0x7F) - offset;
        if (idx == -1) {
            return this.readStrT();
        }
        if (idx < 0 || tab == null || idx >= tab.length || tab[idx] == null) {
            throw new IOException("id " + id + " undef.");
        }
        return tab[idx];
    }

    StartTag parseElement(int id) throws IOException {
        String tag = this.resolveId(this.tagTable, id & 0x3F, 5);
        String ns = null;
        ArrayList<Attribute> attributes = null;
        if ((id & 0x80) != 0) {
            attributes = this.readAttr();
        }
        if (this.documentPubID != null && this.documentPubID != this.currentPubID) {
            if (this.currentPubID == null) {
                this.currentPubID = this.documentPubID;
            }
            ns = this.currentPubID.getNameSpace();
        }
        if (ns != null) {
            if (attributes == null) {
                attributes = new ArrayList<Attribute>();
            }
            int i = 0;
            Attribute attr = null;
            for (i = 0; i < attributes.size() && !(attr = (Attribute)attributes.get(i)).getName().equals("xmlns"); ++i) {
            }
            if (i < attributes.size()) {
                attributes.remove(i);
                attributes.add(i, new Attribute(null, "xmlns", ns));
            } else {
                attributes.add(0, new Attribute(null, "xmlns", ns));
            }
        }
        try {
            this.current = new StartTag(this.current, ns, tag, attributes, (id & 0x40) == 0, this.processNamespaces);
        }
        catch (Exception e) {
            throw new ParseException(null, e, -1, -1);
        }
        return this.current;
    }

    int readByte() throws IOException {
        int i = this.in.read();
        if (i == -1) {
            throw new IOException("Unexpected EOF");
        }
        return i;
    }

    int readInt() throws IOException {
        int i;
        int result = 0;
        do {
            i = this.readByte();
            result = result << 7 | i & 0x7F;
        } while ((i & 0x80) != 0);
        return result;
    }

    String readStrI() throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        boolean wsp = true;
        while (true) {
            int i;
            if ((i = this.in.read()) == -1) {
                throw new IOException("Unexpected EOF");
            }
            if (i == 0) break;
            if (i > 32) {
                wsp = false;
            }
            buf.write(i);
        }
        this.whitespace = wsp;
        return buf.toString(this.charset);
    }

    String readStrT() throws IOException {
        int pos = this.readInt();
        return this.extractFromStrT(pos);
    }

    private String extractFromStrT(int pos) {
        int end = this.stringTable.indexOf(0, pos);
        end = end < 0 ? this.stringTable.length() : end;
        return this.stringTable.substring(pos, end);
    }

    public void setTagTable(int page, String[] tagTable) {
        this.otherTagTables.put(new Integer(page), tagTable);
        if (page == 0) {
            this.tagTable = tagTable;
        }
    }

    public String getPublicIdentifier() {
        return this.publicIdentifier;
    }

    public void setAttrStartTable(int page, String[] attrStartTable) {
        this.otherAttrStartTables.put(new Integer(page), attrStartTable);
        if (page == 0) {
            this.attrStartTable = attrStartTable;
        }
    }

    public void setAttrValueTable(int page, String[] attrValueTable) {
        this.otherAttrValueTables.put(new Integer(page), attrValueTable);
        if (page == 0) {
            this.attrValueTable = attrValueTable;
        }
    }

    void addPublicIDEntry(PublicIDEntry anEntry) {
        if (this.myPublicIDMap == null) {
            this.myPublicIDMap = new HashMap();
        }
        if (this.myPublicIDCodeMap == null) {
            this.myPublicIDCodeMap = new HashMap();
        }
        if (this.myPublicIDIndexMap == null) {
            this.myPublicIDIndexMap = new HashMap();
        }
        if (anEntry.getPublicIdentifier() != null) {
            this.myPublicIDMap.put(anEntry.getPublicIdentifier().toUpperCase(), anEntry);
        }
        if (anEntry.getPublicIDCode() != null) {
            this.myPublicIDMap.put(anEntry.getPublicIDCode(), anEntry);
        }
        this.myPublicIDIndexMap.put(new Integer(anEntry.getStrTableIndex()), anEntry);
    }

    public PublicIDEntry getPublicIDEntry(String anIdentifier) {
        return (PublicIDEntry)this.myPublicIDMap.get(anIdentifier.toUpperCase());
    }

    public PublicIDEntry getPublicIDEntryByCode(int aCode) {
        if (this.myPublicIDCodeMap == null) {
            return null;
        }
        return (PublicIDEntry)this.myPublicIDCodeMap.get(new Integer(aCode));
    }

    public PublicIDEntry getPublicIDEntryByIndex(int anIndex) {
        if (this.myPublicIDIndexMap == null) {
            return null;
        }
        return (PublicIDEntry)this.myPublicIDIndexMap.get(new Integer(anIndex));
    }

    public String getCharSet() {
        return this.charset;
    }

    public int getPublicIdentifierId() {
        return this.publicIdentifierId;
    }
}

