/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.engine.dm;

import com.funambol.framework.core.AbstractCommand;
import com.funambol.framework.core.Add;
import com.funambol.framework.core.Alert;
import com.funambol.framework.core.Atomic;
import com.funambol.framework.core.CmdID;
import com.funambol.framework.core.ComplexData;
import com.funambol.framework.core.Constants;
import com.funambol.framework.core.Copy;
import com.funambol.framework.core.Delete;
import com.funambol.framework.core.Exec;
import com.funambol.framework.core.Get;
import com.funambol.framework.core.Item;
import com.funambol.framework.core.ItemizedCommand;
import com.funambol.framework.core.Meta;
import com.funambol.framework.core.Replace;
import com.funambol.framework.core.ResponseCommand;
import com.funambol.framework.core.Results;
import com.funambol.framework.core.Sequence;
import com.funambol.framework.core.Source;
import com.funambol.framework.core.Status;
import com.funambol.framework.core.Sync4jException;
import com.funambol.framework.core.Target;
import com.funambol.framework.core.TargetRef;
import com.funambol.framework.core.dm.ddf.MgmtTree;
import com.funambol.framework.core.dm.ddf.Node;
import com.funambol.framework.core.dm.ddf.RTProperties;
import com.funambol.framework.engine.dm.AddManagementOperation;
import com.funambol.framework.engine.dm.AtomicManagementOperation;
import com.funambol.framework.engine.dm.CopyManagementOperation;
import com.funambol.framework.engine.dm.DeleteManagementOperation;
import com.funambol.framework.engine.dm.ExecManagementOperation;
import com.funambol.framework.engine.dm.GetManagementOperation;
import com.funambol.framework.engine.dm.ManagementException;
import com.funambol.framework.engine.dm.ManagementOperation;
import com.funambol.framework.engine.dm.ManagementOperationResult;
import com.funambol.framework.engine.dm.ReplaceManagementOperation;
import com.funambol.framework.engine.dm.SequenceManagementOperation;
import com.funambol.framework.engine.dm.TreeNode;
import com.funambol.framework.engine.dm.UserAlertManagementOperation;
import com.funambol.framework.protocol.ProtocolException;
import com.funambol.framework.tools.Base64;
import com.funambol.framework.tools.CommandIdGenerator;
import com.funambol.framework.tools.IOTools;
import com.funambol.framework.tools.WBXMLTools;
import com.funambol.framework.tools.XMLTools;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;

public final class Util {
    private static final String MANAGEMENT_COMMANDS = ",Add,Alert,Copy,Delete,Exec,Get,Replace,Atomic,Sequence,";
    private static final String ALERT_OPTION_MINDT = "MINDT";
    private static final String ALERT_OPTION_MAXDT = "MAXDT";
    private static final String ALERT_OPTION_DR = "DR";
    private static final String ALERT_OPTION_MAXLEN = "MAXLEN";
    private static final String ALERT_OPTION_IT = "IT";
    private static final String ALERT_OPTION_ET = "ET";

    public static AbstractCommand[] managementOperations2commands(ManagementOperation[] operations, CommandIdGenerator idGenerator, String mimeType) {
        if (operations == null || operations.length == 0) {
            return new AbstractCommand[0];
        }
        AbstractCommand[] ret = new AbstractCommand[operations.length];
        for (int i = 0; i < operations.length; ++i) {
            ret[i] = Util.managementOperation2command(operations[i], idGenerator.next(), idGenerator, mimeType);
        }
        return ret;
    }

    public static AbstractCommand managementOperation2command(ManagementOperation o, CmdID cmdId, CommandIdGenerator idGenerator, String mimeType) {
        if (o instanceof AtomicManagementOperation) {
            return new Atomic(cmdId, false, null, Util.managementOperations2commands(((AtomicManagementOperation)o).getOperations(), idGenerator, mimeType));
        }
        if (o instanceof SequenceManagementOperation) {
            return new Sequence(cmdId, false, null, Util.managementOperations2commands(((SequenceManagementOperation)o).getOperations(), idGenerator, mimeType));
        }
        if (o instanceof AddManagementOperation) {
            return new Add(cmdId, false, null, null, Util.nodes2Items(((AddManagementOperation)o).getNodes(), true, false, mimeType));
        }
        if (o instanceof CopyManagementOperation) {
            return new Copy(cmdId, false, null, null, Util.nodes2Items(((CopyManagementOperation)o).getNodes(), false, true, mimeType));
        }
        if (o instanceof DeleteManagementOperation) {
            return new Delete(cmdId, false, false, false, null, null, Util.nodes2Items(((DeleteManagementOperation)o).getNodes(), false, false, mimeType));
        }
        if (o instanceof ExecManagementOperation) {
            return new Exec(cmdId, false, null, ((ExecManagementOperation)o).getCorrelator(), Util.nodes2Items(((ExecManagementOperation)o).getNodes(), false, false, mimeType)[0]);
        }
        if (o instanceof GetManagementOperation) {
            return new Get(cmdId, false, null, null, null, Util.nodes2Items(((GetManagementOperation)o).getNodes(), false, false, mimeType));
        }
        if (o instanceof ReplaceManagementOperation) {
            return new Replace(cmdId, false, null, null, Util.nodes2Items(((ReplaceManagementOperation)o).getNodes(), true, false, mimeType));
        }
        if (o instanceof UserAlertManagementOperation) {
            UserAlertManagementOperation a = (UserAlertManagementOperation)o;
            return new Alert(cmdId, false, null, a.getAlertCode(), Util.alert2Items(a));
        }
        return null;
    }

    public static Item[] nodes2Items(Map<String, Object> nodes, boolean useValue, boolean includeSourceURI, String mimeType) {
        if (nodes == null || nodes.isEmpty()) {
            return new Item[0];
        }
        Item[] items = new Item[nodes.size()];
        String key = null;
        Object value = null;
        int j = 0;
        Iterator<String> i = nodes.keySet().iterator();
        String sourceURI = null;
        while (i.hasNext()) {
            key = i.next();
            value = nodes.get(key);
            sourceURI = includeSourceURI ? key : null;
            if (!(value instanceof TreeNode) && !(value instanceof MgmtTree)) {
                value = includeSourceURI ? new TreeNode((String)value, value) : new TreeNode(key, value);
            }
            if (value instanceof TreeNode) {
                items[j] = Util.treeNode2item(sourceURI, (TreeNode)value, useValue);
                ++j;
                continue;
            }
            if (!(value instanceof MgmtTree)) continue;
            items[j++] = Util.mgmtTree2item(key.toString(), (MgmtTree)value, useValue, mimeType);
        }
        return items;
    }

    public static Item treeNode2item(String sourceURI, TreeNode treeNode, boolean useValue) {
        Item item = null;
        ComplexData complexData = null;
        String format = null;
        String key = null;
        Object value = null;
        String type = null;
        format = treeNode.getFormat();
        key = treeNode.getName();
        value = treeNode.getValue();
        type = treeNode.getType();
        if (format == null) {
            format = "chr";
        }
        if (format.equalsIgnoreCase("b64")) {
            complexData = value instanceof byte[] ? new ComplexData(new String(Base64.encode((byte[])value))) : new ComplexData(new String(Base64.encode(value.toString().getBytes())));
        } else if (format.equalsIgnoreCase("node")) {
            value = "";
        }
        if (useValue && complexData == null) {
            complexData = new ComplexData(String.valueOf(value));
        }
        Meta meta = new Meta();
        meta.setFormat(format);
        meta.setType(type);
        item = new Item(new Target(String.valueOf(key)), sourceURI != null ? new Source(sourceURI) : null, useValue ? meta : null, useValue ? complexData : null, false);
        return item;
    }

    public static ManagementOperationResult[] operationResults(AbstractCommand[] commands, String dischargedStatus) throws ProtocolException {
        if (commands == null || commands.length == 0) {
            return new ManagementOperationResult[0];
        }
        TreeMap<String, ManagementOperationResult> results = new TreeMap<String, ManagementOperationResult>(new CmdComparator());
        String key = null;
        Status status = null;
        ManagementOperationResult s = null;
        String statusCode = null;
        for (int i = 0; i < commands.length; ++i) {
            if (!(commands[i] instanceof Status) || MANAGEMENT_COMMANDS.indexOf((status = (Status)commands[i]).getCmd()) < 0 || dischargedStatus.indexOf(statusCode = status.getData().getData()) != -1) continue;
            key = status.getMsgRef();
            s = (ManagementOperationResult)results.get(key = (key == null ? "1" : key) + '-' + status.getCmdRef() + '-' + status.getStatusCode());
            if (s != null) continue;
            String cmd = status.getCmd();
            s = new ManagementOperationResult();
            s.setStatusCode(status.getStatusCode());
            s.setCommand(cmd);
            if (Alert.COMMAND_NAME.equals(cmd)) {
                s.setNodes(Util.nodesFromItems(status));
            } else {
                s.setNodes(Util.nodesFromTargetRefs(status));
            }
            results.put(key, s);
        }
        Results res = null;
        for (int i = 0; i < commands.length; ++i) {
            if (!(commands[i] instanceof Results)) continue;
            res = (Results)commands[i];
            key = res.getMsgRef();
            s = (ManagementOperationResult)results.get(key = (key == null ? "1" : key) + '-' + res.getCmdRef() + "-200");
            if (s == null) {
                throw new ProtocolException("Results " + key + " is without corresponding Status");
            }
            s.addNodes(Util.nodesFromItems(res));
        }
        ManagementOperationResult[] ret = new ManagementOperationResult[results.size()];
        int i = 0;
        Iterator iter = results.values().iterator();
        while (iter.hasNext()) {
            ret[i++] = (ManagementOperationResult)iter.next();
        }
        return ret;
    }

    public static Map<String, Object> nodesFromItems(AbstractCommand cmd) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (!(cmd instanceof ItemizedCommand)) {
            return ret;
        }
        String path = null;
        Object value = null;
        if (((ItemizedCommand)cmd).getItems() == null) {
            return ret;
        }
        int c = 0;
        Item item = null;
        Iterator<Item> i = ((ItemizedCommand)cmd).getItems().iterator();
        String format = null;
        String type = null;
        ComplexData itemData = null;
        while (i.hasNext()) {
            item = i.next();
            format = Util.getItemFormat(item);
            type = item.getMeta() != null ? item.getMeta().getType() : null;
            String string = path = item.getSource() == null ? String.valueOf(++c) : item.getSource().getLocURI();
            if ("xml".equalsIgnoreCase(format) && "application/vnd.syncml.dmtnds+xml".equalsIgnoreCase(type)) {
                value = Util.convertXMLInMgmtTree(item.getData().getData());
            } else if ("application/vnd.syncml.dmtnds+wbxml".equalsIgnoreCase(type)) {
                value = Util.convertB64WBXMLInMgmtTree(item.getData().getData());
            } else {
                itemData = item.getData();
                if (itemData != null) {
                    value = itemData.getData();
                    if (format.equalsIgnoreCase("chr")) {
                        value = String.valueOf(value);
                    } else if (format.equalsIgnoreCase("b64")) {
                        value = value != null && ((String)value).length() > 0 ? (Object)Base64.decode(((String)value).getBytes()) : (Object)new byte[0];
                    } else if (format.equalsIgnoreCase("bool")) {
                        value = Boolean.valueOf((String)value);
                    } else if (format.equalsIgnoreCase("int")) {
                        try {
                            value = new Integer((String)value);
                        }
                        catch (NumberFormatException e) {
                            value = new ManagementException("Node with format int not contains a valid integer value (" + value + ")");
                        }
                    }
                    if (format.equalsIgnoreCase("node")) {
                        value = new TreeNode(item.getSource().getLocURI(), value, format);
                    }
                }
            }
            ret.put(path, value == null ? "" : value);
        }
        return ret;
    }

    public static Map<String, Object> nodesFromTargetRefs(AbstractCommand cmd) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (!(cmd instanceof ResponseCommand)) {
            return ret;
        }
        String node = null;
        if (((ResponseCommand)cmd).getTargetRef() == null) {
            return ret;
        }
        TargetRef ref2 = null;
        for (TargetRef ref2 : ((ResponseCommand)cmd).getTargetRef()) {
            node = ref2.getValue();
            ret.put(node, "");
        }
        return ret;
    }

    public static Item[] alert2Items(UserAlertManagementOperation alert) {
        char c;
        String s;
        String[] alerts = alert.getAlerts();
        Item[] items = new Item[alerts == null ? 1 : alerts.length + 1];
        StringBuffer options = new StringBuffer();
        int i = alert.getMinDisplayTime();
        if (i > 0) {
            options.append(ALERT_OPTION_MINDT).append('=').append(i).append('&');
        }
        if ((i = alert.getMaxDisplayTime()) > 0) {
            options.append(ALERT_OPTION_MAXDT).append('=').append(i).append('&');
        }
        if ((s = alert.getDefaultResponse()) != null) {
            try {
                options.append(ALERT_OPTION_DR).append('=').append(URLEncoder.encode(s, "UTF-8")).append('&');
            }
            catch (UnsupportedEncodingException e) {
                options.append(e.getMessage());
            }
        }
        if ((i = alert.getMaxLength()) > 0) {
            options.append(ALERT_OPTION_MAXLEN).append('=').append(i).append('&');
        }
        if ((c = alert.getInputType()) != ' ') {
            options.append(ALERT_OPTION_IT).append('=').append(c).append('&');
        }
        if ((c = alert.getEchoType()) != ' ') {
            options.append(ALERT_OPTION_ET).append('=').append(c).append('&');
        }
        if (options.length() > 0) {
            options.deleteCharAt(options.length() - 1);
        }
        items[0] = new Item(null, null, null, new ComplexData(options.toString()), false);
        for (i = 1; i < items.length; ++i) {
            items[i] = new Item(null, null, null, new ComplexData(alerts[i - 1]), false);
        }
        return items;
    }

    private static String getItemFormat(Item item) {
        Meta meta = item.getMeta();
        if (meta == null) {
            return "chr";
        }
        String format = meta.getFormat();
        if (format == null) {
            format = "chr";
        }
        return format;
    }

    public static Item mgmtTree2item(String path, MgmtTree mgmtTree, boolean useValue, String mimeType) {
        Item item = null;
        ComplexData complexData = null;
        if ("application/vnd.syncml.dm+xml".equalsIgnoreCase(mimeType)) {
            StringBuffer data = new StringBuffer();
            data.append("<![CDATA[");
            String xml = com.funambol.framework.core.Util.toXML(mgmtTree);
            xml = xml.replaceAll("<MgmtTree>", "<MgmtTree xmlns='syncml:dmddf1.2'>");
            byte[] wbxml = null;
            try {
                wbxml = WBXMLTools.toWBXML(xml, Constants.DTD_1_2.getValue());
            }
            catch (Sync4jException ex) {
                ex.printStackTrace();
            }
            String b64 = new String(Base64.encode(wbxml));
            xml = Util.replaceTagsInMgmtTree(xml);
            data.append(xml);
            data.append("]]>");
            if (useValue && complexData == null) {
                complexData = new ComplexData();
                complexData.setData(data.toString());
            }
        } else if ("application/vnd.syncml.dm+wbxml".equalsIgnoreCase(mimeType)) {
            complexData = new ComplexData();
            complexData.setMgmtTree(mgmtTree);
        }
        Meta meta = new Meta();
        if ("application/vnd.syncml.dm+xml".equalsIgnoreCase(mimeType)) {
            meta.setFormat("xml");
            meta.setType("application/vnd.syncml.dmtnds+xml");
        } else if ("application/vnd.syncml.dm+wbxml".equalsIgnoreCase(mimeType)) {
            meta.setFormat("bin");
            meta.setType("application/vnd.syncml.dmtnds+wbxml");
        }
        item = new Item(new Target(String.valueOf(path)), null, useValue ? meta : null, useValue ? complexData : null, false);
        return item;
    }

    public static List<Node> mergeSubNodes(ArrayList<Node> firstNodes, ArrayList<Node> secondNodes) {
        if (firstNodes == null) {
            return secondNodes;
        }
        if (secondNodes == null) {
            return firstNodes;
        }
        ArrayList<Node> newNodes = new ArrayList<Node>();
        Iterator<Node> i = firstNodes.iterator();
        for (Node secondNode : secondNodes) {
            boolean nodeNotFound = true;
            String secondName = secondNode.getName();
            String secondType = secondNode.getRtProperties().getType();
            while (i.hasNext() && nodeNotFound) {
                Node firstNode = i.next();
                String firstName = firstNode.getName();
                String firstType = firstNode.getRtProperties().getType();
                if (firstType == null || !firstType.equals(secondType) || (firstName != null || secondName != null) && !firstName.equals(secondName)) continue;
                nodeNotFound = false;
                firstNode.setSubNodes((ArrayList)Util.mergeSubNodes(firstNode.getSubNodes(), secondNode.getSubNodes()));
                firstNode.setValue(secondNode.getValue());
                firstNode.setPath(secondNode.getPath());
                firstNode.setRtProperties(secondNode.getRtProperties());
            }
            if (!nodeNotFound) continue;
            newNodes.add(secondNode);
        }
        firstNodes.addAll(newNodes);
        return firstNodes;
    }

    public static Node convertTreeNodeToNode(TreeNode tn) {
        String path;
        String name;
        if (tn == null) {
            return null;
        }
        Node node = new Node();
        RTProperties rtp = new RTProperties();
        String tnName = tn.getName();
        if (!tnName.startsWith("./")) {
            throw new IllegalArgumentException("Node name '" + tnName + "' is not valid");
        }
        int i = tnName.lastIndexOf("/");
        if (tnName.length() > i + 1) {
            name = tnName.substring(i + 1);
            path = tnName.substring(0, i);
            if (path.endsWith(".")) {
                path = path + "/";
            }
        } else {
            name = tnName;
            path = null;
        }
        node.setName(name);
        node.setPath(path);
        if (tn.getValue() != null) {
            node.setValue(tn.getValue().toString());
        }
        rtp.setFormat(tn.getFormat());
        node.setRtProperties(rtp);
        return node;
    }

    private static MgmtTree convertXMLInMgmtTree(String xml) {
        MgmtTree tree = null;
        if (xml == null) {
            return null;
        }
        int indexOfSyncML = xml.indexOf("<SyncML");
        StringBuffer newData = new StringBuffer(xml.substring(0, indexOfSyncML));
        newData.append("<Data>");
        newData.append(xml.substring(indexOfSyncML));
        newData.append("</Data>");
        String xmlMgmtTree = XMLTools.replaceAmp(newData.toString());
        try {
            IBindingFactory f = BindingDirectory.getFactory(MgmtTree.class);
            IUnmarshallingContext unm = f.createUnmarshallingContext();
            Object value = unm.unmarshalDocument((InputStream)new ByteArrayInputStream(xmlMgmtTree.getBytes()), "UTF-8");
            tree = ((ComplexData)value).getMgmtTree();
        }
        catch (JiBXException ex) {
            ex.printStackTrace();
        }
        return tree;
    }

    private static MgmtTree convertB64WBXMLInMgmtTree(String data) {
        MgmtTree tree = null;
        if (data == null) {
            return null;
        }
        byte[] wbxml = Base64.decode(data);
        String xml = null;
        try {
            xml = WBXMLTools.wbxmlToXml(wbxml);
            IBindingFactory f = BindingDirectory.getFactory(MgmtTree.class);
            IUnmarshallingContext unm = f.createUnmarshallingContext();
            Object value = unm.unmarshalDocument((InputStream)new ByteArrayInputStream(xml.getBytes()), "UTF-8");
            tree = (MgmtTree)value;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return tree;
    }

    private static String replaceTagsInMgmtTree(String data) {
        if (data == null) {
            return null;
        }
        data = data.replaceAll("<node></node>", "<node/>");
        data = data.replaceAll("<chr></chr>", "<chr/>");
        data = data.replaceAll("<b64></b64>", "<b64/>");
        data = data.replaceAll("<bool></bool>", "<bool/>");
        data = data.replaceAll("<float></float>", "<float/>");
        data = data.replaceAll("<int></int>", "<int/>");
        data = data.replaceAll("<null></null>", "<null/>");
        data = data.replaceAll("<xml></xml>", "<xml/>");
        data = data.replaceAll("<date></date>", "<date/>");
        data = data.replaceAll("<time></time>", "<time/>");
        return data;
    }

    public static void main(String[] args) throws Exception {
        String b64 = "AgAAahotLy9PTUEvL0RURC1ETS1EREYgMS4yLy9FTkQAYGRmA0Z1bmFtYm9sQWNjAAFsAy4AAW9cJQF1A29yZy5vcGVubW9iaWxlYWxsaWFuY2UvMS4wL3c3AAEBZGYDQXBwSUQAAXYDdzcAAW9cCwF1A3RleHQvcGxhaW4AAQEBZGYDU2VydmVySUQAAXYDRnVuYW1ib2xJRAABb1wLAXUDdGV4dC9wbGFpbgABAQFkZgNBcHBBZGRyAAFvXCUBdQN0ZXh0L3BsYWluAAEBZGYDRnVuYW1ib2xBZGRyAAFvXCUBdQN0ZXh0L3BsYWluAAEBZGYDQWRkclR5cGUAAXYDVVJJAAFvXAsBdQN0ZXh0L3BsYWluAAEBAWRmA1BvcnQAAW9cJQF1A3RleHQvcGxhaW4AAQFkZgNGdW5hbWJvbFBvcnQAAW9cJQF1A3RleHQvcGxhaW4AAQFkZgNQb3J0TmJyAAF2AzgwODAAAW9cCwF1A3RleHQvcGxhaW4AAQEBAQEBAWRmA0FwcEF1dGgAAW9cJQF1A3RleHQvcGxhaW4AAQFkZgNmdW5hbWJvbFNlcnZlcgABb1wlAXUDdGV4dC9wbGFpbgABAWRmA0FBdXRoVHlwZQABdgNCQVNJQwABb1wLAXUDdGV4dC9wbGFpbgABAQFkZgNBQXV0aFNlY3JldAABdgNzcnZwd2QAAW9cCwF1A3RleHQvcGxhaW4AAQEBZGYDQUF1dGhMZXZlbAABdgNTUlZDUkVEAAFvXAsBdQN0ZXh0L3BsYWluAAEBAWRmA0FBdXRoTmFtZQABdgNmdW5hbWJvbAABb1wLAXUDdGV4dC9wbGFpbgABAQEBZGYDZnVuYW1ib2xDbGllbnQAAW9cJQF1A3RleHQvcGxhaW4AAQFkZgNBQXV0aFR5cGUAAXYDQkFTSUMAAW9cCwF1A3RleHQvcGxhaW4AAQEBZGYDQUF1dGhTZWNyZXQAAXYDZnVuYW1ib2wAAW9cCwF1A3RleHQvcGxhaW4AAQEBZGYDQUF1dGhMZXZlbAABdgNDTENSRUQAAW9cCwF1A3RleHQvcGxhaW4AAQEBZGYDQUF1dGhOYW1lAAF2A2Z1bmFtYm9sAAFvXAsBdQN0ZXh0L3BsYWluAAEBAQEBAXcDMS4yAAEBAQ==";
        byte[] wbxml = Base64.decode(b64);
        IOTools.writeFile(wbxml, "c:\\mgmtTree.bin");
    }

    private static class CmdComparator
    implements Comparator {
        private CmdComparator() {
        }

        public int compare(Object o1, Object o2) {
            int msgId2;
            String value1 = null;
            String value2 = null;
            if (!(o1 instanceof String) || !(o2 instanceof String)) {
                throw new IllegalArgumentException("o1 (" + o1 + ") and o2 (" + o2 + ") must be string!");
            }
            value1 = (String)o1;
            value2 = (String)o2;
            int msgId1 = this.extractMsgId(value1);
            if (msgId1 == (msgId2 = this.extractMsgId(value2))) {
                int cmdId1 = this.extractCmdId(value1);
                int cmdId2 = this.extractCmdId(value2);
                return cmdId1 - cmdId2;
            }
            return msgId1 - msgId2;
        }

        private int extractMsgId(String key) throws IllegalArgumentException {
            if (key == null) {
                throw new IllegalArgumentException("key cannot be null");
            }
            int p1 = key.indexOf(45);
            if (p1 <= 0 || p1 == key.length() - 1) {
                throw new IllegalArgumentException("key is not in the form {msgref}-{cmdref}-{status}");
            }
            int p2 = key.indexOf(45, p1 + 1);
            if (p2 <= 0) {
                throw new IllegalArgumentException("key is not in the form {msgref}-{cmdref}-{status}");
            }
            try {
                return Integer.parseInt(key.substring(0, p1));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("key is not in the form {msgref}-{cmdref}-{status}");
            }
        }

        private int extractCmdId(String key) throws IllegalArgumentException {
            if (key == null) {
                throw new IllegalArgumentException("key cannot be null");
            }
            int p1 = key.indexOf(45);
            if (p1 <= 0 || p1 == key.length() - 1) {
                throw new IllegalArgumentException("key is not in the form {msgref}-{cmdref}-{status}");
            }
            int p2 = key.indexOf(45, p1 + 1);
            if (p2 <= 0) {
                throw new IllegalArgumentException("key is not in the form {msgref}-{cmdref}-{status}");
            }
            try {
                return Integer.parseInt(key.substring(p1 + 1, p2));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("key is not in the form {msgref}-{cmdref}-{status}");
            }
        }
    }
}

