/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.JiBXException;

public abstract class BindingDirectory {
    public static final String BINDINGLIST_NAME = "JiBX_bindingList";
    public static final String GENERATE_PREFIX = "JiBX_";
    public static final String BINDINGFACTORY_SUFFIX = "Factory";
    public static final String FACTORY_INSTMETHOD = "getInstance";
    public static final Class[] EMPTY_ARGS = new Class[0];

    private static String getBindingList(Class clas) throws JiBXException {
        try {
            Field field = clas.getDeclaredField(BINDINGLIST_NAME);
            try {
                field.setAccessible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return (String)field.get(null);
        }
        catch (NoSuchFieldException e) {
            throw new JiBXException("Unable to access binding information for class " + clas.getName() + "\nMake sure the binding has been compiled", e);
        }
        catch (IllegalAccessException e) {
            throw new JiBXException("Error in added code for class " + clas.getName() + "Please report this to the JiBX developers", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static IBindingFactory getFactoryFromName(String name, Class clas, ClassLoader loader) throws JiBXException {
        ex /* !! */  = null;
        result = null;
        ifact = null;
        incompat = false;
        try {
            factory = loader.loadClass(name);
            method = factory.getMethod("getInstance", BindingDirectory.EMPTY_ARGS);
            result = method.invoke(null, (Object[])null);
        }
        catch (SecurityException e) {
            ex /* !! */  = e;
        }
        catch (ClassNotFoundException e) {
            ex /* !! */  = e;
        }
        catch (NoSuchMethodException e) {
            ex /* !! */  = e;
        }
        catch (IllegalAccessException e) {
            ex /* !! */  = e;
        }
        catch (InvocationTargetException e) {
            ex /* !! */  = e;
            incompat = true;
        }
        finally {
            if (ex /* !! */  != null) ** GOTO lbl35
            if (result instanceof IBindingFactory) {
                ifact = (IBindingFactory)result;
                diff = ifact.getCompilerVersion() ^ 196608;
                if ((diff & -65536) != 0) {
                    throw new JiBXException("Binding information for class " + clas.getName() + " must be recompiled with current binding " + "compiler (compiled with " + ifact.getCompilerDistribution() + ", runtime is " + "@distrib@" + ")");
                }
            } else {
                throw new JiBXException("Classloader conflict for binding factory '" + name + "' - factory does not implement required interface");
lbl35:
                // 1 sources

                if (incompat) {
                    throw new JiBXException("Incompatible binding version for class " + clas.getName() + ", recompile binding with current JiBX distribution", ex /* !! */ );
                }
                throw new JiBXException("Unable to access binding information for class " + clas.getName() + "\nMake sure classes generated by the " + "binding compiler are available at runtime", ex /* !! */ );
            }
            ifact.verifyBaseBindings();
        }
        return ifact;
    }

    public static IBindingFactory getFactory(String name, Class clas, ClassLoader loader) throws JiBXException {
        String match;
        String list = BindingDirectory.getBindingList(clas);
        int index = list.indexOf(match = GENERATE_PREFIX + BindingDirectory.convertName(name) + BINDINGFACTORY_SUFFIX + '|');
        if (index >= 0) {
            int mark = list.lastIndexOf(124, index);
            String fname = list.substring(mark + 1, index + match.length() - 1);
            if ((mark = fname.indexOf(61)) >= 0) {
                fname = fname.substring(0, mark);
            }
            return BindingDirectory.getFactoryFromName(fname, clas, loader);
        }
        throw new JiBXException("Binding '" + name + "' not found for class " + clas.getName());
    }

    public static IBindingFactory getFactory(String name, Class clas) throws JiBXException {
        return BindingDirectory.getFactory(name, clas, clas.getClassLoader());
    }

    public static IBindingFactory getFactory(Class clas) throws JiBXException {
        String fact;
        String list = BindingDirectory.getBindingList(clas);
        if (list != null && list.length() > 2 && (fact = list.substring(1, list.length() - 1)).indexOf(124) < 0) {
            return BindingDirectory.getFactoryFromName(fact, clas, clas.getClassLoader());
        }
        throw new JiBXException("Multiple bindings defined for class " + clas.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IBindingFactory getFactory(String bname, String pack, ClassLoader loader) throws JiBXException {
        IBindingFactory ifact;
        block16: {
            String cname = (pack == null ? "" : pack + '.') + GENERATE_PREFIX + BindingDirectory.convertName(bname) + BINDINGFACTORY_SUFFIX;
            Exception ex = null;
            Object result = null;
            ifact = null;
            try {
                Class<?> factory = loader.loadClass(cname);
                Method method = factory.getMethod(FACTORY_INSTMETHOD, EMPTY_ARGS);
                result = method.invoke(null, (Object[])null);
            }
            catch (SecurityException e) {
                ex = e;
                return ex;
            }
            catch (ClassNotFoundException e) {
                ex = e;
                return ex;
            }
            catch (NoSuchMethodException e) {
                ex = e;
                return ex;
            }
            catch (IllegalAccessException e) {
                ex = e;
                return ex;
            }
            catch (InvocationTargetException e) {
                ex = e;
                return ex;
            }
            finally {
                if (ex == null) {
                    if (result instanceof IBindingFactory) {
                        ifact = (IBindingFactory)result;
                        int diff = ifact.getCompilerVersion() ^ 0x30000;
                        if ((diff & 0xFFFF0000) != 0) {
                            throw new JiBXException("Binding '" + bname + "' must be recompiled with current binding " + "compiler (compiled with " + ifact.getCompilerDistribution() + ", runtime is " + "@distrib@" + ")");
                        }
                        break block16;
                    }
                    throw new JiBXException("Classloader conflict for binding '" + bname + "' - factory does not implement required interface");
                }
                throw new JiBXException("Unable to access binding '" + bname + "'\nMake sure classes generated by the " + "binding compiler are available at runtime", ex);
            }
        }
        return ifact;
    }

    public static IBindingFactory getFactory(String bname, String pack) throws JiBXException {
        return BindingDirectory.getFactory(bname, pack, BindingDirectory.class.getClassLoader());
    }

    public static String convertName(String name) {
        StringBuffer buff = new StringBuffer(name);
        for (int i = 0; i < buff.length(); ++i) {
            if (Character.isJavaIdentifierPart(buff.charAt(i))) continue;
            buff.setCharAt(i, '_');
        }
        return buff.toString();
    }
}

