/*
 * Decompiled with CFR 0.152.
 */
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.vmguys.vmtools.ota.OtaUpdate;
import org.vmguys.vmtools.ota.UniqueId;

public class XmlPatch {
    public static void main(String[] args) {
        if (args.length == 2) {
            try {
                URL originalURL = new URL(args[0]);
                URL updateURL = new URL(args[1]);
                new XmlPatch().go(originalURL, updateURL);
            }
            catch (MalformedURLException mux) {
                System.err.println(mux);
            }
        } else {
            System.err.println("usage: XmlPatch <XmlURL> <UpdateRequestURL>");
        }
    }

    private void go(URL originalURL, URL updateURL) {
        try {
            SAXBuilder sb = new SAXBuilder();
            Document originalDoc = sb.build(originalURL);
            Document updateDoc = sb.build(updateURL);
            OtaUpdate gu = new OtaUpdate(false);
            UniqueId id = new UniqueId("Profile", "12345");
            Element newDoc = gu.applyDiffs(originalDoc.getRootElement(), updateDoc.getRootElement());
            XMLOutputter xmlo = new XMLOutputter("  ", true);
            xmlo.setTextNormalize(true);
            xmlo.output(newDoc, (OutputStream)System.out);
            System.out.println();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

