/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.log.Trace;
import org.jgroups.protocols.PingHeader;
import org.jgroups.protocols.PingRsp;
import org.jgroups.stack.GossipClient;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class PING
extends Protocol {
    Vector members = new Vector();
    Vector initial_members = new Vector();
    Address local_addr = null;
    String group_addr = null;
    long timeout = 3000L;
    long num_initial_members = 2L;
    String gossip_host = null;
    int gossip_port = 0;
    long gossip_refresh = 20000L;
    GossipClient client;
    boolean is_server = false;

    public String getName() {
        return "PING";
    }

    public Vector providedUpServices() {
        Vector<Integer> ret = new Vector<Integer>();
        ret.addElement(new Integer(12));
        return ret;
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = new Long(str);
            if (this.timeout <= 0L) {
                Trace.error("PING.setProperties()", "timeout must be > 0");
            }
            props.remove("timeout");
        }
        if ((str = props.getProperty("num_initial_members")) != null) {
            this.num_initial_members = new Integer(str).intValue();
            props.remove("num_initial_members");
        }
        if ((str = props.getProperty("gossip_host")) != null) {
            this.gossip_host = str;
            props.remove("gossip_host");
        }
        if ((str = props.getProperty("gossip_port")) != null) {
            this.gossip_port = new Integer(str);
            props.remove("gossip_port");
        }
        if ((str = props.getProperty("gossip_refresh")) != null) {
            this.gossip_refresh = new Long(str);
            props.remove("gossip_refresh");
        }
        if (this.gossip_host != null && this.gossip_port != 0) {
            try {
                this.client = new GossipClient(new IpAddress(InetAddress.getByName(this.gossip_host), this.gossip_port), this.gossip_refresh);
            }
            catch (Exception e) {
                Trace.error("PING.setProperties()", "creation of GossipClient failed, exception=" + e);
                return false;
            }
        }
        if (props.size() > 0) {
            StringBuffer sb = new StringBuffer();
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                sb.append(e.nextElement().toString());
                if (!e.hasMoreElements()) continue;
                sb.append(", ");
            }
            Trace.error("PING.setProperties()", "The following properties are not recognized: " + sb.toString());
            return false;
        }
        return true;
    }

    public void stop() {
        this.is_server = false;
        if (this.client != null) {
            this.client.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Header obj = msg.getHeader(this.getName());
                if (obj == null || !(obj instanceof PingHeader)) {
                    this.passUp(evt);
                    return;
                }
                PingHeader hdr = (PingHeader)msg.removeHeader(this.getName());
                switch (hdr.type) {
                    case 1: {
                        Address coord;
                        if (!this.is_server) {
                            return;
                        }
                        Vector vector = this.members;
                        synchronized (vector) {
                            coord = this.members.size() > 0 ? (Address)this.members.firstElement() : this.local_addr;
                        }
                        Message rsp_msg = new Message(msg.getSrc(), null, null);
                        PingHeader rsp_hdr = new PingHeader(2, new PingRsp(this.local_addr, coord));
                        rsp_msg.putHeader(this.getName(), rsp_hdr);
                        if (Trace.trace) {
                            Trace.info("PING.up()", "received GET_MBRS_REQ from " + msg.getSrc() + ", returning " + rsp_hdr);
                        }
                        this.passDown(new Event(1, rsp_msg));
                        return;
                    }
                    case 2: {
                        PingRsp rsp = (PingRsp)hdr.arg;
                        Vector vector = this.initial_members;
                        synchronized (vector) {
                            if (Trace.trace) {
                                Trace.info("PING.up()", "received FIND_INITAL_MBRS_RSP, rsp=" + rsp);
                            }
                            this.initial_members.addElement(rsp);
                            this.initial_members.notify();
                        }
                        return;
                    }
                }
                Trace.warn("PING.up()", "got PING header with unknown type (" + hdr.type + ")");
                return;
            }
            case 8: {
                this.passUp(evt);
                this.local_addr = (Address)evt.getArg();
                break;
            }
            default: {
                this.passUp(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void down(Event evt) {
        Vector gossip_rsps = null;
        switch (evt.getType()) {
            case 12: {
                Object view_event;
                if (this.client != null) {
                    gossip_rsps = this.client.getMembers(this.group_addr);
                    if (gossip_rsps == null || gossip_rsps.size() <= 0) {
                        this.passUp(new Event(13, null));
                        return;
                    }
                    view_event = new Event(15, this.makeView(gossip_rsps));
                    this.passDown((Event)view_event);
                    Util.sleep(500L);
                }
                this.initial_members.removeAllElements();
                if (Trace.trace) {
                    Trace.info("PING.down()", "FIND_INITIAL_MBRS");
                }
                PingHeader hdr = new PingHeader(1, null);
                Message msg = new Message(null, null, null);
                msg.putHeader(this.getName(), hdr);
                this.passDown(new Event(1, msg));
                view_event = this.initial_members;
                synchronized (view_event) {
                    long start_time = System.currentTimeMillis();
                    for (long time_to_wait = this.timeout; (long)this.initial_members.size() < this.num_initial_members && time_to_wait > 0L; time_to_wait -= System.currentTimeMillis() - start_time) {
                        try {
                            this.initial_members.wait(time_to_wait);
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                if (Trace.trace) {
                    Trace.info("PING.down()", "initial mbrs are " + this.initial_members);
                }
                this.passUp(new Event(13, this.initial_members));
                break;
            }
            case 6: 
            case 15: {
                Vector tmp = ((View)evt.getArg()).getMembers();
                if (tmp != null) {
                    Vector vector = this.members;
                    synchronized (vector) {
                        this.members.removeAllElements();
                        for (int i = 0; i < tmp.size(); ++i) {
                            this.members.addElement(tmp.elementAt(i));
                        }
                    }
                }
                this.passDown(evt);
                break;
            }
            case 16: {
                this.passDown(evt);
                this.is_server = true;
                break;
            }
            case 2: {
                this.group_addr = (String)evt.getArg();
                this.passDown(evt);
                if (this.client == null) break;
                this.client.register(this.group_addr, this.local_addr);
                break;
            }
            case 4: {
                if (this.client != null) {
                    this.client.stop();
                }
                this.passDown(evt);
                break;
            }
            default: {
                this.passDown(evt);
            }
        }
    }

    private View makeView(Vector mbrs) {
        Address coord = null;
        long id = 0L;
        ViewId view_id = new ViewId(this.local_addr);
        coord = view_id.getCoordAddress();
        id = view_id.getId();
        return new View(coord, id, mbrs);
    }
}

