/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Properties;
import org.jgroups.Event;
import org.jgroups.log.Trace;
import org.jgroups.stack.Protocol;

public class AUTOCONF
extends Protocol {
    HashMap config = new HashMap();
    int num_iterations = 10;

    public String getName() {
        return "AUTOCONF";
    }

    public void init() throws Exception {
        this.senseNetworkConfiguration();
        if (Trace.trace) {
            Trace.info("AUTOCONF.init()", "configuration is\n" + this.config);
        }
    }

    public void start() throws Exception {
        if (this.config != null && this.config.size() > 0) {
            Event config_evt = new Event(56, this.config);
            this.passDown(config_evt);
            this.passUp(config_evt);
        }
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("num_iterations");
        if (str != null) {
            this.num_iterations = new Integer(str);
            props.remove("num_iterations");
        }
        if (props.size() > 0) {
            System.err.println("AUTOCONF.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void startUpHandler() {
    }

    public void startDownHandler() {
    }

    void senseNetworkConfiguration() {
        this.senseMaxSendBufferSize(this.config);
        this.senseMaxReceiveBufferSize(this.config);
        this.senseMaxFragSize(this.config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void senseMaxSendBufferSize(HashMap map) {
        DatagramSocket sock = null;
        int max_size = 4096;
        int retval = 32000;
        try {
            sock = new DatagramSocket();
            while (true) {
                sock.setSendBufferSize(max_size);
                retval = sock.getSendBufferSize();
                if (retval < max_size) {
                    return;
                }
                max_size *= 2;
                continue;
                break;
            }
        }
        catch (Throwable ex) {
            retval = 32000;
            Trace.error("AUTOCONF.senseMaxSendBufferSize()", "failed getting the max send buffer size: " + ex + ". Defaulting to " + retval);
            return;
        }
        finally {
            map.put("send_buf_size", new Integer(retval));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void senseMaxReceiveBufferSize(HashMap map) {
        DatagramSocket sock = null;
        int max_size = 4096;
        int retval = 32000;
        try {
            sock = new DatagramSocket();
            while (true) {
                sock.setReceiveBufferSize(max_size);
                retval = sock.getReceiveBufferSize();
                if (retval < max_size) {
                    return;
                }
                max_size *= 2;
                continue;
                break;
            }
        }
        catch (Throwable ex) {
            retval = 32000;
            Trace.error("AUTOCONF.senseMaxReceiveBufferSize()", "failed getting the max send buffer size: " + ex + ". Defaulting to " + retval);
            return;
        }
        finally {
            map.put("recv_buf_size", new Integer(retval));
        }
    }

    void senseMaxFragSize(HashMap map) {
        InetAddress local_addr;
        DatagramSocket sock;
        int upper;
        int max_send = 32000;
        int max_recv = 32000;
        int lower = upper = 8192;
        if (this.config.containsKey("send_buf_size")) {
            max_send = (Integer)this.config.get("send_buf_size");
        }
        if (this.config.containsKey("recv_buf_size")) {
            max_recv = (Integer)this.config.get("recv_buf_size");
        }
        try {
            sock = new DatagramSocket();
            local_addr = InetAddress.getLocalHost();
        }
        catch (Exception ex) {
            Trace.warn("AUTOCONF.senseMaxFragSize()", "failed creating DatagramSocket: " + ex);
            return;
        }
        for (int i = 0; i < this.num_iterations; ++i) {
            try {
                byte[] buf = new byte[upper];
                DatagramPacket packet = new DatagramPacket(buf, buf.length, local_addr, 9);
                sock.send(packet);
                lower = upper;
                upper *= 2;
                continue;
            }
            catch (IOException io_ex) {
                upper = (upper + lower) / 2;
                continue;
            }
            catch (Throwable ex) {
                Trace.warn("AUTOCONF.senseMaxFragSize()", "exception=" + ex);
                break;
            }
        }
        if (lower > max_send) {
            Trace.warn("AUTOCONF.senseMaxFragSize()", "lower (" + lower + ") > max_send (" + max_send + "): using max_send as frag_size");
            lower = max_send;
        }
        map.put("frag_size", new Integer(lower));
        if (Trace.trace) {
            Trace.info("AUTOCONF.senseMaxFragSize()", "frag_size=" + lower);
        }
    }
}

