/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.persistence;

import java.io.FileInputStream;
import java.util.Properties;
import org.jgroups.persistence.DBPersistenceManager;
import org.jgroups.persistence.FilePersistenceManager;
import org.jgroups.persistence.PersistenceManager;

public class PersistenceFactory {
    private static PersistenceManager _manager = null;
    private static PersistenceFactory _factory = null;
    static final String propPath = "persist.properties";
    static final String persistProp = "persist";

    private PersistenceFactory() {
    }

    public static PersistenceFactory getInstance() {
        System.err.println(" getting factory instance ");
        if (_factory == null) {
            _factory = new PersistenceFactory();
        }
        return _factory;
    }

    public synchronized PersistenceManager createManager() throws Exception {
        if (_manager == null) {
            _manager = this.checkDB() ? this.createManagerDB(propPath) : this.createManagerFile(propPath);
        }
        return _manager;
    }

    public synchronized PersistenceManager createManager(String filePath) throws Exception {
        if (_manager == null) {
            _manager = this.checkDB(filePath) ? this.createManagerDB(filePath) : this.createManagerFile(filePath);
        }
        return _manager;
    }

    private PersistenceManager createManagerDB(String filePath) throws Exception {
        System.err.println(" Calling db persist from factory");
        if (_manager == null) {
            _manager = new DBPersistenceManager(filePath);
        }
        return _manager;
    }

    private PersistenceManager createManagerFile(String filePath) {
        System.err.println(" Calling file persist from factory");
        try {
            if (_manager == null) {
                _manager = new FilePersistenceManager(filePath);
            }
            return _manager;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    private boolean checkDB() throws Exception {
        Properties props = null;
        FileInputStream _stream = new FileInputStream(propPath);
        props = new Properties();
        props.load(_stream);
        String persist = props.getProperty(persistProp);
        return persist.equals("DB");
    }

    private boolean checkDB(String filePath) throws Exception {
        Properties props = null;
        FileInputStream _stream = new FileInputStream(filePath);
        props = new Properties();
        props.load(_stream);
        String persist = props.getProperty(persistProp);
        return persist.equals("DB");
    }
}

