/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.server.engine.dm;

import com.funambol.framework.config.Configuration;
import com.funambol.framework.core.dm.ddf.DevInfo;
import com.funambol.framework.engine.dm.DeviceDMState;
import com.funambol.framework.engine.dm.ManagementProcessor;
import com.funambol.framework.server.dm.ProcessorSelector;
import com.funambol.framework.tools.PatternPair;
import com.funambol.framework.tools.beans.BeanInitializationException;
import com.funambol.framework.tools.beans.LazyInitBean;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;

public class DeviceIdProcessorSelector
implements ProcessorSelector,
LazyInitBean,
Serializable {
    private static final Logger log = Logger.getLogger((String)DeviceIdProcessorSelector.class.getName());
    private Pattern[] regexps;
    private PatternPair[] patterns;
    private String defaultProcessor;

    public void setPatterns(PatternPair[] patterns) {
        this.patterns = patterns;
    }

    public PatternPair[] getPatterns() {
        return this.patterns;
    }

    public void setDefaultProcessor(String defaultProcessor) {
        this.defaultProcessor = defaultProcessor;
    }

    public String getDefaultProcessor() {
        return this.defaultProcessor;
    }

    public ManagementProcessor getProcessor(DeviceDMState dms, DevInfo devInfo) {
        String beanName = this.defaultProcessor;
        String device = devInfo.getDevId();
        for (int i = 0; i < this.regexps.length; ++i) {
            Matcher m = this.regexps[i].matcher(device);
            if (!m.matches()) continue;
            beanName = this.patterns[i].processor;
            break;
        }
        ManagementProcessor processor = null;
        try {
            processor = (ManagementProcessor)Configuration.getConfiguration().getBeanInstanceByName(beanName);
        }
        catch (Exception e) {
            if (log.isEnabled(Logger.Level.TRACE)) {
                log.fatal((Object)("Error instantiating the management processor" + beanName + ": " + e.getMessage()));
            }
            log.debug((Object)"getProcessor", (Throwable)e);
        }
        return processor;
    }

    public void init() throws BeanInitializationException {
        if (this.patterns == null || this.patterns.length == 0) {
            this.regexps = new Pattern[0];
            return;
        }
        this.regexps = new Pattern[this.patterns.length];
        for (int i = 0; i < this.patterns.length; ++i) {
            try {
                this.regexps[i] = Pattern.compile(this.patterns[i].pattern);
                continue;
            }
            catch (Exception e) {
                if (log.isEnabled(Logger.Level.FATAL)) {
                    log.fatal((Object)("Error compiling pattern '" + this.patterns[i].pattern + "': " + e.getMessage()));
                }
                throw new BeanInitializationException("Error compiling pattern '" + this.patterns[i].pattern + "'", (Throwable)e);
            }
        }
    }
}

