package jp.sourceforge.ocmml.android.modulators;

public final class Pulse extends Modulator {
    public Pulse() {
        super();
        setPWM(0.5);
    }

    @Override
	public double getNextSampleOfs(int ofs) {
        double value = ((mPhase + ofs) & PHASE_MASK) < mPWM ? 1.0 : -1.0;
        addPhase(1);
        return value;
    }

    @Override
    public double getNextSample() {
        double value = mPhase < mPWM ? 1.0 : -1.0;
        addPhase(1);
        return value;
    }

    public void setPWM(double value) {
        mPWM = value * PHASE_LENGTH;
    }

    private double mPWM;
}
