/*
 Copyright (c) 2009, hkrn All rights reserved.
 
 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:
 
 Redistributions of source code must retain the above copyright notice, this
 list of conditions and the following disclaimer. Redistributions in binary
 form must reproduce the above copyright notice, this list of conditions and
 the following disclaimer in the documentation and/or other materials
 provided with the distribution. Neither the name of the hkrn nor
 the names of its contributors may be used to endorse or promote products
 derived from this software without specific prior written permission. 
 
 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
 ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 DAMAGE.
 */

//
//  FCDPCM.h
//  OCMML
//
//  Created by hkrn on 09/05/16.
//  Copyright 2009 hkrn. All rights reserved.
//
//  $Id: FCDPCM.h 111 2009-05-16 12:06:04Z hikarin $
//

#import "Modulator.h"

#define kFCDPCMMaxWave 16
#define kFCDPCMCPUCycle 1789773
#define kFCDPCMPhaseShift 2
#define kFCDPCMMaxLength 0xff1
#define kFCDPCMTableMaxLength ((kFCDPCMMaxLength >> 2) + 2)
#define kFCDPCMNext (44100 << kFCDPCMPhaseShift)

@interface FCDPCM : Modulator {
    int m_address;
    int m_bit;
    int m_wave;
    int m_length;
    int m_offset;
    int m_index;
}

+ (void)setWaveWithIndex:(int)index
                  intVol:(int)intVol
                loopFlag:(int)loopFlag
              waveString:(NSString *)wave;
- (void)setWaveIndex:(int)waveIndex;
- (void)setDPCMFrequency:(int)frequency;

@end
