package jp.sourceforge.ocmml.android.modulators;

public final class GBLongNoise extends Modulator {
    private static final int GB_NOISE_PHASE_SHIFT = 12;
    private static final int GB_NOISE_PHASE_DELTA = 1 << GB_NOISE_PHASE_SHIFT;
    private static final int GB_NOISE_TABLE_LENGTH = 32767;
    private static final int GB_NOISE_TABLE_MOD = (GB_NOISE_TABLE_LENGTH << GB_NOISE_PHASE_SHIFT) - 1;

    private static void initialize() {
        if (!sInitialized) {
            long gbr = 0xffff, output = 1;
            for (int i = 0; i < GB_NOISE_TABLE_LENGTH; i++) {
                if (gbr == 0)
                    gbr = 1;
                gbr += gbr + (((gbr >> 14) ^ (gbr >> 13)) & 1);
                output ^= gbr & 1;
                sTable[i] = (int)(output * 2 - 1);
            }
            sInitialized = true;
        }
    }

    public GBLongNoise() {
        super();
        initialize();
    }

    @Override
    public double getNextSample() {
        double value = sTable[mPhase >> GB_NOISE_PHASE_SHIFT];
        if (mSkip > 0)
            value = (value + mSum) / (mSkip + 1.0);
        updateFrequency();
        return 0;
    }

    @Override
    public double getNextSampleOfs(int ofs) {
        double value = sTable[((mPhase + ofs) % GB_NOISE_TABLE_MOD) >> GB_NOISE_PHASE_SHIFT];
        mPhase = (int)(mPhase + mFrequency) % GB_NOISE_TABLE_MOD;
        return value;
    }

    @Override
    public void setFrequency(double value) {
        mFrequency = value;
    }

    public void setNoiseFrequencyIndex(int value) {
        int index = Math.min(Math.max(value, 0), 63);
        mFrequencyShift = (1048576 << (GB_NOISE_PHASE_SHIFT - 2)) / (sInterval[index] * 11025);
    }

    private void updateFrequency() {
        mSkip = mSum = 0;
        int frequencyShift = mFrequencyShift;
        while (frequencyShift > GB_NOISE_PHASE_DELTA) {
            mPhase = (mPhase + GB_NOISE_PHASE_DELTA) % GB_NOISE_TABLE_MOD;
            frequencyShift -= GB_NOISE_PHASE_DELTA;
            mSum += sTable[mPhase >> GB_NOISE_PHASE_SHIFT];
            mSkip++;
        }
        mPhase = (mPhase + frequencyShift) % GB_NOISE_TABLE_MOD;
    }

    private static Boolean sInitialized = false;
    private static int[] sTable = new int[GB_NOISE_TABLE_LENGTH];
    private static int[] sInterval = new int[] {
        0x000002, 0x000004, 0x000008, 0x00000c, 0x000010, 0x000014, 0x000018, 0x00001c,
        0x000020, 0x000028, 0x000030, 0x000038, 0x000040, 0x000050, 0x000060, 0x000070,
        0x000080, 0x0000a0, 0x0000c0, 0x0000e0, 0x000100, 0x000140, 0x000180, 0x0001c0,
        0x000200, 0x000280, 0x000300, 0x000380, 0x000400, 0x000500, 0x000600, 0x000700,
        0x000800, 0x000a00, 0x000c00, 0x000e00, 0x001000, 0x001400, 0x001800, 0x001c00,
        0x002000, 0x002800, 0x003000, 0x003800, 0x004000, 0x005000, 0x006000, 0x007000,
        0x008000, 0x00a000, 0x00c000, 0x00e000, 0x010000, 0x014000, 0x018000, 0x01c000,
        0x020000, 0x028000, 0x030000, 0x038000, 0x040000, 0x050000, 0x060000, 0x070000
    };
    private int mSum;
    private int mSkip;
}
