package jp.sourceforge.ocmml.android.modulators;

public final class Triangle extends Modulator {
    private static void initialize() {
        if (!sInitialized) {
            double d0 = 1.0 / TABLE_LENGTH, p0 = 0;
            for (int i = 0; i < TABLE_LENGTH; i++) {
                sTable[i] = p0 < 0.5 ? 1 - 4 * p0 : 1 - 4 * (1 - p0);
                p0 += d0;
            }
            sInitialized = true;
        }
    }

    public Triangle() {
        super();
        initialize();
    }

    public double getNextSampleOfs(int ofs) {
        double value = sTable[((mPhase + ofs) & PHASE_MASK) >> PHASE_SHIFT];
        addPhase(1);
        return value;
    }

    @Override
    public double getNextSample() {
        double value = sTable[mPhase >> PHASE_SHIFT];
        addPhase(1);
        return value;
    }

    private static Boolean sInitialized = false;
    private static double[] sTable = new double[TABLE_LENGTH];
}
