/*
 Copyright (c) 2009, hkrn All rights reserved.
 
 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:
 
 Redistributions of source code must retain the above copyright notice, this
 list of conditions and the following disclaimer. Redistributions in binary
 form must reproduce the above copyright notice, this list of conditions and
 the following disclaimer in the documentation and/or other materials
 provided with the distribution. Neither the name of the hkrn nor
 the names of its contributors may be used to endorse or promote products
 derived from this software without specific prior written permission. 
 
 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
 ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 DAMAGE.
 */

//
//  MMLSignal.m
//  OCMML
//
//  Created by hkrn on 09/02/07.
//  Copyright 2009 hkrn. All rights reserved.
//
//  $Id: MMLSignal.m 65 2009-04-25 12:07:49Z hikarin $
//

#import "MMLSignal.h"

@implementation MMLSignal

- (id)initWithId:(int)aSignalId
   maxEachBuffer:(int)maxEachBuffer
{
    signalId = aSignalId;
    index = 0;
    target = nil;
    selector = nil;
    millSeconds = [[NSMutableArray alloc] initWithCapacity:maxEachBuffer];
    globalTicks = [[NSMutableArray alloc] initWithCapacity:maxEachBuffer];
    events = [[NSMutableArray alloc] initWithCapacity:maxEachBuffer];
    for (int i = 0; i < maxEachBuffer; i++) {
        NSNumber *zero = [[NSNumber alloc] initWithInt:0];
        [millSeconds addObject:zero];
        [globalTicks addObject:zero];
        [events addObject:zero];
        [zero release];
    }
    NSNumber *minus = [[NSNumber alloc] initWithInt:-1];
    [millSeconds replaceObjectAtIndex:0 withObject:minus];
    [minus release];
    return self;
}

- (void)dealloc
{
    [millSeconds release];
    [globalTicks release];
    [events release];
    [super dealloc];
}

- (void)setSeletor:(SEL)aSelector
            target:(id)aTarget
{
    target = aTarget;
    selector = aSelector;
}

- (void)addMillSecond:(NSTimeInterval)ms
           globalTick:(unsigned int)gt
                event:(int)ev
{
    NSNumber *nMS = [[NSNumber alloc] initWithDouble:ms];
    [millSeconds replaceObjectAtIndex:index withObject:nMS];
    [nMS release];
    NSNumber *nGT = [[NSNumber alloc] initWithInt:gt];
    [globalTicks replaceObjectAtIndex:index withObject:nGT];
    [nGT release];
    NSNumber *nEV = [[NSNumber alloc] initWithInt:ev];
    [events replaceObjectAtIndex:index withObject:nEV];
    [nEV release];
}

- (void)terminate
{
    [self addMillSecond:-1
             globalTick:0
                  event:0];
}

- (void)reset
{
    if (selector != nil && target != nil) {
        NSNumber *n = [millSeconds objectAtIndex:index];
        while ([n doubleValue] >= 0) {
            NSNumber *gt = [globalTicks objectAtIndex:index];
            NSNumber *ev = [events objectAtIndex:index];
            [target performSelector:selector
                         withObject:gt
                         withObject:ev];
            n = [millSeconds objectAtIndex:++index];
        }
    }
    index = 0;
    NSNumber *zero = [[NSNumber alloc] initWithInt:-1];
    [millSeconds replaceObjectAtIndex:0
                           withObject:zero];
    [zero release];
}

- (void)start
{
    NSDate *now = [[NSDate alloc] init];
    preTime = [now timeIntervalSince1970];
    index = 0;
    [now release];
    [self next];
}

- (void)next
{
    NSNumber *n = [millSeconds objectAtIndex:index];
    NSTimeInterval ms = [n doubleValue];
    if (ms > 0) {
        [self performSelector:@selector(willInvokeSignal)
                   withObject:target
                   afterDelay:ms];
    }
    else if (ms == 0) {
        [self performSelector:@selector(willInvokeSignal)];
    }
}

- (void)willInvokeSignal
{
    if (target != nil && selector != nil) {
        NSNumber *gt = [globalTicks objectAtIndex:index];
        NSNumber *ev = [events objectAtIndex:index];
        [target performSelector:selector
                     withObject:gt
                     withObject:ev];
    }
    NSDate *now = [[NSDate alloc] init];
    NSNumber *n = [millSeconds objectAtIndex:index];
    NSTimeInterval aTime = [now timeIntervalSince1970];
    NSTimeInterval over = aTime - preTime - [n doubleValue];
    [now release];
    preTime = aTime;
    if (++index < [globalTicks count]) {
        NSUInteger i = index;
        n = [millSeconds objectAtIndex:i];
        NSTimeInterval ms = [n doubleValue];
        while (over > 0 && ms >= 0) {
            if (ms >= over) {
                NSNumber *newMS = [[NSNumber alloc] initWithDouble:ms - over];
                [millSeconds replaceObjectAtIndex:i
                                       withObject:newMS];
                [newMS release];
                break;
            }
            else {
                over -= ms;
                NSNumber *zero = [[NSNumber alloc] initWithDouble:0];
                [millSeconds replaceObjectAtIndex:i
                                       withObject:zero];
                [zero release];
            }
            n = [millSeconds objectAtIndex:++i];
            ms = [n doubleValue];
        }
        [self next];
    }
}

@end
