/*
 Copyright (c) 2009, hkrn All rights reserved.
 
 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:
 
 Redistributions of source code must retain the above copyright notice, this
 list of conditions and the following disclaimer. Redistributions in binary
 form must reproduce the above copyright notice, this list of conditions and
 the following disclaimer in the documentation and/or other materials
 provided with the distribution. Neither the name of the hkrn nor
 the names of its contributors may be used to endorse or promote products
 derived from this software without specific prior written permission. 
 
 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
 ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 DAMAGE.
 */

//
//  MMLEngine.h
//  OCMML
//
//  Created by hkrn on 09/02/06.
//  Copyright 2009 hkrn. All rights reserved.
//
//  $Id: MMLEngine.h 96 2009-05-06 11:48:25Z hikarin $
//

#import <OCMML/MMLFormant.h>
#import <OCMML/MMLTrack.h>
#import <OCMML/MMLSequencer.h>

FOUNDATION_EXPORT NSString *const MMLEngineDidCompile;
FOUNDATION_EXPORT NSString *const MMLEngineDidResume;

enum MMLEngineWarningType {
    kMMLEngineWarningUnknownCommand,
    kMMLEngineWarningUnclosedRepeat,
    kMMLEngineWarningUnopenedComment,
    kMMLEngineWarningUnclosedComment
};

@interface MMLEngine : NSObject
{
    MMLSequencer *m_sequencer;
    NSMutableArray *m_tracks;
    NSMutableArray *m_warnings;
    NSMutableString *m_string;
    NSUInteger m_stringLocation;
    int m_trackNo;
    int m_octave;
    BOOL m_isRelativeDir;
    int m_velocity;
    BOOL m_velocityDetail;
    int m_length;
    int m_tempo;
    BOOL m_isKeyOff;
    int m_gate;
    int m_maxGate;
    enum MMLOscillatorType m_form;
    int m_noteShift;
    int m_maxPipe;
}

- (void)play:(NSString *)string;
- (void)stop;
- (void)pause;
- (void)resume;
- (void)setSignalInterval:(int)interval;
- (MMLTrack *)createTrack;

@property(readonly) unsigned int globalTick;
@property(readonly) BOOL isPlaying;
@property(readonly) BOOL isPaused;
@property(readonly) NSArray *warnings;
@property(readonly) NSUInteger duration;
@property(readonly) NSUInteger timespan;
@property int masterVolume;

@end
