module vga_ram (
	i_rst, i_clk50, i_clk25,
	i_we, i_wrdata,
	i_re, o_rddata, 
	o_rdack
);

	input i_rst ;
	input i_clk50 ;
	input i_clk25 ;
	
	input i_we ;
	input [7:0] i_wrdata ;
	input i_re ;
	output [7:0] o_rddata ;
	
	output o_rdack ;
	
	reg [8:0] r_wradrs ;
	reg [8:0] r_rdadrs ;
	reg [8:0] r_rdadrs_buff ;
	reg r_rdack ;

	(* remstyle = "no_rw_check" *) reg [8:0] mem1[511:0] ;

	assign o_rddata = mem1[r_rdadrs] ;
	assign o_rdack = r_rdack ;
	
	always @( posedge i_clk50 ) begin
		r_rdadrs_buff <= r_rdadrs ;
		if((r_rdadrs_buff == 9'd319) & (r_rdadrs == 9'd0)) r_rdack <= 1 ;
		else if((r_rdadrs_buff == 9'd159) & (r_rdadrs == 9'd160)) r_rdack <= 1 ;
		else r_rdack <= 0 ;
	end
	
	// memory read command
	always @ ( posedge i_clk25 or posedge i_rst ) begin
		if(i_rst) begin
			r_rdadrs <= 0 ;
			r_rdadrs_buff <= 0 ;
			r_rdack <= 0 ;
		end
		else if( i_re ) begin
			if(r_rdadrs == 9'd319)	r_rdadrs <= 9'd0 ;
			else				r_rdadrs <= r_rdadrs + 9'd1 ;
		end
	end

	// memory write command
	always @ ( posedge i_clk50 or posedge i_rst ) begin
		if(i_rst) begin
			r_wradrs <= 0 ;
		end
		else if( i_we ) begin
			mem1[r_wradrs] <= i_wrdata ;

			if(r_wradrs == 9'd319)	r_wradrs <= 9'd0 ;
			else				r_wradrs <= r_wradrs + 9'd1 ;
		end
	end
endmodule