#include <cppunit/extensions/HelperMacros.h> //
#include "SPI_controler_top.h"

// 以下はSPIControlerTestクラスの宣言-----
class SPIControlerTest : public CPPUNIT_NS::TestFixture { //
	CPPUNIT_TEST_SUITE( SPIControlerTest ); //
	CPPUNIT_TEST( test_init );         //
	CPPUNIT_TEST( test_incr );         //
	CPPUNIT_TEST( test_clear );        //
	CPPUNIT_TEST_SUITE_END();          //

	public:
	SPIControlerTest();
	~SPIControlerTest();
	void setUp();      //
	void tearDown();   //

	protected:
	void test_init();  //
	void test_incr();  //
	void test_clear(); //
};
	SPIControlerTop* c_ ;

// 以下はSPIControlerTestクラスの実装-----
CPPUNIT_TEST_SUITE_REGISTRATION( SPIControlerTest ); //

SPIControlerTest::SPIControlerTest( )
{
	if(c_==NULL){
		c_ = new SPIControlerTop();
	}
}
SPIControlerTest::~SPIControlerTest( ) 
{
}
// 各テスト・ケースの実行直前に呼ばれる
void SPIControlerTest::setUp() {
}

// 各テスト・ケースの実行直後に呼ばれる
void SPIControlerTest::tearDown() {
}

// これ以降はテスト・ケースの実装内容

void SPIControlerTest::test_init() {
	c_->nextStep(); //
	c_->reset();
	c_->nextStep(); //
	CPPUNIT_ASSERT_EQUAL(0,(int) c_->read_MISO()); //
}

void SPIControlerTest::test_incr() {
	for ( int i = 1; i < 10; ++i ) {
		CPPUNIT_ASSERT_EQUAL(i,(int) c_->read_MISO()); //
	}
}

void SPIControlerTest::test_clear() {
	c_->nextStep(); //
	c_->reset();
	c_->nextStep(); //
	CPPUNIT_ASSERT_EQUAL(0,(int) c_->read_MISO()); //
} 
