/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.io;

import com.sk_jp.text.Translator;
import com.sk_jp.text.html.TagReformatter;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.io.Writer;

public class TranslatedWriter
extends FilterWriter {
    private static TranslatedWriter defaultHTMLWriter = null;
    private PipeThread lastPipeThread = null;
    private Writer sourceWriter = this.out;
    private boolean started = false;
    private IOException exception;

    public static TranslatedWriter getDefaultHTMLWriter(Writer writer) {
        if (defaultHTMLWriter == null) {
            TagReformatter tagReformatter = new TagReformatter();
            defaultHTMLWriter = new TranslatedWriter(writer, tagReformatter);
        }
        return defaultHTMLWriter;
    }

    public TranslatedWriter(Writer writer) {
        this(writer, null);
    }

    public TranslatedWriter(Writer writer, Translator translator) {
        super(writer);
        this.addTranslator(translator);
    }

    public void addTranslator(Translator translator) {
        if (translator == null) {
            return;
        }
        if (this.started) {
            throw new IllegalStateException("write() is already called.");
        }
        try {
            PipedWriter pipedWriter = new PipedWriter();
            PipeThread pipeThread = new PipeThread(translator, new PipedReader(pipedWriter), this.sourceWriter, this.lastPipeThread);
            if (this.lastPipeThread == null) {
                this.out = pipedWriter;
            } else {
                this.lastPipeThread.writer = pipedWriter;
            }
            this.lastPipeThread = pipeThread;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    private void start() {
        this.started = true;
        PipeThread pipeThread = this.lastPipeThread;
        while (pipeThread != null) {
            pipeThread.start();
            pipeThread = pipeThread.next;
        }
    }

    private synchronized void setException(IOException iOException) {
        if (this.exception == null) {
            this.exception = iOException;
        }
    }

    public boolean isError() {
        return this.exception != null;
    }

    public IOException getException() {
        return this.exception;
    }

    public void write(int n) throws IOException {
        if (!this.started) {
            this.start();
        }
        this.out.write(n);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (!this.started) {
            this.start();
        }
        this.out.write(cArray, n, n2);
    }

    public void write(String string, int n, int n2) throws IOException {
        if (!this.started) {
            this.start();
        }
        this.out.write(string, n, n2);
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        char[] cArray = new char[1024];
        InputStreamReader inputStreamReader = new InputStreamReader(System.in, "JISAutoDetect");
        TranslatedWriter translatedWriter = TranslatedWriter.getDefaultHTMLWriter(new OutputStreamWriter(System.out));
        while ((n = inputStreamReader.read(cArray)) != -1) {
            translatedWriter.write(cArray, 0, n);
            translatedWriter.flush();
        }
        translatedWriter.close();
    }

    class PipeThread
    extends Thread {
        Translator translator;
        Reader reader;
        Writer writer;
        PipeThread next;

        public PipeThread(Translator translator, Reader reader, Writer writer, PipeThread pipeThread) {
            this.translator = translator;
            this.reader = reader;
            this.writer = writer;
            this.next = pipeThread;
        }

        public void run() {
            try {
                this.translator.translate(this.reader, this.writer);
            }
            catch (IOException iOException) {
                TranslatedWriter.this.setException(iOException);
            }
        }
    }
}

