

#-------------------------------------------------------------------------------
# バージョン設定
#-------------------------------------------------------------------------------
rfile="../../configure.in"

MajorVersion=`grep -e "^AC_SUBST(\[M" <$rfile |sed 's/.*\[//' |sed 's/\].*//'`
MinorVersion=`grep -e "^AC_SUBST(\[S" <$rfile |sed 's/.*\[//' |sed 's/\])//'| awk 'BEGIN { FS = ":"}; { print $1 }'`
revision=`    grep -e "^AC_SUBST(\[S" <$rfile |sed 's/.*\[//' |sed 's/\])//'| awk 'BEGIN { FS = ":"}; { print $2 }'`

version=$MajorVersion.$MinorVersion

#--------------

rm -rf build
mkdir build
mkdir build/kgmod
mkdir build/mcmd

mname=mcmd-$version-$revision
for fname in `ls ../../cmd/m*.cpp` ; do
	fname=${fname##*/}
	fname=${fname%.cpp}
	cp /usr/local/bin/$fname ./build/mcmd
done


pkgbuild --identifier jp.mcmd.pkg  --version $version --root ./build/mcmd --install-location /usr/local/bin ./build/$mname.pkg


kname=kgmod-$version-$revision
# シンボリックリンクのコピーには-Rを指定する
cp -R /usr/local/lib/libmcmd$MajorVersion*.dylib ./build/kgmod
pkgbuild --identifier jp.kgmod.pkg --version $version --root ./build/kgmod --install-location /usr/local/lib ./build/$kname.pkg

hdiutil create -srcfolder ./build ./build/$mname.dmg

mv build/$mname.dmg ../PACKAGE

