/* ////////// LICENSE INFO ////////////////////

 * Copyright (C) 2013 by NYSOL CORPORATION
 *
 * Unless you have received this program directly from NYSOL pursuant
 * to the terms of a commercial license agreement with NYSOL, then
 * this program is licensed to you under the terms of the GNU Affero General
 * Public License (AGPL) as published by the Free Software Foundation,
 * either version 3 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY EXPRESS OR IMPLIED WARRANTY, INCLUDING THOSE OF 
 * NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Please refer to the AGPL (http://www.gnu.org/licenses/agpl-3.0.txt)
 * for more details.

 ////////// LICENSE INFO ////////////////////*/
// =============================================================================
// kgvdelim.cpp ベクトル区切り文字の変更クラス
// =============================================================================
#include <cstdio>
#include <sstream>
#include <vector>
#include <kgvdelim.h>
#include <kgError.h>
#include <kgMethod.h>
#include <kgConfig.h>

using namespace std;
using namespace kglib;
using namespace kgmod;

// -----------------------------------------------------------------------------
// コンストラクタ(モジュール名，バージョン登録)
// -----------------------------------------------------------------------------
kgVdelim::kgVdelim(void)
{
	#ifdef ENG_FORMAT
		#include <help/en/kgvdelimHelp.h>
	#else
		#include <help/jp/kgvdelimHelp.h>
	#endif
	_name    = "kgvdelim";
	_version = "1.0";
}
// -----------------------------------------------------------------------------
// パラメータセット＆入出力ファイルオープン
// -----------------------------------------------------------------------------
void kgVdelim::setArgs(void)
{
	// パラメータチェック
	_args.paramcheck("i=,o=,vf=,v=,delim=");

	// 入出力ファイルオープン
	_iFile.open(_args.toString("i=",false),_env,_nfn_i);
	_oFile.open(_args.toString("o=",false),_env,_nfn_o);
	_iFile.read_header();

	// vf= 項目引数のセット
	vector< vector<kgstr_t> > vvs = _args.toStringVecVec("vf=","%:",2,true);
	_vfField.set(vvs, &_iFile,_fldByNum, false); // 項目名展開は行わない

	kgstr_t s_d = _args.toString("delim=",false);
	if(s_d.empty()){	
		_delim=' ';
	}else if(s_d.size()!=1){
		ostringstream ss;
		ss << "delim= takes 1 byte charactor (" << s_d << ")";
		throw kgError(ss.str());
	}else{
		_delim=*(s_d.c_str());
	}

	_vStr = _args.toString("v=",true);

}
// -----------------------------------------------------------------------------
// 実行
// -----------------------------------------------------------------------------
void kgVdelim::run(void) try 
{
	// パラメータセット＆入出力ファイルオープン
	setArgs();

	// 項目名出力
  _oFile.writeFldName(_iFile);

	//文字列生成用領域
	char delimstr[2];
	delimstr[0] =_delim;
	delimstr[1] ='\0';
	char buf[KG_MAX_STR_LEN];

	while(EOF != _iFile.read() ){

		for(size_t i=0; i<_iFile.fldSize(); i++){

			char* str=_iFile.getVal(i);

			// 対象項目
			if(_vfField.flg(i)!=-1){
				// itemset項目を" "でトークン分割して新しいdelimに置き換え
				*buf = '\0'; 
				int len = 0; 
				vector<char*> eachItem = splitToken(str,_delim);
				for(vector<char*>::iterator j=eachItem.begin(); j!=eachItem.end(); j++){
					len += (strlen(_vStr.c_str())+strlen(*j));
					if(len>=KG_MAX_STR_LEN){ throw kgError("field length exceeded KG_MAX_STR_LEN");}
					if(*buf!='\0'&&!_vStr.empty()){
						strcat(buf,_vStr.c_str());
					}
					strcat(buf,*j);
				}
				if(i+1==_iFile.fldSize()) _oFile.writeStr(buf,true );
				else                      _oFile.writeStr(buf,false);

			}
			// 対象外項目
			else{
				if(i+1==_iFile.fldSize()) _oFile.writeStr(str,true );
				else                      _oFile.writeStr(str,false);
			}
		}
	}

	// 終了処理
	_iFile.close();
	_oFile.close();
	successEnd();

// 例外catcher
}catch(kgError& err){

	errorEnd(err);

}
