/* ////////// LICENSE INFO ////////////////////

 * Copyright (C) 2013 by NYSOL CORPORATION
 *
 * Unless you have received this program directly from NYSOL pursuant
 * to the terms of a commercial license agreement with NYSOL, then
 * this program is licensed to you under the terms of the GNU Affero General
 * Public License (AGPL) as published by the Free Software Foundation,
 * either version 3 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY EXPRESS OR IMPLIED WARRANTY, INCLUDING THOSE OF 
 * NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Please refer to the AGPL (http://www.gnu.org/licenses/agpl-3.0.txt)
 * for more details.

 ////////// LICENSE INFO ////////////////////*/
// =============================================================================
/// kgvcommonHelp.h : kgvcommon help
// =============================================================================
_title="ベクトル要素の参照選択";
_doc="\
mvcommon ベクトル要素の参照選択\n\
===============================\n\
ベクトルから、参照ファイルで指定された要素を選択する。\n\
\n\
書式\n\
----\n\
mvcommon vf= K= [-r] m=| i= [o=] [delim=] [-nfn] [-nfno] [-x] [--help][--version]  \n\
\n\
  vf=   結合キーとなるアイテム集合の項目名(i=ファイル上)を指定する。\n\
        複数項目指定可能。アイテムはソーティングされている必要はない。\n\
        コロンに続いて新項目名を指定すれば、要素が選択された後のベクトル項目が新たに出力される。\n\
  m=    参照ファイルを指定する。\n\
        このパラメータが省略された時には標準入力が用いられる。(i=指定ありの場合)\n\
  K=    参照ファイル(m=)上の結合キーとなるアイテムの項目名を指定する。\n\
  -r    vf=とK=の要素がマッチしない要素を選択する。\n\
\n\
利用例\n\
------\n\
例1: 複数項目に対して結合する例\n\
\n\
    $ more dat1.csv\n\
    items1,items2\n\
    b a c,b b\n\
    c c,a d\n\
    e a a,a a\n\
    $ more ref1.csv\n\
    item\n\
    a\n\
    c\n\
    e\n\
    $ mvcommon vf=items1,items2 K=item m=ref1.csv i=dat1.csv o=rsl1.csv\n\
    #END# kgvcommon K=item i=dat1.csv m=ref1.csv o=rsl1.csv vf=items1,items2\n\
    $ more rsl1.csv\n\
    items1,items2\n\
    a c,\n\
    c c,a\n\
    e a a,a a\n\
\n\
例2: 新項目名を指定する例\n\
\n\
item2にのみ新項目名newを指定しているので、 新しい項目として出力される。\n\
\n\
    $ mvcommon vf=items1,items2:new2 K=item m=ref1.csv i=dat1.csv o=rsl2.csv\n\
    #END# kgvcommon K=item i=dat1.csv m=ref1.csv o=rsl2.csv vf=items1,items2:new2\n\
    $ more rsl2.csv\n\
    items1,items2,new2\n\
    a c,b b,\n\
    c c,a d,a\n\
    e a a,a a,a a\n\
";

