
rfile="../../configure.in"
MajorVersion=`grep -e "^AC_SUBST(\[M" <$rfile |sed 's/.*\[//' |sed 's/\].*//'`
MinorVersion=`grep -e "^AC_SUBST(\[S" <$rfile |sed 's/.*\[//' |sed 's/\])//'| awk 'BEGIN { FS = ":"}; { print $1 }'`
revision=`    grep -e "^AC_SUBST(\[S" <$rfile |sed 's/.*\[//' |sed 's/\])//'| awk 'BEGIN { FS = ":"}; { print $2 }'` 

ARCH=`arch`
echo $ARCH

if [ `echo $ARCH|grep ^i` ]; then
	Arch="i386"
else
	Arch="x86_64"
fi

version=$MajorVersion.$MinorVersion

echo "%_topdir ${HOME}/rpm" >~/.rpmmacros

mkdir -p ${HOME}/rpm
mkdir -p ${HOME}/rpm/${Arch}
mkdir -p ${HOME}/rpm/BUILD
mkdir -p ${HOME}/rpm/SOURCES
mkdir -p ${HOME}/rpm/RPMS
mkdir -p ${HOME}/rpm/SPECS
mkdir -p ${HOME}/rpm/SRPMS

(cd ../.. && make dist && cp mcmd-$version.tar.gz ${HOME}/rpm/SOURCES)

sed "s/##version##/$version/" <mcmd.spec |
sed "s/##revision##/$revision/" >${HOME}/rpm/SPECS/mcmd.spec

(cd ${HOME}/rpm/SPECS && rpmbuild -bb mcmd.spec)
(cd ${HOME}/rpm/RPMS/${Arch} && sudo alien -k mcmd-${version}-${revision}.${Arch}.rpm)
cp ${HOME}/rpm/RPMS/${Arch}/mcmd*${version}-${revision}* ../PACKAGE

echo "#####################"
echo "completed!"
echo "`ls ../PACKAGE/mcmd*$version-$revision*`"

