/* ////////// LICENSE INFO ////////////////////

 * Copyright (C) 2013 by NYSOL CORPORATION
 *
 * Unless you have received this program directly from NYSOL pursuant
 * to the terms of a commercial license agreement with NYSOL, then
 * this program is licensed to you under the terms of the GNU Affero General
 * Public License (AGPL) as published by the Free Software Foundation,
 * either version 3 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY EXPRESS OR IMPLIED WARRANTY, INCLUDING THOSE OF 
 * NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Please refer to the AGPL (http://www.gnu.org/licenses/agpl-3.0.txt)
 * for more details.

 ////////// LICENSE INFO ////////////////////*/
// =============================================================================
// kgvreplace.cpp ベクトル要素の参照置換クラス
// =============================================================================
#include <cstdio>
#include <sstream>
#include <vector>
#include <map>
#include <kgvreplace.h>
#include <kgError.h>
#include <kgMethod.h>
#include <kgConfig.h>

using namespace std;
using namespace kglib;
using namespace kgmod;

// -----------------------------------------------------------------------------
// コンストラクタ(モジュール名，バージョン登録)
// -----------------------------------------------------------------------------
kgVreplace::kgVreplace(void)
{
	#ifdef ENG_FORMAT
		#include <help/en/kgvreplaceHelp.h>
	#else
		#include <help/jp/kgvreplaceHelp.h>
	#endif
	_name    = "kgvreplace";
	_version = "1.0";
}

// -----------------------------------------------------------------------------
// パラメータセット＆入出力ファイルオープン
// -----------------------------------------------------------------------------
void kgVreplace::setArgs(void)
{
	// パラメータチェック
	_args.paramcheck("i=,o=,m=,n=,vf=,f=,K=,delim=");

	// 入出力ファイルオープン
	_iFile.open(_args.toString("i=",false),_env,_nfn_i);
	_oFile.open(_args.toString("o=",false),_env,_nfn_o);
	_mFile.open(_args.toString("m=",true),_env,_nfn_i);
	_iFile.read_header();
	_mFile.read_header();

	// vf= 項目引数のセット
	vector < vector<kgstr_t> >  vs = _args.toStringVecVec("vf=","%:",2,true);
	_vfField.set(vs, &_iFile,_fldByNum);

	// f= 項目引数のセット
	vector<kgstr_t>  vsf = _args.toStringVector("f=",true);
	if(vsf.size()!=1){ throw kgError("f= takes just one item "); }
	_fField.set(vsf, &_mFile,_fldByNum);

	// n= 項目引数のセット
	_nullVal = _args.toString("n=",false);

	// delim= 項目引数のセット
	kgstr_t s_d = _args.toString("delim=",false);
	if(s_d.empty()){	
		_delim=' ';
	}else if(s_d.size()!=1){
		ostringstream ss;
		ss << "delim= takes 1 byte charactor (" << s_d << ")";
		throw kgError(ss.str());
	}else{
		_delim=*(s_d.c_str());
	}
	
	// K= 項目引数のセット
	vector<kgstr_t>  vs2 = _args.toStringVector("K=",true);
	if(vs2.size()!=1){ throw kgError("K= takes just one item "); }
	_mkField.set(vs2, &_mFile,_fldByNum);	

}

// -----------------------------------------------------------------------------
// 実行
// -----------------------------------------------------------------------------
void kgVreplace::run(void) try 
{
	// パラメータセット＆入出力ファイルオープン
	setArgs();

	// 参照ファイルからitemのhash表を作成する
	map<kgstr_t,kgstr_t> itmSet; 
	while(EOF != _mFile.read() ){
		const char* item = _mFile.getVal(_mkField.num(0));
		const char* taxo = _mFile.getVal(_fField.num(0));
		itmSet[item]=taxo;
	}

	//文字列生成用領域
	char delimstr[2];
	delimstr[0] =_delim;
	delimstr[1] ='\0';
	vector<kgAutoPtr2<char> > rls_ap;
	rls_ap.resize(_vfField.size());
	for(unsigned int i=0;i<_vfField.size();i++){
		try {
			rls_ap.at(i).set(new char[KG_MAX_STR_LEN]);
		} catch(...) {
			throw kgError("memory allocation error ");
		}
	}	

	// 項目名出力
	vector<kgstr_t> addname;
	for(kgstr_t::size_type i=0 ; i< _vfField.attrSize() ;i++){
		if(!_vfField.attr(i).empty()){ addname.push_back(_vfField.attr(i));}
	}
	_oFile.writeFldName(_iFile,addname);

	// データ出力
	int outsize = _iFile.fldSize()+addname.size();
	while(EOF != _iFile.read() ){
		int outcnt=0;
		for(size_t i=0; i<_iFile.fldSize(); i++){

			outcnt++;
			char* str=_iFile.getVal(i);

			if(_vfField.flg(i)==-1||!_vfField.attr(_vfField.flg(i)).empty()){
				if(outcnt==outsize) _oFile.writeStr(str,true );
				else                _oFile.writeStr(str,false);
			}

			if(_vfField.flg(i)!=-1){
				// itemset項目を" "でトークン分割
				char *buf = rls_ap.at(_vfField.flg(i)).get();
				*buf='\0';
				int len=0;
				vector<char*> eachItem = splitToken( str ,_delim);
				for(vector<char*>::iterator j=eachItem.begin(); j!=eachItem.end(); j++){
					if(itmSet.find(*j)!=itmSet.end()){
						len += ( strlen(delimstr)+strlen(itmSet[*j].c_str()) );
						if(len>=KG_MAX_STR_LEN){ throw kgError("field length exceeded KG_MAX_STR_LEN");}
						if(*buf!='\0'){ strcat(buf,delimstr);}
						strcat(buf,itmSet[*j].c_str());
					}
					else{
						if(!_nullVal.empty()){
							len += ( strlen(delimstr)+strlen(_nullVal.c_str()) );
							if(len>=KG_MAX_STR_LEN){ throw kgError("field length exceeded KG_MAX_STR_LEN");}
							if(*buf!='\0'){ strcat(buf,delimstr);}
							strcat(buf,_nullVal.c_str());
						}
						else{
							len += ( strlen(delimstr)+strlen(*j) );
							if(len>=KG_MAX_STR_LEN){ throw kgError("field length exceeded KG_MAX_STR_LEN");}
							if(*buf!='\0'){ strcat(buf,delimstr);}
							strcat(buf,*j);
						}
					}
				}
				if(_vfField.attr(_vfField.flg(i)).empty()){
					if(outcnt==outsize) _oFile.writeStr(buf,true );
					else 		            _oFile.writeStr(buf,false);
				}
			}

		}

		//追加出力
		for(kgstr_t::size_type i=0 ; i< _vfField.attrSize() ;i++){
			if(_vfField.attr(i)!=""){ 
				outcnt++;
				if(outcnt==outsize) _oFile.writeStr(rls_ap.at(i).get(),true );
				else           _oFile.writeStr(rls_ap.at(i).get(),false);
			}
		}
		
	}
	_iFile.close();
	_mFile.close();
	_oFile.close();

	// 終了処理(メッセージ出力,thread pipe終了通知)
	successEnd();

// 例外catcher
}catch(kgError& err){
	errorEnd(err);
}catch(...){
	errorEnd();
}
