/* ////////// LICENSE INFO ////////////////////

 * Copyright (C) 2013 by NYSOL CORPORATION
 *
 * Unless you have received this program directly from NYSOL pursuant
 * to the terms of a commercial license agreement with NYSOL, then
 * this program is licensed to you under the terms of the GNU Affero General
 * Public License (AGPL) as published by the Free Software Foundation,
 * either version 3 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY EXPRESS OR IMPLIED WARRANTY, INCLUDING THOSE OF 
 * NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Please refer to the AGPL (http://www.gnu.org/licenses/agpl-3.0.txt)
 * for more details.

 ////////// LICENSE INFO ////////////////////*/
// =============================================================================
// kgfldname.cpp 項目名の変更
// =============================================================================
#include <cstdio>
#include <kgfldname.h>
#include <kgError.h>
#include <kgConfig.h>

using namespace std;
using namespace kglib;
using namespace kgmod;

// -----------------------------------------------------------------------------
// コンストラクタ(モジュール名，バージョン登録)
// -----------------------------------------------------------------------------
kgFldname::kgFldname(void)
{
	#ifdef ENG_FORMAT
		#include <help/en/kgfldnameHelp.h>
	#else
		#include <help/jp/kgfldnameHelp.h>
	#endif
	_name    = "kgfldname";
	_version = "1.0";
}
// -----------------------------------------------------------------------------
// パラメータセット＆入出力ファイルオープン
// -----------------------------------------------------------------------------
void kgFldname::setArgs(void)
{
	// パラメータチェック
	_args.paramcheck("i=,o=,f=,n=,-nfni");

	// -nfniを指定した場合、-xも指定されていることにする
	bool nfniflg = _args.toBool("-nfni");
	if(nfniflg){ 
		_nfn_i =nfniflg;
		_fldByNum = true;
	}

	// 入出力ファイルオープン
	_iFile.open(_args.toString("i=",false), _env,_nfn_i);
  _oFile.open(_args.toString("o=",false), _env,_nfn_o);
	_iFile.read_header();

	// 変更項目名セット f= or n=
	if(! _nfn_o){
		vector< vector<kgstr_t> > vvs = _args.toStringVecVec("f=",':',2,false);
		if( ! vvs.at(0).empty()){
			if(_nfn_i){
				throw kgError("`-nfni' cannot be specified with `f='");
			}
			_fField.set(vvs, &_iFile, _fldByNum);
		}else{
			vector<kgstr_t> vs = _args.toStringVector("n=",false);
			if(vs.size() == 0 ){
				throw kgError("`f=' or `n=' or `-nfno' must be specified.");
			}
			for(size_t i=0; i<vs.size(); i++){
				newFldName_.push_back(vs.at(i));
			}
		}
	}
}

// -----------------------------------------------------------------------------
// 実行
// -----------------------------------------------------------------------------
void kgFldname::run(void) try 
{
	// パラメータセット＆入出力ファイルオープン
	setArgs();

	//項目名出力
	if(! _nfn_o){
		if(newFldName_.size()>0){
			if(newFldName_.size() == _iFile.fldSize()){
  			_oFile.writeFldName(newFldName_);
			}else{
				throw kgError("the number of fields is different on `n=' and input data.");
			}
		}else{
  		_oFile.writeFldName(_fField, true);
		}
	}

	// データ出力
	while(EOF != _iFile.read()){
  	_oFile.writeRec(_iFile.getRec());
	}

	// 終了処理
	_iFile.close();
	_oFile.close();
	successEnd();

}catch(kgError& err){
	errorEnd(err);
}
